/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public class PsiAwareFileEditorManagerImpl
extends FileEditorManagerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.text.PsiAwareFileEditorManagerImpl");
    private final PsiManager myPsiManager;
    private final WolfTheProblemSolver myProblemSolver;
    private final MyPsiTreeChangeListener myPsiTreeChangeListener;
    private final WolfTheProblemSolver.ProblemListener myProblemListener;

    public PsiAwareFileEditorManagerImpl(Project project2, PsiManager psiManager, WolfTheProblemSolver problemSolver, DockManager dockManager) {
        super(project2, dockManager);
        this.myPsiManager = psiManager;
        this.myProblemSolver = problemSolver;
        this.myPsiTreeChangeListener = new MyPsiTreeChangeListener();
        this.myProblemListener = new MyProblemListener();
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
        project2.getMessageBus().connect().subscribe(PowerSaveMode.TOPIC, (Object)new PowerSaveMode.Listener(){

            @Override
            public void powerSaveStateChanged() {
                for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                    ((EditorEx)editor).reinitSettings();
                }
            }
        });
    }

    @Override
    protected void projectOpened(@NotNull MessageBusConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl", "projectOpened"));
        }
        super.projectOpened(connection);
        this.myPsiManager.addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
        this.myProblemSolver.addProblemListener(this.myProblemListener);
    }

    @Override
    public boolean isProblem(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl", "isProblem"));
        }
        return this.myProblemSolver.isProblemFile(file2);
    }

    @Override
    @NotNull
    public String getFileTooltipText(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl", "getFileTooltipText"));
        }
        StringBuilder tooltipText = new StringBuilder();
        Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)this.getProject());
        if (module2 != null) {
            tooltipText.append("[");
            tooltipText.append(module2.getName());
            tooltipText.append("] ");
        }
        tooltipText.append(FileUtil.getLocationRelativeToUserHome((String)file2.getPresentableUrl()));
        String string = tooltipText.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl", "getFileTooltipText"));
        }
        return string;
    }

    @Override
    protected Editor getOpenedEditor(@NotNull Editor editor, boolean focusEditor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl", "getOpenedEditor"));
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        Document document2 = editor.getDocument();
        PsiFile psiFile = documentManager.getPsiFile(document2);
        if (!focusEditor || documentManager.isUncommited(document2)) {
            return editor;
        }
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, psiFile);
    }

    private class MyProblemListener
    extends WolfTheProblemSolver.ProblemListener {
        private MyProblemListener() {
        }

        public void problemsAppeared(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyProblemListener", "problemsAppeared"));
            }
            this.updateFile(file2);
        }

        public void problemsDisappeared(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyProblemListener", "problemsDisappeared"));
            }
            this.updateFile(file2);
        }

        public void problemsChanged(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyProblemListener", "problemsChanged"));
            }
            this.updateFile(file2);
        }

        private void updateFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyProblemListener", "updateFile"));
            }
            PsiAwareFileEditorManagerImpl.this.queueUpdateFile(file2);
        }
    }

    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeListener() {
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyPsiTreeChangeListener", "propertyChanged"));
            }
            if ("roots".equals(e.getPropertyName())) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                VirtualFile[] openFiles = PsiAwareFileEditorManagerImpl.this.getOpenFiles();
                for (int i = openFiles.length - 1; i >= 0; --i) {
                    VirtualFile file2 = openFiles[i];
                    LOG.assertTrue(file2 != null);
                    PsiAwareFileEditorManagerImpl.this.updateFileIcon(file2);
                }
            }
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyPsiTreeChangeListener", "childAdded"));
            }
            this.doChange(event);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyPsiTreeChangeListener", "childRemoved"));
            }
            this.doChange(event);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyPsiTreeChangeListener", "childReplaced"));
            }
            this.doChange(event);
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyPsiTreeChangeListener", "childMoved"));
            }
            this.doChange(event);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyPsiTreeChangeListener", "childrenChanged"));
            }
            this.doChange(event);
        }

        private void doChange(PsiTreeChangeEvent event) {
            PsiFile psiFile = event.getFile();
            if (psiFile == null) {
                return;
            }
            VirtualFile file2 = psiFile.getVirtualFile();
            if (file2 == null) {
                return;
            }
            FileEditor[] editors = PsiAwareFileEditorManagerImpl.this.getAllEditors(file2);
            if (editors.length == 0) {
                return;
            }
            VirtualFile currentFile = PsiAwareFileEditorManagerImpl.this.getCurrentFile();
            if (currentFile != null && Comparing.equal((Object)psiFile.getVirtualFile(), (Object)currentFile)) {
                PsiAwareFileEditorManagerImpl.this.updateFileIcon(currentFile);
            }
        }
    }
}

