/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.keymap.impl.ui.ShortcutPanel;
import com.intellij.openapi.keymap.impl.ui.ShortcutTextField;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.KeyStroke;

final class KeyboardShortcutPanel
extends ShortcutPanel<KeyboardShortcut> {
    final ShortcutTextField myFirstStroke = new ShortcutTextField();
    final ShortcutTextField mySecondStroke = new ShortcutTextField();
    final JCheckBox mySecondStrokeEnable = new JCheckBox();
    private final ItemListener myItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent event) {
            boolean enabled = KeyboardShortcutPanel.this.mySecondStrokeEnable.isSelected();
            KeyboardShortcutPanel.this.mySecondStroke.setEnabled(enabled);
            ShortcutTextField component = !enabled || null == KeyboardShortcutPanel.this.myFirstStroke.getKeyStroke() ? KeyboardShortcutPanel.this.myFirstStroke : KeyboardShortcutPanel.this.mySecondStroke;
            KeyboardShortcutPanel.this.setShortcut(KeyboardShortcutPanel.this.newShortcut());
            component.requestFocus();
        }
    };
    private final PropertyChangeListener myPropertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (KeyboardShortcutPanel.this != event.getSource()) {
                KeyboardShortcutPanel.this.setShortcut(KeyboardShortcutPanel.this.newShortcut());
                if (null == KeyboardShortcutPanel.this.myFirstStroke.getKeyStroke()) {
                    KeyboardShortcutPanel.this.myFirstStroke.requestFocus();
                } else if (null == KeyboardShortcutPanel.this.mySecondStroke.getKeyStroke() && KeyboardShortcutPanel.this.mySecondStrokeEnable.isSelected()) {
                    KeyboardShortcutPanel.this.mySecondStroke.requestFocus();
                }
            } else if (event.getNewValue() instanceof KeyboardShortcut) {
                KeyboardShortcut shortcut = (KeyboardShortcut)event.getNewValue();
                KeyboardShortcutPanel.this.myFirstStroke.setKeyStroke(shortcut.getFirstKeyStroke());
                KeyboardShortcutPanel.this.mySecondStroke.setKeyStroke(shortcut.getSecondKeyStroke());
            } else {
                KeyboardShortcutPanel.this.myFirstStroke.setKeyStroke(null);
                KeyboardShortcutPanel.this.mySecondStroke.setKeyStroke(null);
            }
        }
    };

    KeyboardShortcutPanel(LayoutManager layout) {
        super(layout);
        this.addPropertyChangeListener("shortcut", this.myPropertyListener);
        this.myFirstStroke.addPropertyChangeListener("keyStroke", this.myPropertyListener);
        this.mySecondStroke.addPropertyChangeListener("keyStroke", this.myPropertyListener);
        this.mySecondStroke.setEnabled(false);
        this.mySecondStrokeEnable.addItemListener(this.myItemListener);
    }

    private KeyboardShortcut newShortcut() {
        KeyStroke key2 = this.myFirstStroke.getKeyStroke();
        return key2 == null ? null : new KeyboardShortcut(key2, !this.mySecondStrokeEnable.isSelected() ? null : this.mySecondStroke.getKeyStroke());
    }
}

