/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.GlassPanel;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.IdentityHashMap;
import javax.swing.JComponent;

abstract class SpotlightPainter
extends AbstractPainter {
    private final IdentityHashMap<Configurable, String> myConfigurableOption = new IdentityHashMap();
    private final MergingUpdateQueue myQueue;
    private final GlassPanel myGlassPanel;
    private final JComponent myTarget;
    boolean myVisible;

    SpotlightPainter(JComponent target, Disposable parent) {
        this.myQueue = new MergingUpdateQueue("SettingsSpotlight", 200, false, target, parent, target);
        this.myGlassPanel = new GlassPanel(target);
        this.myTarget = target;
        IdeGlassPaneUtil.installPainter((JComponent)target, (Painter)this, (Disposable)parent);
    }

    public void executePaint(Component component, Graphics2D g) {
        if (this.myVisible && this.myGlassPanel.isVisible()) {
            this.myGlassPanel.paintSpotlight(g, this.myTarget);
        }
    }

    public boolean needsRepaint() {
        return true;
    }

    void updateLater() {
        this.myQueue.queue(new Update((Object)this){

            public void run() {
                SpotlightPainter.this.updateNow();
            }
        });
    }

    abstract void updateNow();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void update(SettingsFilter filter, Configurable configurable, JComponent component) {
        if (configurable == null) {
            this.myGlassPanel.clear();
            this.myVisible = false;
        } else if (component != null) {
            this.myGlassPanel.clear();
            text = filter.getFilterText();
            this.myVisible = text.isEmpty() == false;
            try {
                searchable = new SearchableConfigurable.Delegate(configurable);
                SearchUtil.lightOptions((SearchableConfigurable)searchable, component, text, this.myGlassPanel).run();
                search = searchable.enableSearch(text);
                if (search == null || filter.contains(configurable) || text.equals(this.myConfigurableOption.get(configurable))) ** GOTO lbl23
                search.run();
            }
            finally {
                this.myConfigurableOption.put(configurable, text);
            }
        } else if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.updateLater();
            return;
        }
lbl23:
        // 5 sources

        this.fireNeedsRepaint(this.myGlassPanel);
    }
}

