/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.SdkFinder;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleJdkOrderEntryImpl
extends LibraryOrderEntryBaseImpl
implements WritableOrderEntry,
ClonableOrderEntry,
ModuleJdkOrderEntry,
ProjectJdkTable.Listener {
    @NonNls
    public static final String ENTRY_TYPE = "jdk";
    @NonNls
    public static final String JDK_NAME_ATTR = "jdkName";
    @NonNls
    public static final String JDK_TYPE_ATTR = "jdkType";
    @Nullable
    private Sdk myJdk;
    private String myJdkName;
    private String myJdkType;

    ModuleJdkOrderEntryImpl(@NotNull Sdk projectJdk, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (projectJdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectJdk", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "<init>"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "<init>"));
        }
        if (projectRootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootManager", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "<init>"));
        }
        super(rootModel, projectRootManager);
        this.init(projectJdk, null, null);
    }

    ModuleJdkOrderEntryImpl(@NotNull Element element, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        String jdkType;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "<init>"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "<init>"));
        }
        if (projectRootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootManager", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "<init>"));
        }
        super(rootModel, projectRootManager);
        if (!element.getName().equals("orderEntry")) {
            throw new InvalidDataException();
        }
        Attribute jdkNameAttribute = element.getAttribute(JDK_NAME_ATTR);
        if (jdkNameAttribute == null) {
            throw new InvalidDataException();
        }
        String jdkName = jdkNameAttribute.getValue();
        Sdk jdkByName = ModuleJdkOrderEntryImpl.findJdk(jdkName, jdkType = element.getAttributeValue(JDK_TYPE_ATTR));
        if (jdkByName == null) {
            this.init(null, jdkName, jdkType);
        } else {
            this.init(jdkByName, null, null);
        }
    }

    @Nullable
    private static Sdk findJdk(String sdkName, String sdkType) {
        for (SdkFinder sdkFinder : (SdkFinder[])SdkFinder.EP_NAME.getExtensions()) {
            Sdk sdk = sdkFinder.findSdk(sdkName, sdkType);
            if (sdk == null) continue;
            return sdk;
        }
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        return projectJdkTable.findJdk(sdkName, sdkType);
    }

    private ModuleJdkOrderEntryImpl(@NotNull ModuleJdkOrderEntryImpl that, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "<init>"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "<init>"));
        }
        if (projectRootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootManager", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "<init>"));
        }
        super(rootModel, projectRootManager);
        this.init(that.myJdk, that.getJdkName(), that.getJdkType());
    }

    public ModuleJdkOrderEntryImpl(String jdkName, String jdkType, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "<init>"));
        }
        if (projectRootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootManager", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "<init>"));
        }
        super(rootModel, projectRootManager);
        this.init(null, jdkName, jdkType);
    }

    private void init(Sdk jdk2, String jdkName, String jdkType) {
        this.myJdk = jdk2;
        this.setJdkName(jdkName);
        this.setJdkType(jdkType);
        this.addListener();
        this.init();
    }

    private String getJdkType() {
        if (this.myJdk != null) {
            return this.myJdk.getSdkType().getName();
        }
        return this.myJdkType;
    }

    private void addListener() {
        this.myProjectRootManagerImpl.addJdkTableListener(this);
    }

    @Override
    protected RootProvider getRootProvider() {
        return this.myJdk == null ? null : this.myJdk.getRootProvider();
    }

    @Nullable
    public Sdk getJdk() {
        return this.getRootModel().getConfigurationAccessor().getSdk(this.myJdk, this.myJdkName);
    }

    @Nullable
    public String getJdkName() {
        if (this.myJdkName != null) {
            return this.myJdkName;
        }
        Sdk jdk2 = this.getJdk();
        if (jdk2 != null) {
            return jdk2.getName();
        }
        return null;
    }

    public boolean isSynthetic() {
        return true;
    }

    @NotNull
    public String getPresentableName() {
        String string = "< " + (this.myJdk == null ? this.getJdkName() : this.myJdk.getName()) + " >";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "getPresentableName"));
        }
        return string;
    }

    public boolean isValid() {
        return !this.isDisposed() && this.getJdk() != null;
    }

    public <R> R accept(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "accept"));
        }
        return (R)policy.visitModuleJdkOrderEntry((ModuleJdkOrderEntry)this, initialValue);
    }

    public void jdkAdded(@NotNull Sdk jdk2) {
        if (jdk2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ENTRY_TYPE, "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "jdkAdded"));
        }
        if (this.myJdk == null && this.getJdkName().equals(jdk2.getName())) {
            this.myJdk = jdk2;
            this.setJdkName(null);
            this.setJdkType(null);
            this.updateFromRootProviderAndSubscribe();
        }
    }

    public void jdkNameChanged(@NotNull Sdk jdk2, String previousName) {
        if (jdk2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ENTRY_TYPE, "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "jdkNameChanged"));
        }
        if (this.myJdk == null && this.getJdkName().equals(jdk2.getName())) {
            this.myJdk = jdk2;
            this.setJdkName(null);
            this.setJdkType(null);
            this.updateFromRootProviderAndSubscribe();
        }
    }

    public void jdkRemoved(Sdk jdk2) {
        if (jdk2 == this.myJdk) {
            this.setJdkName(this.myJdk.getName());
            this.setJdkType(this.myJdk.getSdkType().getName());
            this.myJdk = null;
            this.updateFromRootProviderAndSubscribe();
        }
    }

    @Override
    public void writeExternal(@NotNull Element rootElement) throws WriteExternalException {
        String jdkType;
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "writeExternal"));
        }
        Element element = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        String jdkName = this.getJdkName();
        if (jdkName != null) {
            element.setAttribute(JDK_NAME_ATTR, jdkName);
        }
        if ((jdkType = this.getJdkType()) != null) {
            element.setAttribute(JDK_TYPE_ATTR, jdkType);
        }
        rootElement.addContent(element);
    }

    @Override
    @NotNull
    public OrderEntry cloneEntry(@NotNull RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "cloneEntry"));
        }
        ModuleJdkOrderEntryImpl moduleJdkOrderEntryImpl = new ModuleJdkOrderEntryImpl(this, rootModel, ProjectRootManagerImpl.getInstanceImpl(this.getRootModel().getModule().getProject()));
        if (moduleJdkOrderEntryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleJdkOrderEntryImpl", "cloneEntry"));
        }
        return moduleJdkOrderEntryImpl;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myProjectRootManagerImpl.removeJdkTableListener(this);
    }

    private void setJdkName(String jdkName) {
        this.myJdkName = jdkName;
    }

    private void setJdkType(String jdkType) {
        this.myJdkType = jdkType;
    }
}

