/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.util.Pair;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="libraryTable", storages={@Storage(value="libraries", stateSplitter=LibraryStateSplitter.class)})
public class ProjectLibraryTable
extends LibraryTableBase {
    private static final LibraryTablePresentation PROJECT_LIBRARY_TABLE_PRESENTATION = new LibraryTablePresentation(){

        public String getDisplayName(boolean plural) {
            return ProjectBundle.message((String)"project.library.display.name", (Object[])new Object[]{plural ? 2 : 1});
        }

        public String getDescription() {
            return ProjectBundle.message((String)"libraries.node.text.project", (Object[])new Object[0]);
        }

        public String getLibraryTableEditorTitle() {
            return ProjectBundle.message((String)"library.configure.project.title", (Object[])new Object[0]);
        }
    };

    public static LibraryTable getInstance(Project project2) {
        return (LibraryTable)ServiceManager.getService((Project)project2, ProjectLibraryTable.class);
    }

    public String getTableLevel() {
        return "project";
    }

    public LibraryTablePresentation getPresentation() {
        return PROJECT_LIBRARY_TABLE_PRESENTATION;
    }

    public boolean isEditable() {
        return true;
    }

    public static final class LibraryStateSplitter
    extends StateSplitterEx {
        public List<Pair<Element, String>> splitState(@NotNull Element state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/roots/impl/libraries/ProjectLibraryTable$LibraryStateSplitter", "splitState"));
            }
            return LibraryStateSplitter.splitState((Element)state, (String)"name");
        }
    }
}

