/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.ui.configuration.JavaVfsSourceRootDetectionUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibraryJavaSourceRootDetector
extends RootDetector {
    public LibraryJavaSourceRootDetector() {
        super(OrderRootType.SOURCES, false, "sources");
    }

    @Override
    @NotNull
    public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
        if (rootCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCandidate", "com/intellij/openapi/roots/ui/configuration/LibraryJavaSourceRootDetector", "detectRoots"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/roots/ui/configuration/LibraryJavaSourceRootDetector", "detectRoots"));
        }
        List<VirtualFile> list = JavaVfsSourceRootDetectionUtil.suggestRoots(rootCandidate, progressIndicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/LibraryJavaSourceRootDetector", "detectRoots"));
        }
        return list;
    }
}

