/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ArtifactErrorPanel {
    private JPanel myMainPanel;
    private JButton myFixButton;
    private JLabel myErrorLabel;
    private List<? extends ConfigurationErrorQuickFix> myCurrentQuickFixes;
    private String myErrorText;

    public ArtifactErrorPanel(final ArtifactEditorImpl artifactEditor) {
        this.$$$setupUI$$$();
        this.myErrorLabel.setIcon(AllIcons.RunConfigurations.ConfigurationWarning);
        new UiNotifyConnector((Component)this.myMainPanel, (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                if (ArtifactErrorPanel.this.myErrorText != null) {
                    ArtifactErrorPanel.this.myErrorLabel.setText(ArtifactErrorPanel.this.myErrorText);
                    ArtifactErrorPanel.this.myErrorText = null;
                }
            }
        });
        this.myFixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ArtifactErrorPanel.this.myCurrentQuickFixes.isEmpty()) {
                    if (ArtifactErrorPanel.this.myCurrentQuickFixes.size() == 1) {
                        ArtifactErrorPanel.performFix((ConfigurationErrorQuickFix)ContainerUtil.getFirstItem((Collection)ArtifactErrorPanel.this.myCurrentQuickFixes, null), artifactEditor);
                    } else {
                        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ConfigurationErrorQuickFix>(null, ArtifactErrorPanel.this.myCurrentQuickFixes){

                            @NotNull
                            public String getTextFor(ConfigurationErrorQuickFix value) {
                                String string = value.getActionName();
                                if (string == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactErrorPanel$2$1", "getTextFor"));
                                }
                                return string;
                            }

                            public PopupStep onChosen(ConfigurationErrorQuickFix selectedValue, boolean finalChoice) {
                                ArtifactErrorPanel.performFix(selectedValue, artifactEditor);
                                return FINAL_CHOICE;
                            }
                        }).showUnderneathOf((Component)ArtifactErrorPanel.this.myFixButton);
                    }
                }
            }
        });
        this.clearError();
    }

    private static void performFix(ConfigurationErrorQuickFix quickFix, ArtifactEditorImpl artifactEditor) {
        quickFix.performFix();
        artifactEditor.queueValidation();
    }

    public void showError(@NotNull String message, @NotNull List<? extends ConfigurationErrorQuickFix> quickFixes) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactErrorPanel", "showError"));
        }
        if (quickFixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactErrorPanel", "showError"));
        }
        this.myErrorLabel.setVisible(true);
        String errorText = XmlStringUtil.wrapInHtml((CharSequence)message);
        if (this.myErrorLabel.isShowing()) {
            this.myErrorLabel.setText(errorText);
        }
        this.myErrorText = errorText;
        this.myMainPanel.setVisible(true);
        this.myCurrentQuickFixes = quickFixes;
        this.myFixButton.setVisible(!quickFixes.isEmpty());
        if (!quickFixes.isEmpty()) {
            this.myFixButton.setText(quickFixes.size() == 1 ? ((ConfigurationErrorQuickFix)ContainerUtil.getFirstItem(quickFixes, null)).getActionName() : IdeBundle.message((String)"button.fix", (Object[])new Object[0]));
        }
    }

    public void clearError() {
        this.myErrorText = null;
        this.myMainPanel.setVisible(false);
        this.myErrorLabel.setVisible(false);
        this.myFixButton.setVisible(false);
    }

    public JComponent getMainPanel() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JLabel jLabel;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myFixButton = jButton = new JButton();
        jButton.setText("Button");
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

