/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ArtifactSourceItem;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsSourceItemsProvider
extends PackagingSourceItemsProvider {
    @NotNull
    public Collection<? extends PackagingSourceItem> getSourceItems(@NotNull ArtifactEditorContext editorContext, @NotNull Artifact artifact, @Nullable PackagingSourceItem parent) {
        if (editorContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorContext", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider", "getSourceItems"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider", "getSourceItems"));
        }
        if (parent == null) {
            if (!ArtifactElementType.getAvailableArtifacts(editorContext, artifact, true).isEmpty()) {
                List<ArtifactsGroupSourceItem> list = Collections.singletonList(new ArtifactsGroupSourceItem());
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider", "getSourceItems"));
                }
                return list;
            }
        } else if (parent instanceof ArtifactsGroupSourceItem) {
            ArrayList<ArtifactSourceItem> items = new ArrayList<ArtifactSourceItem>();
            for (Artifact artifact2 : ArtifactElementType.getAvailableArtifacts(editorContext, artifact, true)) {
                items.add(new ArtifactSourceItem(artifact2));
            }
            ArrayList<ArtifactSourceItem> arrayList = items;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider", "getSourceItems"));
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider", "getSourceItems"));
        }
        return list;
    }

    private static class ArtifactsGroupSourceItem
    extends PackagingSourceItem {
        private ArtifactsGroupSourceItem() {
            super(false);
        }

        public boolean equals(Object obj) {
            return obj instanceof ArtifactsGroupSourceItem;
        }

        public int hashCode() {
            return 0;
        }

        public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider$ArtifactsGroupSourceItem", "createPresentation"));
            }
            return new ArtifactsGroupPresentation();
        }

        @NotNull
        public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider$ArtifactsGroupSourceItem", "createElements"));
            }
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider$ArtifactsGroupSourceItem", "createElements"));
            }
            return list;
        }

        private static class ArtifactsGroupPresentation
        extends SourceItemPresentation {
            private ArtifactsGroupPresentation() {
            }

            public String getPresentableName() {
                return "Artifacts";
            }

            public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
                if (presentationData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationData", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ArtifactsSourceItemsProvider$ArtifactsGroupSourceItem$ArtifactsGroupPresentation", "render"));
                }
                presentationData.setIcon(AllIcons.Nodes.Artifact);
                presentationData.addText("Artifacts", mainAttributes);
            }

            public int getWeight() {
                return 200;
            }
        }
    }
}

