/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.LibraryDependencyScopeSuggester;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.ui.configuration.classpath.AddItemPopupAction;
import com.intellij.openapi.roots.ui.configuration.classpath.AddNewLibraryDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathElementChooser;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.classpath.ProjectStructureChooseLibrariesDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.classpath.ChooseLibrariesFromTablesDialog;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddLibraryDependencyAction
extends AddItemPopupAction<Library> {
    private final StructureConfigurableContext myContext;

    public AddLibraryDependencyAction(ClasspathPanel classpathPanel, int index, String title, StructureConfigurableContext context) {
        super(classpathPanel, index, title, PlatformIcons.LIBRARY_ICON);
        this.myContext = context;
    }

    @Override
    public boolean hasSubStep() {
        return !this.hasLibraries() && LibraryEditingUtil.hasSuitableTypes(this.myClasspathPanel);
    }

    @Override
    public PopupStep createSubStep() {
        return LibraryEditingUtil.createChooseTypeStep(this.myClasspathPanel, (ParameterizedRunnable<LibraryType>)((ParameterizedRunnable)libraryType -> new AddNewLibraryDependencyAction(this.myClasspathPanel, this.myContext, (LibraryType)libraryType).execute()));
    }

    @Override
    public void run() {
        if (this.hasLibraries()) {
            super.run();
        } else {
            new AddNewLibraryDependencyAction(this.myClasspathPanel, this.myContext, null).run();
        }
    }

    private boolean hasLibraries() {
        Predicate<Library> condition = this.getNotAddedSuitableLibrariesCondition();
        for (LibraryTable table : ChooseLibrariesFromTablesDialog.getLibraryTables(this.myClasspathPanel.getProject(), true)) {
            LibrariesModifiableModel model = this.myContext.myLevel2Providers.get(table.getTableLevel());
            if (model == null) continue;
            for (Library library : model.getLibraries()) {
                if (!condition.apply((Object)library)) continue;
                return true;
            }
        }
        return false;
    }

    private Predicate<Library> getNotAddedSuitableLibrariesCondition() {
        ProjectFacetsConfigurator facetsConfigurator = this.myContext.getModulesConfigurator().getFacetsConfigurator();
        return LibraryEditingUtil.getNotAddedSuitableLibrariesCondition((ModuleRootModel)this.myClasspathPanel.getRootModel(), facetsConfigurator);
    }

    @Override
    @Nullable
    protected ClasspathTableItem<?> createTableItem(Library item) {
        OrderEntry[] orderEntries;
        ModifiableRootModel rootModel = this.myClasspathPanel.getRootModel();
        for (OrderEntry orderEntry : orderEntries = rootModel.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
            if (item.equals(libraryOrderEntry.getLibrary())) {
                return ClasspathTableItem.createLibItem(libraryOrderEntry, this.myContext);
            }
            String name = item.getName();
            if (name == null || !name.equals(libraryOrderEntry.getLibraryName())) continue;
            if (orderEntry.isValid()) {
                Messages.showErrorDialog((String)ProjectBundle.message((String)"classpath.message.library.already.added", (Object[])new Object[]{item.getName()}), (String)ProjectBundle.message((String)"classpath.title.adding.dependency", (Object[])new Object[0]));
                return null;
            }
            rootModel.removeOrderEntry(orderEntry);
        }
        LibraryOrderEntry orderEntry = rootModel.addLibraryEntry(item);
        orderEntry.setScope(LibraryDependencyScopeSuggester.getDefaultScope(item));
        return ClasspathTableItem.createLibItem(orderEntry, this.myContext);
    }

    @Override
    protected ClasspathElementChooser<Library> createChooser() {
        return new ExistingLibraryChooser();
    }

    class ExistingLibraryChooser
    implements ClasspathElementChooser<Library> {
        ExistingLibraryChooser() {
        }

        @Override
        @NotNull
        public List<Library> chooseElements() {
            ProjectStructureChooseLibrariesDialog dialog = new ProjectStructureChooseLibrariesDialog(AddLibraryDependencyAction.this.myClasspathPanel, AddLibraryDependencyAction.this.myContext, (Predicate<Library>)AddLibraryDependencyAction.this.getNotAddedSuitableLibrariesCondition());
            dialog.show();
            List<Library> list = dialog.getSelectedLibraries();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/AddLibraryDependencyAction$ExistingLibraryChooser", "chooseElements"));
            }
            return list;
        }
    }
}

