/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.FrameState;
import com.intellij.ui.ScreenUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

abstract class WindowStateServiceImpl
extends WindowStateService
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String STATE = "state";
    @NonNls
    private static final String X = "x";
    @NonNls
    private static final String Y = "y";
    @NonNls
    private static final String WIDTH = "width";
    @NonNls
    private static final String HEIGHT = "height";
    @NonNls
    private static final String MAXIMIZED = "maximized";
    @NonNls
    private static final String FULL_SCREEN = "full-screen";
    private static final Logger LOG = Logger.getInstance(WindowStateService.class);
    private final Map<String, WindowState> myStateMap = new TreeMap<String, WindowState>();

    WindowStateServiceImpl() {
    }

    abstract Point getDefaultLocationFor(Object var1, @NotNull String var2);

    abstract Dimension getDefaultSizeFor(Object var1, @NotNull String var2);

    abstract Rectangle getDefaultBoundsFor(Object var1, @NotNull String var2);

    abstract boolean getDefaultMaximizedFor(Object var1, @NotNull String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Element getState() {
        Element element = new Element(STATE);
        Map<String, WindowState> map = this.myStateMap;
        synchronized (map) {
            for (Map.Entry<String, WindowState> entry : this.myStateMap.entrySet()) {
                String key2 = entry.getKey();
                if (key2 == null) continue;
                WindowState state = entry.getValue();
                Element child = new Element(STATE);
                if (state.myLocation != null) {
                    child.setAttribute(X, Integer.toString(((WindowState)state).myLocation.x));
                    child.setAttribute(Y, Integer.toString(((WindowState)state).myLocation.y));
                }
                if (state.mySize != null) {
                    child.setAttribute(WIDTH, Integer.toString(((WindowState)state).mySize.width));
                    child.setAttribute(HEIGHT, Integer.toString(((WindowState)state).mySize.height));
                }
                if (state.myMaximized) {
                    child.setAttribute(MAXIMIZED, Boolean.toString(true));
                }
                if (state.myFullScreen) {
                    child.setAttribute(FULL_SCREEN, Boolean.toString(true));
                }
                child.setAttribute(KEY, key2);
                element.addContent(child);
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadState(Element element) {
        Map<String, WindowState> map = this.myStateMap;
        synchronized (map) {
            this.myStateMap.clear();
            for (Element child : element.getChildren()) {
                String key2;
                if (!STATE.equals(child.getName()) || (key2 = child.getAttributeValue(KEY)) == null) continue;
                Point location = null;
                try {
                    location = new Point(Integer.parseInt(child.getAttributeValue(X)), Integer.parseInt(child.getAttributeValue(Y)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Dimension size = null;
                try {
                    size = new Dimension(Integer.parseInt(child.getAttributeValue(WIDTH)), Integer.parseInt(child.getAttributeValue(HEIGHT)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (location == null && size == null) continue;
                WindowState state = new WindowState();
                state.myLocation = location;
                state.mySize = size;
                state.myMaximized = Boolean.parseBoolean(child.getAttributeValue(MAXIMIZED));
                state.myFullScreen = Boolean.parseBoolean(child.getAttributeValue(FULL_SCREEN));
                this.myStateMap.put(key2, state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadStateFor(Object object, @NotNull String key2, @NotNull Component component) {
        Frame frame;
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "loadStateFor"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/util/WindowStateServiceImpl", "loadStateFor"));
        }
        Point location = null;
        Dimension size = null;
        boolean maximized = false;
        Map<String, WindowState> map = this.myStateMap;
        synchronized (map) {
            WindowState state = this.getFor(object, key2, WindowState.class);
            if (state != null) {
                location = state.myLocation;
                size = state.mySize;
                maximized = state.myMaximized;
            }
        }
        if (location == null && size == null) {
            location = this.getDefaultLocationFor(object, key2);
            if (!WindowStateServiceImpl.isVisible(location, size = this.getDefaultSizeFor(object, key2))) {
                return false;
            }
            maximized = this.getDefaultMaximizedFor(object, key2);
        }
        Frame frame2 = frame = component instanceof Frame ? (Frame)component : null;
        if (frame != null && 0 != frame.getExtendedState()) {
            frame.setExtendedState(0);
        }
        Rectangle bounds = component.getBounds();
        if (location != null) {
            bounds.setLocation(location);
        }
        if (size != null) {
            bounds.setSize(size);
        }
        component.setBounds(bounds);
        if (maximized && frame != null) {
            frame.setExtendedState(6);
        }
        return true;
    }

    public void saveStateFor(Object object, @NotNull String key2, @NotNull Component component) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "saveStateFor"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/util/WindowStateServiceImpl", "saveStateFor"));
        }
        FrameState state = FrameState.getFrameState(component);
        this.putFor(object, key2, state.getLocation(), true, state.getSize(), true, state.isMaximized(), true, state.isFullScreen(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocationFor(Object object, @NotNull String key2) {
        Point location;
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "getLocationFor"));
        }
        Map<String, WindowState> map = this.myStateMap;
        synchronized (map) {
            location = this.getFor(object, key2, Point.class);
        }
        return location != null ? location : this.getDefaultLocationFor(object, key2);
    }

    public void putLocationFor(Object object, @NotNull String key2, Point location) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "putLocationFor"));
        }
        this.putFor(object, key2, location, true, null, false, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getSizeFor(Object object, @NotNull String key2) {
        Dimension size;
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "getSizeFor"));
        }
        Map<String, WindowState> map = this.myStateMap;
        synchronized (map) {
            size = this.getFor(object, key2, Dimension.class);
        }
        return size != null ? size : this.getDefaultSizeFor(object, key2);
    }

    public void putSizeFor(Object object, @NotNull String key2, Dimension size) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "putSizeFor"));
        }
        this.putFor(object, key2, null, false, size, true, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBoundsFor(Object object, @NotNull String key2) {
        Rectangle bounds;
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "getBoundsFor"));
        }
        Map<String, WindowState> map = this.myStateMap;
        synchronized (map) {
            bounds = this.getFor(object, key2, Rectangle.class);
        }
        return bounds != null ? bounds : this.getDefaultBoundsFor(object, key2);
    }

    public void putBoundsFor(Object object, @NotNull String key2, Rectangle bounds) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "putBoundsFor"));
        }
        Point location = bounds == null ? null : bounds.getLocation();
        Dimension size = bounds == null ? null : bounds.getSize();
        this.putFor(object, key2, location, true, size, true, false, false, false, false);
    }

    private <T> T getFor(Object object, @NotNull String key2, @NotNull Class<T> type) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "getFor"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/util/WindowStateServiceImpl", "getFor"));
        }
        GraphicsDevice screen = WindowStateServiceImpl.getScreen(object);
        T state = this.get(WindowStateServiceImpl.getKey(screen, key2), type);
        if (state != null) {
            return state;
        }
        if (object != null && (state = this.get(WindowStateServiceImpl.getKey(null, key2), type)) != null) {
            return state;
        }
        return this.get(key2, type);
    }

    private <T> T get(@NotNull String key2, @NotNull Class<T> type) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "get"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/util/WindowStateServiceImpl", "get"));
        }
        WindowState state = this.myStateMap.get(key2);
        if (WindowStateServiceImpl.isVisible(state)) {
            if (type == WindowState.class) {
                return (T)state;
            }
            if (type == Point.class) {
                return (T)state.getLocation();
            }
            if (type == Dimension.class) {
                return (T)state.getSize();
            }
            if (type == Rectangle.class) {
                return (T)state.getBounds();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFor(Object object, @NotNull String key2, Point location, boolean locationSet, Dimension size, boolean sizeSet, boolean maximized, boolean maximizedSet, boolean fullScreen, boolean fullScreenSet) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "putFor"));
        }
        Map<String, WindowState> map = this.myStateMap;
        synchronized (map) {
            GraphicsDevice screen = WindowStateServiceImpl.getScreen(object);
            this.putImpl(WindowStateServiceImpl.getKey(screen, key2), location, locationSet, size, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet);
            if (screen != null) {
                this.putImpl(WindowStateServiceImpl.getKey(null, key2), location, locationSet, size, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet);
            }
            this.putImpl(key2, location, locationSet, size, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet);
        }
    }

    private void putImpl(@NotNull String key2, Point location, boolean locationSet, Dimension size, boolean sizeSet, boolean maximized, boolean maximizedSet, boolean fullScreen, boolean fullScreenSet) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "putImpl"));
        }
        WindowState state = this.myStateMap.get(key2);
        if (state != null) {
            if (!state.set(location, locationSet, size, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet)) {
                this.myStateMap.remove(key2);
            }
        } else {
            state = new WindowState();
            if (state.set(location, locationSet, size, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet)) {
                this.myStateMap.put(key2, state);
            }
        }
    }

    @NotNull
    private static String getKey(GraphicsDevice screen, String key2) {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (environment.isHeadlessInstance()) {
            String string = key2 + ".headless";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/WindowStateServiceImpl", "getKey"));
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(key2);
        for (GraphicsDevice device : environment.getScreenDevices()) {
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            sb.append('/').append(bounds.x);
            sb.append('.').append(bounds.y);
            sb.append('.').append(bounds.width);
            sb.append('.').append(bounds.height);
        }
        if (screen != null) {
            Rectangle bounds = screen.getDefaultConfiguration().getBounds();
            sb.append('@').append(bounds.x);
            sb.append('.').append(bounds.y);
            sb.append('.').append(bounds.width);
            sb.append('.').append(bounds.height);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/WindowStateServiceImpl", "getKey"));
        }
        return string;
    }

    private static GraphicsDevice getScreen(Object object) {
        Window window;
        if (object == null) {
            return null;
        }
        if (object instanceof Project) {
            Project project2 = (Project)object;
            object = WindowManager.getInstance().getFrame(project2);
            if (object == null) {
                LOG.warn("cannot find a project frame for " + project2);
                return null;
            }
        }
        if (object instanceof Window && (object = ScreenUtil.getScreenDevice((Rectangle)(window = (Window)object).getBounds())) == null) {
            LOG.warn("cannot find a screen for " + window);
            return null;
        }
        if (object instanceof GraphicsDevice) {
            return (GraphicsDevice)object;
        }
        LOG.warn("cannot find a screen for " + object);
        return null;
    }

    private static boolean isVisible(WindowState state) {
        return state != null && WindowStateServiceImpl.isVisible(state.myLocation, state.mySize);
    }

    private static boolean isVisible(Point location, Dimension size) {
        if (location == null) {
            return size != null;
        }
        if (ScreenUtil.isVisible((Point)location)) {
            return true;
        }
        if (size == null) {
            return false;
        }
        return ScreenUtil.isVisible((Rectangle)new Rectangle(location, size));
    }

    private static final class WindowState {
        private Point myLocation;
        private Dimension mySize;
        private boolean myMaximized;
        private boolean myFullScreen;

        private WindowState() {
        }

        private Point getLocation() {
            return this.myLocation == null ? null : new Point(this.myLocation);
        }

        private Dimension getSize() {
            return this.mySize == null ? null : new Dimension(this.mySize);
        }

        private Rectangle getBounds() {
            return this.myLocation == null || this.mySize == null ? null : new Rectangle(this.myLocation, this.mySize);
        }

        private boolean set(Point location, boolean locationSet, Dimension size, boolean sizeSet, boolean maximized, boolean maximizedSet, boolean fullScreen, boolean fullScreenSet) {
            if (locationSet) {
                Point point = this.myLocation = location == null ? null : new Point(location);
            }
            if (sizeSet) {
                Dimension dimension = this.mySize = size == null ? null : new Dimension(size);
            }
            if (maximizedSet) {
                this.myMaximized = maximized;
            }
            if (fullScreenSet) {
                this.myFullScreen = fullScreen;
            }
            return this.myLocation != null || this.mySize != null;
        }
    }
}

