/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.vcs.actions.AnnotationsSettings;
import com.intellij.openapi.vcs.actions.VcsPreviewPanel;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsColorsPageFactory
implements ColorAndFontPanelFactory,
ColorAndFontDescriptorsProvider,
DisplayPrioritySortable {
    public static final String VCS_GROUP = ApplicationBundle.message((String)"title.vcs", (Object[])new Object[0]);

    @Override
    @NotNull
    public NewColorAndFontPanel createPanel(final @NotNull ColorAndFontOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/vcs/actions/VcsColorsPageFactory", "createPanel"));
        }
        SchemesPanel schemesPanel = new SchemesPanel(options);
        final OptionsPanelImpl optionsPanel = new OptionsPanelImpl(options, schemesPanel, VCS_GROUP);
        final VcsPreviewPanel previewPanel = new VcsPreviewPanel();
        schemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void schemeChanged(Object source) {
                previewPanel.setColorScheme(options.getSelectedScheme());
                optionsPanel.updateOptionsList();
            }
        });
        NewColorAndFontPanel newColorAndFontPanel = new NewColorAndFontPanel(schemesPanel, optionsPanel, previewPanel, VCS_GROUP, null, null);
        if (newColorAndFontPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsColorsPageFactory", "createPanel"));
        }
        return newColorAndFontPanel;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        AttributesDescriptor[] attributesDescriptorArray = new AttributesDescriptor[]{};
        if (attributesDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsColorsPageFactory", "getAttributeDescriptors"));
        }
        return attributesDescriptorArray;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        ArrayList<ColorDescriptor> descriptors = new ArrayList<ColorDescriptor>();
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.added.lines", (Object[])new Object[0]), EditorColors.ADDED_LINES_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.modified.lines", (Object[])new Object[0]), EditorColors.MODIFIED_LINES_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.deleted.lines", (Object[])new Object[0]), EditorColors.DELETED_LINES_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.whitespaces.modified.lines", (Object[])new Object[0]), EditorColors.WHITESPACES_MODIFIED_LINES_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.border.lines", (Object[])new Object[0]), EditorColors.BORDER_LINES_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.vcs.annotations", (Object[])new Object[0]), EditorColors.ANNOTATIONS_COLOR, ColorDescriptor.Kind.FOREGROUND));
        List<ColorKey> colorKeys = AnnotationsSettings.ANCHOR_COLOR_KEYS;
        for (int i = 0; i < colorKeys.size(); ++i) {
            descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.vcs.annotations.color.n", (Object[])new Object[]{i + 1}), colorKeys.get(i), ColorDescriptor.Kind.BACKGROUND));
        }
        ColorDescriptor[] colorDescriptorArray = (ColorDescriptor[])ArrayUtil.toObjectArray(descriptors, ColorDescriptor.class);
        if (colorDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsColorsPageFactory", "getColorDescriptors"));
        }
        return colorDescriptorArray;
    }

    @Override
    @NotNull
    public String getPanelDisplayName() {
        String string = VCS_GROUP;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsColorsPageFactory", "getPanelDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = VCS_GROUP;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsColorsPageFactory", "getDisplayName"));
        }
        return string;
    }

    public DisplayPriority getPriority() {
        return DisplayPriority.COMMON_SETTINGS;
    }
}

