/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.ChangeForDiffConvertor;
import com.intellij.openapi.vcs.changes.actions.DiffChainContext;
import com.intellij.openapi.vcs.changes.actions.DiffExtendUIFactory;
import com.intellij.openapi.vcs.changes.actions.DiffPresentationReturnValue;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MultipleDiffRequestPresentable
implements DiffRequestPresentable {
    private final Project myProject;
    private final Change myChange;

    public MultipleDiffRequestPresentable(Project project2, Change change) {
        this.myProject = project2;
        this.myChange = change;
    }

    public DiffRequestPresentable.MyResult step(DiffChainContext context) {
        ChangeForDiffConvertor convertor = new ChangeForDiffConvertor(this.myProject, false);
        ArrayList<Pair> list = new ArrayList<Pair>();
        DiffRequestPresentable requestPresentable = convertor.convert(this.myChange, false);
        if (requestPresentable != null) {
            list.add(Pair.create((Object)"", (Object)requestPresentable));
        }
        Map layers = this.myChange.getOtherLayers();
        for (Map.Entry entry : layers.entrySet()) {
            String key2 = (String)entry.getKey();
            Change value = (Change)entry.getValue();
            DiffRequestPresentable additional = convertor.convert(value, true);
            if (additional == null) continue;
            list.add(Pair.create((Object)key2, (Object)additional));
        }
        if (list.isEmpty()) {
            return new DiffRequestPresentable.MyResult((DiffRequest)new SimpleDiffRequest(this.myProject, ""), DiffPresentationReturnValue.removeFromList);
        }
        DiffRequest request = null;
        StringBuilder err = new StringBuilder();
        for (Pair pair : list) {
            String error;
            DiffRequestPresentable.MyResult step = ((DiffRequestPresentable)pair.getSecond()).step(context);
            if (step == null) continue;
            DiffPresentationReturnValue returnValue = step.getReturnValue();
            if (DiffPresentationReturnValue.quit.equals((Object)returnValue)) {
                error = step.getAsOneError();
                if (StringUtil.isEmptyOrSpaces((String)error)) {
                    return new DiffRequestPresentable.MyResult((DiffRequest)new SimpleDiffRequest(this.myProject, ""), DiffPresentationReturnValue.quit);
                }
                return new DiffRequestPresentable.MyResult((DiffRequest)new SimpleDiffRequest(this.myProject, ""), DiffPresentationReturnValue.quit, error);
            }
            if (!DiffPresentationReturnValue.removeFromList.equals((Object)returnValue) && !step.hasErrors()) {
                if (request == null) {
                    request = step.getRequest();
                    if (StringUtil.isEmptyOrSpaces((String)((String)pair.getFirst()))) continue;
                    request.setWindowTitle((String)pair.getFirst() + " " + request.getWindowTitle());
                    continue;
                }
                request.addOtherLayer((String)pair.getFirst(), step.getRequest());
                continue;
            }
            error = step.getAsOneError();
            if (StringUtil.isEmptyOrSpaces((String)error)) continue;
            err.append(error);
        }
        if (request == null || err.length() > 0) {
            return new DiffRequestPresentable.MyResult((DiffRequest)new SimpleDiffRequest(this.myProject, ""), DiffPresentationReturnValue.removeFromList, err.toString());
        }
        return new DiffRequestPresentable.MyResult(request, DiffPresentationReturnValue.useRequest, err.toString());
    }

    public void haveStuff() throws VcsException {
    }

    public List<? extends AnAction> createActions(DiffExtendUIFactory uiFactory) {
        return Collections.emptyList();
    }

    public String getPathPresentation() {
        return ChangesUtil.getFilePath((Change)this.myChange).getPath();
    }
}

