/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScheduleForAdditionAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "update"));
        }
        boolean enabled = this.thereAreUnversionedFiles(e);
        e.getPresentation().setEnabled(enabled);
        String place = e.getPlace();
        if ("ActionPlace.VcsQuickListPopupAction".equals(place) || "ChangesViewPopup".equals(place)) {
            e.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "actionPerformed"));
        }
        ScheduleForAdditionAction.addUnversioned((Project)e.getRequiredData(CommonDataKeys.PROJECT), this.getUnversionedFiles(e), (Condition<FileStatus>)((Condition)this::isStatusForAddition), (ChangesBrowserBase)e.getData(ChangesBrowserBase.DATA_KEY));
    }

    public static boolean addUnversioned(@NotNull Project project2, @NotNull List<VirtualFile> files, @NotNull Condition<FileStatus> unversionedFileCondition, @Nullable ChangesBrowserBase browser) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "addUnversioned"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "addUnversioned"));
        }
        if (unversionedFileCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unversionedFileCondition", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "addUnversioned"));
        }
        boolean result2 = true;
        if (!files.isEmpty()) {
            FileDocumentManager.getInstance().saveAllDocuments();
            Consumer consumer = browser == null ? null : changes -> {
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "lambda$addUnversioned$0"));
                }
                browser.rebuildList();
                browser.getViewer().excludeChanges(files);
                browser.getViewer().includeChanges(changes);
            };
            ChangeListManagerImpl manager = ChangeListManagerImpl.getInstanceImpl(project2);
            LocalChangeList targetChangeList = browser == null ? manager.getDefaultChangeList() : (LocalChangeList)browser.getSelectedChangeList();
            List<VcsException> exceptions = manager.addUnversionedFiles(targetChangeList, files, unversionedFileCondition, (Consumer<List<Change>>)consumer);
            result2 = exceptions.isEmpty();
        }
        return result2;
    }

    private boolean thereAreUnversionedFiles(AnActionEvent e) {
        List<VirtualFile> unversionedFiles = ScheduleForAdditionAction.getFromChangesView(e);
        if (unversionedFiles != null && !unversionedFiles.isEmpty()) {
            return true;
        }
        VirtualFile[] files = ScheduleForAdditionAction.getFromSelection(e);
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (files == null || project2 == null) {
            return false;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project2);
        for (VirtualFile file2 : files) {
            if (!this.isFileUnversioned(file2, vcsManager, fileStatusManager)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private List<VirtualFile> getUnversionedFiles(AnActionEvent e) {
        List<VirtualFile> unversionedFiles = ScheduleForAdditionAction.getFromChangesView(e);
        if (unversionedFiles != null && !unversionedFiles.isEmpty()) {
            List<VirtualFile> list = unversionedFiles;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "getUnversionedFiles"));
            }
            return list;
        }
        VirtualFile[] files = ScheduleForAdditionAction.getFromSelection(e);
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (files == null || project2 == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "getUnversionedFiles"));
            }
            return list;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project2);
        unversionedFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files) {
            if (!this.isFileUnversioned(file2, vcsManager, fileStatusManager)) continue;
            unversionedFiles.add(file2);
        }
        List<VirtualFile> list = unversionedFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "getUnversionedFiles"));
        }
        return list;
    }

    private boolean isFileUnversioned(@NotNull VirtualFile file2, @NotNull ProjectLevelVcsManager vcsManager, @NotNull FileStatusManager fileStatusManager) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "isFileUnversioned"));
        }
        if (vcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsManager", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "isFileUnversioned"));
        }
        if (fileStatusManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStatusManager", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "isFileUnversioned"));
        }
        AbstractVcs vcs = vcsManager.getVcsFor(file2);
        return vcs != null && !vcs.areDirectoriesVersionedItems() && file2.isDirectory() || this.isStatusForAddition(fileStatusManager.getStatus(file2));
    }

    protected boolean isStatusForAddition(FileStatus status2) {
        return status2 == FileStatus.UNKNOWN;
    }

    @Nullable
    private static List<VirtualFile> getFromChangesView(AnActionEvent e) {
        return (List)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY);
    }

    @Nullable
    private static VirtualFile[] getFromSelection(AnActionEvent e) {
        return (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
    }
}

