/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.changes.committed.IntoSelfVirtualFileConvertor;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCache;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RootsCalculator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.committed.RootsCalculator");
    private final Project myProject;
    private final AbstractVcs myVcs;
    private final ProjectLevelVcsManager myPlManager;
    private VirtualFile[] myContentRoots;
    private final RepositoryLocationCache myLocationCache;

    public RootsCalculator(Project project2, AbstractVcs vcs, RepositoryLocationCache locationCache) {
        this.myProject = project2;
        this.myLocationCache = locationCache;
        this.myPlManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myVcs = vcs;
    }

    public Map<VirtualFile, RepositoryLocation> getRoots() {
        this.myContentRoots = this.myPlManager.getRootsUnderVcs(this.myVcs);
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        List mappings = this.myPlManager.getDirectoryMappings(this.myVcs);
        for (VcsDirectoryMapping mapping : mappings) {
            if (mapping.isDefaultMapping()) {
                if (!this.myVcs.equals((Object)this.myPlManager.getVcsFor(this.myProject.getBaseDir()))) continue;
                roots.add(this.myProject.getBaseDir());
                continue;
            }
            VirtualFile newFile = LocalFileSystem.getInstance().findFileByPath(mapping.getDirectory());
            if (newFile == null) {
                newFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(mapping.getDirectory());
            }
            if (newFile != null) {
                roots.add(newFile);
                continue;
            }
            LOG.info("Can not file virtual file for root: " + mapping.getDirectory());
        }
        ContainerUtil.addAll(roots, (Object[])this.myContentRoots);
        HashMap<VirtualFile, RepositoryLocation> result2 = new HashMap<VirtualFile, RepositoryLocation>();
        Iterator iterator = roots.iterator();
        while (iterator.hasNext()) {
            VirtualFile vf = (VirtualFile)iterator.next();
            RepositoryLocation location = this.myLocationCache.getLocation(this.myVcs, VcsUtil.getFilePath((VirtualFile)vf), false);
            if (location != null) {
                result2.put(vf, location);
                continue;
            }
            iterator.remove();
        }
        roots = this.myVcs.filterUniqueRoots(roots, (Convertor)IntoSelfVirtualFileConvertor.getInstance());
        result2.keySet().retainAll(roots);
        this.logRoots(roots);
        return result2;
    }

    private void logRoots(List<VirtualFile> roots) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Roots for committed changes load:\n");
            for (VirtualFile root : roots) {
                LOG.debug(root.getPath() + ", ");
            }
        }
    }

    public VirtualFile[] getContentRoots() {
        return this.myContentRoots;
    }
}

