/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ClipboardAnalyzeListener;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchFromClipboardAction;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public class PatchClipboardTracker
extends ApplicationComponent.Adapter {
    private static final PatchClipboardListener LISTENER = new PatchClipboardListener();
    private MessageBusConnection myConnection;

    public void initComponent() {
        this.myConnection = ApplicationManagerEx.getApplicationEx().getMessageBus().connect();
        this.myConnection.subscribe(ApplicationActivationListener.TOPIC, (Object)LISTENER);
    }

    public void disposeComponent() {
        this.myConnection.disconnect();
        this.myConnection = null;
    }

    private static class PatchClipboardListener
    extends ClipboardAnalyzeListener {
        private PatchClipboardListener() {
        }

        @Override
        protected void handle(@NotNull Project project2, @NotNull String value) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/PatchClipboardTracker$PatchClipboardListener", "handle"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/changes/patch/PatchClipboardTracker$PatchClipboardListener", "handle"));
            }
            new ApplyPatchFromClipboardAction.MyApplyPatchFromClipboardDialog(project2, value).show();
        }

        @Override
        public boolean canHandle(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/changes/patch/PatchClipboardTracker$PatchClipboardListener", "canHandle"));
            }
            if (!VcsApplicationSettings.getInstance().DETECT_PATCH_ON_THE_FLY) {
                return false;
            }
            return PatchReader.isPatchContent((String)value);
        }
    }
}

