/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserLocallyDeletedNode
extends ChangesBrowserNode<LocallyDeletedChange>
implements TreeLinkMouseListener.HaveTooltip {
    public ChangesBrowserLocallyDeletedNode(@NotNull LocallyDeletedChange userObject) {
        if (userObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userObject", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserLocallyDeletedNode", "<init>"));
        }
        super(userObject);
        if (!this.isDirectory()) {
            this.myCount = 1;
        }
    }

    @Override
    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        return false;
    }

    @Override
    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
    }

    @Override
    protected boolean isDirectory() {
        return ((LocallyDeletedChange)this.getUserObject()).getPath().isDirectory();
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserLocallyDeletedNode", "render"));
        }
        FilePath filePath = ((LocallyDeletedChange)this.getUserObject()).getPath();
        renderer.appendFileName(filePath.getVirtualFile(), filePath.getName(), FileStatus.NOT_CHANGED.getColor());
        if (renderer.isShowFlatten()) {
            FilePath parentPath = filePath.getParentPath();
            if (parentPath != null) {
                renderer.append(FontUtil.spaceAndThinSpace() + parentPath.getPresentableUrl(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else if (this.getCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendCount(renderer);
        }
        renderer.setIcon(this.getIcon());
    }

    @Override
    @Nullable
    public String getTooltip() {
        return ((LocallyDeletedChange)this.getUserObject()).getDescription();
    }

    @Nullable
    private Icon getIcon() {
        Icon result2 = ((LocallyDeletedChange)this.getUserObject()).getAddIcon();
        if (result2 == null) {
            FilePath filePath = ((LocallyDeletedChange)this.getUserObject()).getPath();
            result2 = filePath.isDirectory() || !this.isLeaf() ? PlatformIcons.DIRECTORY_CLOSED_ICON : filePath.getFileType().getIcon();
        }
        return result2;
    }
}

