/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.configurable.VcsCheckBoxWithSpinnerConfigurable;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotationSettings;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.Nls;

public class VcsContentAnnotationConfigurable
extends VcsCheckBoxWithSpinnerConfigurable {
    public VcsContentAnnotationConfigurable(Project project2) {
        super(project2, "Show changed in last", "days");
    }

    @Override
    protected SpinnerNumberModel createSpinnerModel() {
        return new SpinnerNumberModel(1, 1, 31, 1);
    }

    @Nls
    public String getDisplayName() {
        return "Show recently changed";
    }

    public boolean isModified() {
        VcsContentAnnotationSettings settings = VcsContentAnnotationSettings.getInstance((Project)this.myProject);
        if (this.myHighlightRecentlyChanged.isSelected() != settings.isShow()) {
            return true;
        }
        return !Comparing.equal((Object)this.myHighlightInterval.getValue(), (Object)settings.getLimitDays());
    }

    public void apply() throws ConfigurationException {
        VcsContentAnnotationSettings settings = VcsContentAnnotationSettings.getInstance((Project)this.myProject);
        settings.setShow(this.myHighlightRecentlyChanged.isSelected());
        settings.setLimit(((Number)this.myHighlightInterval.getValue()).intValue());
    }

    public void reset() {
        VcsContentAnnotationSettings settings = VcsContentAnnotationSettings.getInstance((Project)this.myProject);
        this.myHighlightRecentlyChanged.setSelected(settings.isShow());
        this.myHighlightInterval.setValue(settings.getLimitDays());
        this.myHighlightInterval.setEnabled(this.myHighlightRecentlyChanged.isSelected());
    }
}

