/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileStatusManagerImpl
extends FileStatusManager
implements ProjectComponent {
    private final Map<VirtualFile, FileStatus> myCachedStatuses = Collections.synchronizedMap(new HashMap());
    private final Map<VirtualFile, Boolean> myWhetherExactlyParentToChanged = Collections.synchronizedMap(new HashMap());
    private final Project myProject;
    private final List<FileStatusListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private FileStatusProvider myFileStatusProvider;
    private final NotNullLazyValue<FileStatusProvider[]> myExtensions = new NotNullLazyValue<FileStatusProvider[]>(){

        @NotNull
        protected FileStatusProvider[] compute() {
            FileStatusProvider[] fileStatusProviderArray = (FileStatusProvider[])Extensions.getExtensions(FileStatusProvider.EP_NAME, (AreaInstance)FileStatusManagerImpl.this.myProject);
            if (fileStatusProviderArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl$1", "compute"));
            }
            return fileStatusProviderArray;
        }
    };

    public FileStatusManagerImpl(Project project2, StartupManager startupManager, EditorColorsManager colorsManager, DirectoryIndex makeSureIndexIsInitializedFirst) {
        this.myProject = project2;
        colorsManager.addEditorColorsListener(new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                FileStatusManagerImpl.this.fileStatusesChanged();
            }
        }, (Disposable)this.myProject);
        startupManager.registerPreStartupActivity(() -> {
            DocumentAdapter documentListener = new DocumentAdapter(){

                public void documentChanged(DocumentEvent event) {
                    if (event.getOldLength() == 0 && event.getNewLength() == 0) {
                        return;
                    }
                    VirtualFile file2 = FileDocumentManager.getInstance().getFile(event.getDocument());
                    if (file2 != null) {
                        FileStatusManagerImpl.this.refreshFileStatusFromDocument(file2, event.getDocument());
                    }
                }
            };
            EditorFactory factory = EditorFactory.getInstance();
            if (factory != null) {
                factory.getEventMulticaster().addDocumentListener((DocumentListener)documentListener, (Disposable)this.myProject);
            }
        });
        startupManager.registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                FileStatusManagerImpl.this.fileStatusesChanged();
            }
        });
    }

    public void setFileStatusProvider(FileStatusProvider fileStatusProvider) {
        this.myFileStatusProvider = fileStatusProvider;
    }

    public FileStatus calcStatus(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "calcStatus"));
        }
        for (FileStatusProvider extension : (FileStatusProvider[])this.myExtensions.getValue()) {
            FileStatus status2 = extension.getFileStatus(virtualFile);
            if (status2 == null) continue;
            return status2;
        }
        if (virtualFile.isInLocalFileSystem() && this.myFileStatusProvider != null) {
            return this.myFileStatusProvider.getFileStatus(virtualFile);
        }
        return FileStatusManagerImpl.getDefaultStatus(virtualFile);
    }

    @NotNull
    public static FileStatus getDefaultStatus(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "getDefaultStatus"));
        }
        FileStatus fileStatus = file2.isValid() && file2.is(VFileProperty.SPECIAL) ? FileStatus.IGNORED : FileStatus.NOT_CHANGED;
        if (fileStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "getDefaultStatus"));
        }
        return fileStatus;
    }

    public void projectClosed() {
    }

    public void projectOpened() {
    }

    public void disposeComponent() {
        this.myCachedStatuses.clear();
    }

    @NotNull
    public String getComponentName() {
        if ("FileStatusManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "getComponentName"));
        }
        return "FileStatusManager";
    }

    public void initComponent() {
    }

    public void addFileStatusListener(@NotNull FileStatusListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "addFileStatusListener"));
        }
        this.myListeners.add(listener2);
    }

    public void addFileStatusListener(final @NotNull FileStatusListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "addFileStatusListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "addFileStatusListener"));
        }
        this.addFileStatusListener(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                FileStatusManagerImpl.this.removeFileStatusListener(listener2);
            }
        });
    }

    public void fileStatusesChanged() {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                public void run() {
                    FileStatusManagerImpl.this.fileStatusesChanged();
                }
            }, ModalityState.NON_MODAL);
            return;
        }
        this.myCachedStatuses.clear();
        this.myWhetherExactlyParentToChanged.clear();
        for (FileStatusListener listener2 : this.myListeners) {
            listener2.fileStatusesChanged();
        }
    }

    private void cacheChangedFileStatus(VirtualFile virtualFile, FileStatus fs) {
        this.myCachedStatuses.put(virtualFile, fs);
        if (FileStatus.NOT_CHANGED.equals(fs)) {
            ThreeState parentingStatus = this.myFileStatusProvider.getNotChangedDirectoryParentingStatus(virtualFile);
            if (ThreeState.YES.equals((Object)parentingStatus)) {
                this.myWhetherExactlyParentToChanged.put(virtualFile, true);
            } else if (ThreeState.UNSURE.equals((Object)parentingStatus)) {
                this.myWhetherExactlyParentToChanged.put(virtualFile, false);
            }
        } else {
            this.myWhetherExactlyParentToChanged.remove(virtualFile);
        }
    }

    public void fileStatusChanged(final VirtualFile file2) {
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread() && !application.isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                public void run() {
                    FileStatusManagerImpl.this.fileStatusChanged(file2);
                }
            });
            return;
        }
        if (file2 == null || !file2.isValid()) {
            return;
        }
        FileStatus cachedStatus = this.getCachedStatus(file2);
        if (cachedStatus == FileStatusNull.INSTANCE) {
            return;
        }
        if (cachedStatus == null) {
            this.cacheChangedFileStatus(file2, FileStatusNull.INSTANCE);
            return;
        }
        FileStatus newStatus = this.calcStatus(file2);
        if (cachedStatus == newStatus) {
            return;
        }
        this.cacheChangedFileStatus(file2, newStatus);
        for (FileStatusListener listener2 : this.myListeners) {
            listener2.fileStatusChanged(file2);
        }
    }

    public FileStatus getStatus(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "getStatus"));
        }
        if (file2.getFileSystem() instanceof NonPhysicalFileSystem) {
            return FileStatus.SUPPRESSED;
        }
        FileStatus status2 = this.getCachedStatus(file2);
        if (status2 == null || status2 == FileStatusNull.INSTANCE) {
            status2 = this.calcStatus(file2);
            this.cacheChangedFileStatus(file2, status2);
        }
        return status2;
    }

    public FileStatus getCachedStatus(VirtualFile file2) {
        return this.myCachedStatuses.get(file2);
    }

    public void removeFileStatusListener(@NotNull FileStatusListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "removeFileStatusListener"));
        }
        this.myListeners.remove(listener2);
    }

    public Color getNotChangedDirectoryColor(@NotNull VirtualFile vf) {
        if (vf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "getNotChangedDirectoryColor"));
        }
        Color notChangedColor = FileStatus.NOT_CHANGED.getColor();
        if (!vf.isDirectory()) {
            return notChangedColor;
        }
        Boolean exactMatch = this.myWhetherExactlyParentToChanged.get(vf);
        return exactMatch == null ? notChangedColor : (exactMatch != false ? FileStatus.NOT_CHANGED_IMMEDIATE.getColor() : FileStatus.NOT_CHANGED_RECURSIVE.getColor());
    }

    public void refreshFileStatusFromDocument(VirtualFile file2, Document doc) {
        if (this.myFileStatusProvider != null) {
            this.myFileStatusProvider.refreshFileStatusFromDocument(file2, doc);
        }
    }

    private static class FileStatusNull
    implements FileStatus {
        private static final FileStatus INSTANCE = new FileStatusNull();

        private FileStatusNull() {
        }

        public String getText() {
            throw new AssertionError((Object)"Should not be called");
        }

        public Color getColor() {
            throw new AssertionError((Object)"Should not be called");
        }

        @NotNull
        public ColorKey getColorKey() {
            throw new AssertionError((Object)"Should not be called");
        }

        @NotNull
        public String getId() {
            throw new AssertionError((Object)"Should not be called");
        }
    }
}

