/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.update.FileOrDirectoryTreeNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileTreeNode
extends FileOrDirectoryTreeNode {
    private static final Collection<VirtualFile> EMPTY_VIRTUAL_FILE_ARRAY = new ArrayList<VirtualFile>();

    public FileTreeNode(@NotNull String path, @NotNull SimpleTextAttributes invalidAttributes, @NotNull Project project2, String parentPath) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/update/FileTreeNode", "<init>"));
        }
        if (invalidAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidAttributes", "com/intellij/openapi/vcs/update/FileTreeNode", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/update/FileTreeNode", "<init>"));
        }
        super(path, invalidAttributes, project2, parentPath);
    }

    @Override
    public Icon getIcon(boolean expanded) {
        if (this.myFile.isDirectory()) {
            return PlatformIcons.DIRECTORY_CLOSED_ICON;
        }
        return FileTypeManager.getInstance().getFileTypeByFileName(this.myFile.getName()).getIcon();
    }

    @Override
    protected boolean acceptFilter(Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        try {
            VirtualFilePointer filePointer = this.getFilePointer();
            if (!filePointer.isValid()) {
                return false;
            }
            VirtualFile file2 = filePointer.getFile();
            if (file2 != null && file2.isValid() && ((PackageSetBase)filter.first).contains(file2, this.getProject(), (NamedScopesHolder)filter.second)) {
                this.applyFilter(true);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getVirtualFiles() {
        VirtualFile virtualFile = this.getFilePointer().getFile();
        if (virtualFile == null) {
            Collection<VirtualFile> collection = EMPTY_VIRTUAL_FILE_ARRAY;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/FileTreeNode", "getVirtualFiles"));
            }
            return collection;
        }
        Set<VirtualFile> set = Collections.singleton(virtualFile);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/FileTreeNode", "getVirtualFiles"));
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<File> getFiles() {
        if (this.getFilePointer().getFile() == null) {
            Set<File> set = Collections.singleton(this.myFile);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/FileTreeNode", "getFiles"));
            }
            return set;
        }
        ArrayList arrayList = EMPTY_FILE_ARRAY;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/FileTreeNode", "getFiles"));
        }
        return arrayList;
    }

    @Override
    protected int getItemsCount() {
        return 1;
    }

    @Override
    protected boolean showStatistics() {
        return false;
    }
}

