/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.PlatformFrameTitleBuilder;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class IdeaFrameTitleBuilder
extends PlatformFrameTitleBuilder {
    @Override
    public String getFileTitle(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/IdeaFrameTitleBuilder", "getFileTitle"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/wm/IdeaFrameTitleBuilder", "getFileTitle"));
        }
        String fileTitle = EditorTabbedContainer.calcTabTitle(project2, file2);
        if (SystemInfo.isMac) {
            return fileTitle;
        }
        VirtualFile parent = file2.getParent();
        if (parent == null || !fileTitle.endsWith(file2.getPresentableName())) {
            return fileTitle;
        }
        String url = FileUtil.getLocationRelativeToUserHome((String)(parent.getPresentableUrl() + File.separator + file2.getName()));
        return ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)file2, (String)url, (Project)project2, (!SystemInfo.isMac ? 1 : 0) != 0, (boolean)false);
    }
}

