/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.impl.EditorEmptyTextPainter;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.PaintersHelper;
import com.intellij.openapi.wm.impl.ToolWindowHeader;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.util.ImageLoader;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeBackgroundUtil {
    public static final String EDITOR_PROP = "idea.background.editor";
    public static final String FRAME_PROP = "idea.background.frame";
    public static final String TARGET_PROP = "idea.background.target";
    private static final Set<String> ourKnownNames;

    @NotNull
    public static Graphics2D withEditorBackground(@NotNull Graphics g, @NotNull JComponent component) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withEditorBackground"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withEditorBackground"));
        }
        if (IdeBackgroundUtil.suppressBackground(component)) {
            Graphics2D graphics2D = (Graphics2D)g;
            if (graphics2D == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withEditorBackground"));
            }
            return graphics2D;
        }
        Graphics2D graphics2D = IdeBackgroundUtil.withNamedPainters(g, EDITOR_PROP, component);
        if (graphics2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withEditorBackground"));
        }
        return graphics2D;
    }

    @NotNull
    public static Graphics2D withFrameBackground(@NotNull Graphics g, @NotNull JComponent component) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withFrameBackground"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withFrameBackground"));
        }
        if (IdeBackgroundUtil.suppressBackground(component)) {
            Graphics2D graphics2D = (Graphics2D)g;
            if (graphics2D == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withFrameBackground"));
            }
            return graphics2D;
        }
        Graphics2D graphics2D = IdeBackgroundUtil.withNamedPainters(g, FRAME_PROP, component);
        if (graphics2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withFrameBackground"));
        }
        return graphics2D;
    }

    private static boolean suppressBackground(JComponent component) {
        String type = IdeBackgroundUtil.getComponentType(component);
        if (type == null) {
            return false;
        }
        String spec = System.getProperty(TARGET_PROP, "*");
        boolean allInclusive = spec.startsWith("*");
        return allInclusive && spec.contains("-" + type) || !allInclusive && !spec.contains(type);
    }

    private static String getComponentType(JComponent component) {
        return component instanceof JTree ? "tree" : (component instanceof JList ? "list" : (component instanceof JTable ? "table" : (component instanceof JViewport ? "viewport" : (component instanceof ActionToolbar ? "toolbar" : (component instanceof EditorsSplitters ? "frame" : (component instanceof EditorComponentImpl ? "editor" : (component instanceof EditorGutterComponentEx ? "editor" : (component instanceof JBLoadingPanel ? "loading" : (component instanceof JBTabs ? "tabs" : (component instanceof ToolWindowHeader ? "title" : (component instanceof JBPanelWithEmptyText ? "panel" : (component instanceof JPanel && ourKnownNames.contains(component.getName()) ? component.getName() : null))))))))))));
    }

    @NotNull
    public static Graphics2D getOriginalGraphics(@NotNull Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "getOriginalGraphics"));
        }
        Graphics2D graphics2D = g instanceof MyGraphics ? ((MyGraphics)((Object)g)).getDelegate() : (Graphics2D)g;
        if (graphics2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "getOriginalGraphics"));
        }
        return graphics2D;
    }

    @NotNull
    public static Graphics2D withNamedPainters(@NotNull Graphics g, @NotNull String paintersName, @NotNull JComponent component) {
        PaintersHelper helper;
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withNamedPainters"));
        }
        if (paintersName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintersName", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withNamedPainters"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withNamedPainters"));
        }
        JRootPane rootPane = component.getRootPane();
        Component glassPane = rootPane == null ? null : rootPane.getGlassPane();
        PaintersHelper paintersHelper = helper = glassPane instanceof IdeGlassPaneImpl ? ((IdeGlassPaneImpl)glassPane).getNamedPainters(paintersName) : null;
        if (helper == null || !helper.needsRepaint()) {
            Graphics2D graphics2D = (Graphics2D)g;
            if (graphics2D == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withNamedPainters"));
            }
            return graphics2D;
        }
        Graphics2D graphics2D = MyGraphics.wrap(g, helper, component);
        if (graphics2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withNamedPainters"));
        }
        return graphics2D;
    }

    public static void initEditorPainters(@NotNull IdeGlassPaneImpl glassPane) {
        if (glassPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "glassPane", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "initEditorPainters"));
        }
        PaintersHelper.initWallpaperPainter(EDITOR_PROP, glassPane.getNamedPainters(EDITOR_PROP));
    }

    public static void initFramePainters(@NotNull IdeGlassPaneImpl glassPane) {
        Image centerImage;
        if (glassPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "glassPane", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "initFramePainters"));
        }
        PaintersHelper painters = glassPane.getNamedPainters(FRAME_PROP);
        PaintersHelper.initWallpaperPainter(FRAME_PROP, painters);
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        String path = null;
        URL url = path == null ? null : ((Object)((Object)appInfo)).getClass().getResource(path);
        Image image = centerImage = url == null ? null : ImageLoader.loadFromUrl((URL)url);
        if (centerImage != null) {
            painters.addPainter((Painter)PaintersHelper.newImagePainter(centerImage, PaintersHelper.Fill.PLAIN, PaintersHelper.Place.TOP_CENTER, 1.0f, (Insets)JBUI.insets((int)10, (int)0, (int)0, (int)0)), null);
        }
        painters.addPainter((Painter)new AbstractPainter(){
            EditorEmptyTextPainter p = (EditorEmptyTextPainter)ServiceManager.getService(EditorEmptyTextPainter.class);

            public boolean needsRepaint() {
                return true;
            }

            public void executePaint(Component component, Graphics2D g) {
                this.p.paintEmptyText((JComponent)component, g);
            }
        }, null);
    }

    @Nullable
    public static Color getIdeBackgroundColor() {
        Color result2 = UIUtil.getSlightlyDarkerColor((Color)UIUtil.getPanelBackground());
        return UIUtil.isUnderDarcula() ? new Color(40, 40, 41) : UIUtil.getSlightlyDarkerColor((Color)UIUtil.getSlightlyDarkerColor((Color)result2));
    }

    public static void createTemporaryBackgroundTransform(JPanel root, String tmp, Disposable disposable) {
        PaintersHelper paintersHelper = new PaintersHelper(root);
        PaintersHelper.initWallpaperPainter(tmp, paintersHelper);
        Disposer.register((Disposable)disposable, (Disposable)JBSwingUtilities.addGlobalCGTransform((t, v) -> {
            if (!UIUtil.isAncestor((Component)root, (Component)t)) {
                return v;
            }
            return MyGraphics.wrap(v, paintersHelper, t);
        }));
    }

    @NotNull
    public static String getBackgroundSpec(@Nullable Project project2, @NotNull String propertyName) {
        String spec;
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "getBackgroundSpec"));
        }
        String string = spec = project2 == null ? null : PropertiesComponent.getInstance((Project)project2).getValue(propertyName);
        if (spec == null) {
            spec = PropertiesComponent.getInstance().getValue(propertyName);
        }
        String string2 = StringUtil.notNullize((String)spec, (String)System.getProperty(propertyName, ""));
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "getBackgroundSpec"));
        }
        return string2;
    }

    public static void repaintAllWindows() {
        for (Window window : Window.getWindows()) {
            window.repaint();
        }
    }

    static {
        JBSwingUtilities.addGlobalCGTransform((PairFunction)new MyTransform());
        ourKnownNames = ContainerUtil.newHashSet((Object[])new String[]{"navbar", "terminal"});
    }

    private static class MyTransform
    implements PairFunction<JComponent, Graphics2D, Graphics2D> {
        private MyTransform() {
        }

        public Graphics2D fun(JComponent c, Graphics2D g) {
            String type = IdeBackgroundUtil.getComponentType(c);
            if ("editor".equals(type)) {
                EditorImpl editor;
                EditorImpl editorImpl = c instanceof EditorComponentImpl ? ((EditorComponentImpl)c).getEditor() : (editor = c instanceof EditorGutterComponentEx ? (Editor)CommonDataKeys.EDITOR.getData((DataProvider)c) : null);
                if (Boolean.TRUE.equals(EditorTextField.SUPPLEMENTARY_KEY.get((UserDataHolder)editor))) {
                    return g;
                }
            }
            if ("frame".equals(type)) {
                return IdeBackgroundUtil.withFrameBackground(g, c);
            }
            return type != null ? IdeBackgroundUtil.withEditorBackground(g, c) : g;
        }
    }

    private static class MyGraphics
    extends Graphics2DDelegate {
        final PaintersHelper helper;
        final int[] offsets;

        static Graphics2D wrap(Graphics g, PaintersHelper helper, JComponent component) {
            return new MyGraphics(g instanceof MyGraphics ? ((MyGraphics)((Object)g)).getDelegate() : g, helper, helper.computeOffsets(g, component));
        }

        MyGraphics(Graphics g, PaintersHelper helper, int[] offsets) {
            super((Graphics2D)g);
            this.helper = helper;
            this.offsets = offsets;
        }

        @NotNull
        public Graphics create() {
            MyGraphics myGraphics = new MyGraphics(this.getDelegate().create(), this.helper, this.offsets);
            if (myGraphics == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil$MyGraphics", "create"));
            }
            return myGraphics;
        }

        public void clearRect(int x, int y, int width, int height) {
            super.clearRect(x, y, width, height);
            this.runAllPainters(x, y, width, height, this.getColor());
        }

        public void fillRect(int x, int y, int width, int height) {
            super.fillRect(x, y, width, height);
            this.runAllPainters(x, y, width, height, this.getColor());
        }

        public void fill(Shape s) {
            super.fill(s);
            Rectangle r = s.getBounds();
            this.runAllPainters(r.x, r.y, r.width, r.height, this.getColor());
        }

        public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
            super.drawImage(img, op, x, y);
            this.runAllPainters(x, y, img.getWidth(), img.getHeight(), img);
        }

        public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
            boolean b = super.drawImage(img, x, y, width, height, observer);
            this.runAllPainters(x, y, width, height, img);
            return b;
        }

        public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
            boolean b = super.drawImage(img, x, y, observer);
            this.runAllPainters(x, y, img.getWidth(null), img.getHeight(null), img);
            return b;
        }

        void runAllPainters(int x, int y, int width, int height, Object reason) {
            Shape s;
            if (width <= 1 || height <= 1) {
                return;
            }
            if (reason instanceof Color && ((Color)reason).getAlpha() < 255) {
                return;
            }
            if (reason instanceof Image) {
                if (!(reason instanceof BufferedImage)) {
                    return;
                }
                if (((BufferedImage)reason).getColorModel().hasAlpha()) {
                    return;
                }
            }
            Rectangle newClip = (s = this.getClip()) == null ? new Rectangle(x, y, width, height) : SwingUtilities.computeIntersection(x, y, width, height, s.getBounds());
            this.setClip(newClip);
            this.helper.runAllPainters(this.getDelegate(), this.offsets);
            this.setClip(s);
        }
    }
}

