/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.components.MainConfigurationStateSplitter;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProvider;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DependencyValidationManager", storages={@Storage(value="scopes", stateSplitter=ScopesStateSplitter.class)})
public class DependencyValidationManagerImpl
extends DependencyValidationManager {
    private static final NotNullLazyValue<Icon> ourSharedScopeIcon = new NotNullLazyValue<Icon>(){

        @NotNull
        protected Icon compute() {
            LayeredIcon layeredIcon = new LayeredIcon(new Icon[]{AllIcons.Ide.LocalScope, AllIcons.Nodes.Shared});
            if (layeredIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl$1", "compute"));
            }
            return layeredIcon;
        }
    };
    private final List<DependencyRule> myRules = new ArrayList<DependencyRule>();
    private final NamedScopeManager myNamedScopeManager;
    private boolean mySkipImportStatements;
    private boolean mySkipImportStatementsWasSpecified;
    @NonNls
    private static final String DENY_RULE_KEY = "deny_rule";
    @NonNls
    private static final String FROM_SCOPE_KEY = "from_scope";
    @NonNls
    private static final String TO_SCOPE_KEY = "to_scope";
    @NonNls
    private static final String IS_DENY_KEY = "is_deny";
    @NonNls
    private static final String UNNAMED_SCOPE = "unnamed_scope";
    @NonNls
    private static final String VALUE = "value";
    private final Map<String, PackageSet> myUnnamedScopes = new THashMap();
    private final List<Pair<NamedScope, NamedScopesHolder>> myScopePairs = ContainerUtil.createLockFreeCopyOnWriteList();

    public DependencyValidationManagerImpl(Project project2, NamedScopeManager namedScopeManager) {
        super(project2);
        this.myNamedScopeManager = namedScopeManager;
        namedScopeManager.addScopeListener(new NamedScopesHolder.ScopeListener(){

            public void scopesChanged() {
                DependencyValidationManagerImpl.this.reloadScopes();
            }
        });
    }

    @NotNull
    public List<NamedScope> getPredefinedScopes() {
        CustomScopesProvider[] scopesProviders;
        ArrayList<NamedScope> predefinedScopes = new ArrayList<NamedScope>();
        for (CustomScopesProvider scopesProvider : scopesProviders = (CustomScopesProvider[])CustomScopesProvider.CUSTOM_SCOPES_PROVIDER.getExtensions((AreaInstance)this.myProject)) {
            predefinedScopes.addAll(scopesProvider.getFilteredScopes());
        }
        ArrayList<NamedScope> arrayList = predefinedScopes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getPredefinedScopes"));
        }
        return arrayList;
    }

    public NamedScope getPredefinedScope(@NotNull String name) {
        CustomScopesProvider[] scopesProviders;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getPredefinedScope"));
        }
        for (CustomScopesProvider scopesProvider : scopesProviders = (CustomScopesProvider[])CustomScopesProvider.CUSTOM_SCOPES_PROVIDER.getExtensions((AreaInstance)this.myProject)) {
            NamedScope scope;
            NamedScope namedScope = scope = scopesProvider instanceof CustomScopesProviderEx ? ((CustomScopesProviderEx)scopesProvider).getCustomScope(name) : CustomScopesProviderEx.findPredefinedScope((String)name, (List)scopesProvider.getFilteredScopes());
            if (scope == null) continue;
            return scope;
        }
        return null;
    }

    public boolean hasRules() {
        return !this.myRules.isEmpty();
    }

    @Nullable
    public DependencyRule getViolatorDependencyRule(@NotNull PsiFile from, @NotNull PsiFile to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getViolatorDependencyRule"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getViolatorDependencyRule"));
        }
        for (DependencyRule dependencyRule : this.myRules) {
            if (!dependencyRule.isForbiddenToUse(from, to)) continue;
            return dependencyRule;
        }
        return null;
    }

    @NotNull
    public DependencyRule[] getViolatorDependencyRules(@NotNull PsiFile from, @NotNull PsiFile to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getViolatorDependencyRules"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getViolatorDependencyRules"));
        }
        ArrayList<DependencyRule> result2 = new ArrayList<DependencyRule>();
        for (DependencyRule dependencyRule : this.myRules) {
            if (!dependencyRule.isForbiddenToUse(from, to)) continue;
            result2.add(dependencyRule);
        }
        DependencyRule[] dependencyRuleArray = result2.toArray(new DependencyRule[result2.size()]);
        if (dependencyRuleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getViolatorDependencyRules"));
        }
        return dependencyRuleArray;
    }

    @NotNull
    public DependencyRule[] getApplicableRules(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getApplicableRules"));
        }
        ArrayList<DependencyRule> result2 = new ArrayList<DependencyRule>();
        for (DependencyRule dependencyRule : this.myRules) {
            if (!dependencyRule.isApplicable(file2)) continue;
            result2.add(dependencyRule);
        }
        DependencyRule[] dependencyRuleArray = result2.toArray(new DependencyRule[result2.size()]);
        if (dependencyRuleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getApplicableRules"));
        }
        return dependencyRuleArray;
    }

    public boolean skipImportStatements() {
        return this.mySkipImportStatements;
    }

    public void setSkipImportStatements(boolean skip) {
        this.mySkipImportStatements = skip;
    }

    @NotNull
    public Map<String, PackageSet> getUnnamedScopes() {
        Map<String, PackageSet> map = this.myUnnamedScopes;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getUnnamedScopes"));
        }
        return map;
    }

    @NotNull
    public DependencyRule[] getAllRules() {
        DependencyRule[] dependencyRuleArray = this.myRules.toArray(new DependencyRule[this.myRules.size()]);
        if (dependencyRuleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getAllRules"));
        }
        return dependencyRuleArray;
    }

    public void removeAllRules() {
        this.myRules.clear();
    }

    public void addRule(@NotNull DependencyRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "addRule"));
        }
        this.appendUnnamedScope(rule.getFromScope());
        this.appendUnnamedScope(rule.getToScope());
        this.myRules.add(rule);
    }

    public void reloadRules() {
        Element element = new Element("rules_2_reload");
        this.writeRules(element);
        this.readRules(element);
    }

    private void appendUnnamedScope(NamedScope fromScope) {
        PackageSet packageSet;
        if (this.getScope(fromScope.getName()) == null && (packageSet = fromScope.getValue()) != null && !this.myUnnamedScopes.containsKey(packageSet.getText())) {
            this.myUnnamedScopes.put(packageSet.getText(), packageSet);
        }
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"shared.scopes.node.text", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return (Icon)ourSharedScopeIcon.getValue();
    }

    public void loadState(Element element) {
        Element option = element.getChild("option");
        if (option != null && "SKIP_IMPORT_STATEMENTS".equals(option.getAttributeValue("name"))) {
            this.mySkipImportStatementsWasSpecified = !this.myProject.isDefault();
            this.mySkipImportStatements = Boolean.parseBoolean(option.getAttributeValue(VALUE));
        }
        super.loadState(element);
        NamedScope[] scopes = this.getEditableScopes();
        Arrays.sort(scopes, (s1, s2) -> {
            int i2;
            String name2;
            String name1 = s1.getName();
            if (Comparing.equal((String)name1, (String)(name2 = s2.getName()))) {
                return 0;
            }
            List order = this.myNamedScopeManager.myOrderState.myOrder;
            int i1 = order.indexOf(name1);
            return i1 > (i2 = order.indexOf(name2)) ? 1 : -1;
        });
        super.setScopes(scopes);
        this.myUnnamedScopes.clear();
        List unnamedScopes = element.getChildren(UNNAMED_SCOPE);
        PackageSetFactory packageSetFactory = PackageSetFactory.getInstance();
        for (Object unnamedScope : unnamedScopes) {
            try {
                String packageSet = ((Element)unnamedScope).getAttributeValue(VALUE);
                this.myUnnamedScopes.put(packageSet, packageSetFactory.compile(packageSet));
            }
            catch (ParsingException parsingException) {}
        }
        this.readRules(element);
    }

    private void readRules(Element element) {
        this.removeAllRules();
        for (Element rule1 : element.getChildren(DENY_RULE_KEY)) {
            DependencyRule rule = this.readRule(rule1);
            if (rule == null) continue;
            this.addRule(rule);
        }
    }

    public Element getState() {
        Element element = super.getState();
        assert (element != null);
        if (this.mySkipImportStatements || this.mySkipImportStatementsWasSpecified) {
            element.addContent(new Element("option").setAttribute("name", "SKIP_IMPORT_STATEMENTS").setAttribute(VALUE, Boolean.toString(this.mySkipImportStatements)));
        }
        if (!this.myUnnamedScopes.isEmpty()) {
            Object[] unnamedScopes = this.myUnnamedScopes.keySet().toArray(new String[this.myUnnamedScopes.size()]);
            Arrays.sort(unnamedScopes);
            for (Object unnamedScope : unnamedScopes) {
                element.addContent(new Element(UNNAMED_SCOPE).setAttribute(VALUE, (String)unnamedScope));
            }
        }
        this.writeRules(element);
        return element;
    }

    private void writeRules(Element element) {
        for (DependencyRule rule : this.myRules) {
            Element ruleElement = DependencyValidationManagerImpl.writeRule(rule);
            if (ruleElement == null) continue;
            element.addContent(ruleElement);
        }
    }

    @Nullable
    public NamedScope getScope(@Nullable String name) {
        PackageSet packageSet;
        NamedScope scope = super.getScope(name);
        if (scope == null && (packageSet = this.myUnnamedScopes.get(name)) != null) {
            return new NamedScope.UnnamedScope(packageSet);
        }
        if (scope == null && Comparing.strEqual((String)name, (String)"Project")) {
            return super.getScope("All");
        }
        return scope;
    }

    @Nullable
    private static Element writeRule(DependencyRule rule) {
        NamedScope fromScope = rule.getFromScope();
        NamedScope toScope = rule.getToScope();
        if (fromScope == null || toScope == null) {
            return null;
        }
        Element ruleElement = new Element(DENY_RULE_KEY);
        ruleElement.setAttribute(FROM_SCOPE_KEY, fromScope.getName());
        ruleElement.setAttribute(TO_SCOPE_KEY, toScope.getName());
        ruleElement.setAttribute(IS_DENY_KEY, Boolean.valueOf(rule.isDenyRule()).toString());
        return ruleElement;
    }

    @Nullable
    private DependencyRule readRule(Element ruleElement) {
        String fromScope = ruleElement.getAttributeValue(FROM_SCOPE_KEY);
        String toScope = ruleElement.getAttributeValue(TO_SCOPE_KEY);
        String denyRule = ruleElement.getAttributeValue(IS_DENY_KEY);
        if (fromScope == null || toScope == null || denyRule == null) {
            return null;
        }
        NamedScope fromNamedScope = this.getScope(fromScope);
        NamedScope toNamedScope = this.getScope(toScope);
        if (fromNamedScope == null || toNamedScope == null) {
            return null;
        }
        return new DependencyRule(fromNamedScope, toNamedScope, Boolean.valueOf(denyRule).booleanValue());
    }

    private void reloadScopes() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.getProject().isDisposed()) {
                return;
            }
            ArrayList<Pair<NamedScope, NamedScopesHolder>> scopeList = new ArrayList<Pair<NamedScope, NamedScopesHolder>>();
            DependencyValidationManagerImpl.addScopesToList(scopeList, (NamedScopesHolder)this);
            DependencyValidationManagerImpl.addScopesToList(scopeList, (NamedScopesHolder)this.myNamedScopeManager);
            this.myScopePairs.clear();
            this.myScopePairs.addAll(scopeList);
            this.reloadRules();
        });
    }

    private static void addScopesToList(@NotNull List<Pair<NamedScope, NamedScopesHolder>> scopeList, @NotNull NamedScopesHolder holder) {
        if (scopeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeList", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "addScopesToList"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "addScopesToList"));
        }
        for (NamedScope scope : holder.getScopes()) {
            scopeList.add((Pair<NamedScope, NamedScopesHolder>)Pair.create((Object)scope, (Object)holder));
        }
    }

    @NotNull
    public List<Pair<NamedScope, NamedScopesHolder>> getScopeBasedHighlightingCachedScopes() {
        List<Pair<NamedScope, NamedScopesHolder>> list = this.myScopePairs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getScopeBasedHighlightingCachedScopes"));
        }
        return list;
    }

    public void fireScopeListeners() {
        super.fireScopeListeners();
        this.reloadScopes();
    }

    public void setScopes(NamedScope[] scopes) {
        super.setScopes(scopes);
        List order = this.myNamedScopeManager.myOrderState.myOrder;
        order.clear();
        for (NamedScope scope : scopes) {
            order.add(scope.getName());
        }
    }

    static final class ScopesStateSplitter
    extends MainConfigurationStateSplitter {
        ScopesStateSplitter() {
        }

        @NotNull
        protected String getSubStateFileName(@NotNull Element element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packageDependencies/DependencyValidationManagerImpl$ScopesStateSplitter", "getSubStateFileName"));
            }
            String string = element.getAttributeValue("name");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl$ScopesStateSplitter", "getSubStateFileName"));
            }
            return string;
        }

        @NotNull
        protected String getComponentStateFileName() {
            if ("scope_settings" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl$ScopesStateSplitter", "getComponentStateFileName"));
            }
            return "scope_settings";
        }

        @NotNull
        protected String getSubStateTagName() {
            if ("scope" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl$ScopesStateSplitter", "getSubStateTagName"));
            }
            return "scope";
        }
    }
}

