/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ConfigurationErrorType;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.impl.artifacts.InvalidArtifact;
import org.jetbrains.annotations.NotNull;

public class ArtifactLoadingErrorDescription
extends ConfigurationErrorDescription {
    private static final ConfigurationErrorType INVALID_ARTIFACT = new ConfigurationErrorType("artifact", false);
    private final Project myProject;
    private final InvalidArtifact myArtifact;

    public ArtifactLoadingErrorDescription(Project project2, InvalidArtifact artifact) {
        super(artifact.getName(), artifact.getErrorMessage(), INVALID_ARTIFACT);
        this.myProject = project2;
        this.myArtifact = artifact;
    }

    @Override
    public void ignoreInvalidElement() {
        final ModifiableArtifactModel model = ArtifactManager.getInstance((Project)this.myProject).createModifiableModel();
        model.removeArtifact((Artifact)this.myArtifact);
        new WriteAction(){

            protected void run(@NotNull Result result2) {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/packaging/impl/artifacts/ArtifactLoadingErrorDescription$1", "run"));
                }
                model.commit();
            }
        }.execute();
    }

    @Override
    public String getIgnoreConfirmationMessage() {
        return "Would you like to remove artifact '" + this.myArtifact.getName() + "?";
    }

    @Override
    public boolean isValid() {
        return ArtifactManager.getInstance((Project)this.myProject).getAllArtifactsIncludingInvalid().contains((Object)this.myArtifact);
    }
}

