/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.CompositePackagingElementType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ArchiveElementType;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.ArtifactRootElementImpl;
import com.intellij.packaging.impl.elements.CompositeElementWithManifest;
import com.intellij.packaging.impl.elements.DirectoryCopyElementType;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryElementType;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.impl.elements.ExtractedDirectoryElementType;
import com.intellij.packaging.impl.elements.ExtractedDirectoryPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyElementType;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import com.intellij.packaging.impl.elements.TestModuleOutputElementType;
import com.intellij.packaging.impl.elements.TestModuleOutputPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingElementFactoryImpl
extends PackagingElementFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.packaging.impl.elements.PackagingElementFactoryImpl");
    public static final PackagingElementType<DirectoryPackagingElement> DIRECTORY_ELEMENT_TYPE = new DirectoryElementType();
    public static final PackagingElementType<ArchivePackagingElement> ARCHIVE_ELEMENT_TYPE = new ArchiveElementType();
    public static final PackagingElementType<FileCopyPackagingElement> FILE_COPY_ELEMENT_TYPE = new FileCopyElementType();
    public static final PackagingElementType<DirectoryCopyPackagingElement> DIRECTORY_COPY_ELEMENT_TYPE = new DirectoryCopyElementType();
    public static final PackagingElementType<ExtractedDirectoryPackagingElement> EXTRACTED_DIRECTORY_ELEMENT_TYPE = new ExtractedDirectoryElementType();
    public static final PackagingElementType<ArtifactRootElement<?>> ARTIFACT_ROOT_ELEMENT_TYPE = new ArtifactRootElementType();
    private static final PackagingElementType[] STANDARD_TYPES = new PackagingElementType[]{DIRECTORY_ELEMENT_TYPE, ARCHIVE_ELEMENT_TYPE, LibraryElementType.LIBRARY_ELEMENT_TYPE, ProductionModuleOutputElementType.ELEMENT_TYPE, TestModuleOutputElementType.ELEMENT_TYPE, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, FILE_COPY_ELEMENT_TYPE, DIRECTORY_COPY_ELEMENT_TYPE, EXTRACTED_DIRECTORY_ELEMENT_TYPE};

    @NotNull
    public PackagingElementType<?>[] getNonCompositeElementTypes() {
        ArrayList<PackagingElementType> elementTypes = new ArrayList<PackagingElementType>();
        for (PackagingElementType elementType : this.getAllElementTypes()) {
            if (elementType instanceof CompositePackagingElementType) continue;
            elementTypes.add(elementType);
        }
        PackagingElementType[] packagingElementTypeArray = elementTypes.toArray(new PackagingElementType[elementTypes.size()]);
        if (packagingElementTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "getNonCompositeElementTypes"));
        }
        return packagingElementTypeArray;
    }

    @NotNull
    public ComplexPackagingElementType<?>[] getComplexElementTypes() {
        ArrayList<ComplexPackagingElementType> types = new ArrayList<ComplexPackagingElementType>();
        for (PackagingElementType type : this.getAllElementTypes()) {
            if (!(type instanceof ComplexPackagingElementType)) continue;
            types.add((ComplexPackagingElementType)type);
        }
        ComplexPackagingElementType[] complexPackagingElementTypeArray = types.toArray(new ComplexPackagingElementType[types.size()]);
        if (complexPackagingElementTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "getComplexElementTypes"));
        }
        return complexPackagingElementTypeArray;
    }

    @NotNull
    public CompositePackagingElementType<?>[] getCompositeElementTypes() {
        ArrayList<CompositePackagingElementType> elementTypes = new ArrayList<CompositePackagingElementType>();
        for (PackagingElementType elementType : this.getAllElementTypes()) {
            if (!(elementType instanceof CompositePackagingElementType)) continue;
            elementTypes.add((CompositePackagingElementType)elementType);
        }
        CompositePackagingElementType[] compositePackagingElementTypeArray = elementTypes.toArray(new CompositePackagingElementType[elementTypes.size()]);
        if (compositePackagingElementTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "getCompositeElementTypes"));
        }
        return compositePackagingElementTypeArray;
    }

    public PackagingElementType<?> findElementType(String id) {
        for (PackagingElementType elementType : this.getAllElementTypes()) {
            if (!elementType.getId().equals(id)) continue;
            return elementType;
        }
        if (id.equals(ARTIFACT_ROOT_ELEMENT_TYPE.getId())) {
            return ARTIFACT_ROOT_ELEMENT_TYPE;
        }
        return null;
    }

    @NotNull
    public PackagingElementType[] getAllElementTypes() {
        Object[] types = (PackagingElementType[])Extensions.getExtensions((ExtensionPointName)PackagingElementType.EP_NAME);
        PackagingElementType[] packagingElementTypeArray = (PackagingElementType[])ArrayUtil.mergeArrays((Object[])STANDARD_TYPES, (Object[])types);
        if (packagingElementTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "getAllElementTypes"));
        }
        return packagingElementTypeArray;
    }

    @NotNull
    public PackagingElement<?> createArtifactElement(@NotNull Artifact artifact, @NotNull Project project2) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createArtifactElement"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createArtifactElement"));
        }
        ArtifactPackagingElement artifactPackagingElement = new ArtifactPackagingElement(project2, ArtifactPointerManager.getInstance((Project)project2).createPointer(artifact));
        if (artifactPackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createArtifactElement"));
        }
        return artifactPackagingElement;
    }

    @NotNull
    public DirectoryPackagingElement createDirectory(@NotNull @NonNls String directoryName) {
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryName", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createDirectory"));
        }
        DirectoryPackagingElement directoryPackagingElement = new DirectoryPackagingElement(directoryName);
        if (directoryPackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createDirectory"));
        }
        return directoryPackagingElement;
    }

    @NotNull
    public ArtifactRootElement<?> createArtifactRootElement() {
        ArtifactRootElementImpl artifactRootElementImpl = new ArtifactRootElementImpl();
        if (artifactRootElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createArtifactRootElement"));
        }
        return artifactRootElementImpl;
    }

    @NotNull
    public CompositePackagingElement<?> getOrCreateDirectory(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "getOrCreateDirectory"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "getOrCreateDirectory"));
        }
        CompositePackagingElement<?> compositePackagingElement = this.getOrCreateDirectoryOrArchive(parent, relativePath, true);
        if (compositePackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "getOrCreateDirectory"));
        }
        return compositePackagingElement;
    }

    @NotNull
    public CompositePackagingElement<?> getOrCreateArchive(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "getOrCreateArchive"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "getOrCreateArchive"));
        }
        CompositePackagingElement<?> compositePackagingElement = this.getOrCreateDirectoryOrArchive(parent, relativePath, false);
        if (compositePackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "getOrCreateArchive"));
        }
        return compositePackagingElement;
    }

    public void addFileCopy(@NotNull CompositePackagingElement<?> root, @NotNull String outputDirectoryPath, @NotNull String sourceFilePath) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "addFileCopy"));
        }
        if (outputDirectoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDirectoryPath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "addFileCopy"));
        }
        if (sourceFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFilePath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "addFileCopy"));
        }
        this.addFileCopy(root, outputDirectoryPath, sourceFilePath, null);
    }

    public void addFileCopy(@NotNull CompositePackagingElement<?> root, @NotNull String outputDirectoryPath, @NotNull String sourceFilePath, @Nullable String outputFileName) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "addFileCopy"));
        }
        if (outputDirectoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDirectoryPath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "addFileCopy"));
        }
        if (sourceFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFilePath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "addFileCopy"));
        }
        String fileName = PathUtil.getFileName((String)sourceFilePath);
        if (outputFileName != null && outputFileName.equals(fileName)) {
            outputFileName = null;
        }
        this.getOrCreateDirectory(root, outputDirectoryPath).addOrFindChild(this.createFileCopy(sourceFilePath, outputFileName));
    }

    @NotNull
    private CompositePackagingElement<?> getOrCreateDirectoryOrArchive(@NotNull CompositePackagingElement<?> root, @NotNull @NonNls String path, boolean directory) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "getOrCreateDirectoryOrArchive"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "getOrCreateDirectoryOrArchive"));
        }
        if ((path = StringUtil.trimStart((String)StringUtil.trimEnd((String)path, (String)"/"), (String)"/")).length() == 0) {
            CompositePackagingElement<?> compositePackagingElement = root;
            if (compositePackagingElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "getOrCreateDirectoryOrArchive"));
            }
            return compositePackagingElement;
        }
        int index = path.lastIndexOf(47);
        String lastName = path.substring(index + 1);
        String parentPath = index != -1 ? path.substring(0, index) : "";
        CompositePackagingElement<?> parent = this.getOrCreateDirectoryOrArchive(root, parentPath, true);
        CompositePackagingElement<?> last = directory ? this.createDirectory(lastName) : this.createArchive(lastName);
        CompositePackagingElement compositePackagingElement = (CompositePackagingElement)parent.addOrFindChild(last);
        if (compositePackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "getOrCreateDirectoryOrArchive"));
        }
        return compositePackagingElement;
    }

    @NotNull
    public PackagingElement<?> createModuleOutput(@NotNull String moduleName, @NotNull Project project2) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createModuleOutput"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createModuleOutput"));
        }
        ModulePointer pointer = ModulePointerManager.getInstance((Project)project2).create(moduleName);
        ProductionModuleOutputPackagingElement productionModuleOutputPackagingElement = new ProductionModuleOutputPackagingElement(project2, pointer);
        if (productionModuleOutputPackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createModuleOutput"));
        }
        return productionModuleOutputPackagingElement;
    }

    @NotNull
    public PackagingElement<?> createModuleOutput(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createModuleOutput"));
        }
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)module2.getProject()).create(module2);
        ProductionModuleOutputPackagingElement productionModuleOutputPackagingElement = new ProductionModuleOutputPackagingElement(module2.getProject(), modulePointer);
        if (productionModuleOutputPackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createModuleOutput"));
        }
        return productionModuleOutputPackagingElement;
    }

    @NotNull
    public PackagingElement<?> createTestModuleOutput(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createTestModuleOutput"));
        }
        ModulePointer pointer = ModulePointerManager.getInstance((Project)module2.getProject()).create(module2);
        TestModuleOutputPackagingElement testModuleOutputPackagingElement = new TestModuleOutputPackagingElement(module2.getProject(), pointer);
        if (testModuleOutputPackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createTestModuleOutput"));
        }
        return testModuleOutputPackagingElement;
    }

    @NotNull
    public List<? extends PackagingElement<?>> createLibraryElements(@NotNull Library library) {
        Module module2;
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createLibraryElements"));
        }
        LibraryTable table = library.getTable();
        String libraryName = library.getName();
        if (table != null) {
            List<PackagingElement<?>> list = Collections.singletonList(this.createLibraryFiles(libraryName, table.getTableLevel(), null));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createLibraryElements"));
            }
            return list;
        }
        if (libraryName != null && (module2 = ((LibraryImpl)library).getModule()) != null) {
            List<PackagingElement<?>> list = Collections.singletonList(this.createLibraryFiles(libraryName, "module", module2.getName()));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createLibraryElements"));
            }
            return list;
        }
        ArrayList<FileCopyPackagingElement> elements = new ArrayList<FileCopyPackagingElement>();
        for (VirtualFile file2 : library.getFiles(OrderRootType.CLASSES)) {
            String path = FileUtil.toSystemIndependentName((String)PathUtil.getLocalPath((VirtualFile)file2));
            elements.add((FileCopyPackagingElement)(file2.isDirectory() && file2.isInLocalFileSystem() ? new DirectoryCopyPackagingElement(path) : new FileCopyPackagingElement(path)));
        }
        ArrayList<FileCopyPackagingElement> arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createLibraryElements"));
        }
        return arrayList;
    }

    @NotNull
    public PackagingElement<?> createArtifactElement(@NotNull ArtifactPointer artifactPointer, @NotNull Project project2) {
        if (artifactPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactPointer", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createArtifactElement"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createArtifactElement"));
        }
        ArtifactPackagingElement artifactPackagingElement = new ArtifactPackagingElement(project2, artifactPointer);
        if (artifactPackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createArtifactElement"));
        }
        return artifactPackagingElement;
    }

    @NotNull
    public PackagingElement<?> createLibraryFiles(@NotNull String libraryName, @NotNull String level, String moduleName) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createLibraryFiles"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createLibraryFiles"));
        }
        LibraryPackagingElement libraryPackagingElement = new LibraryPackagingElement(level, libraryName, moduleName);
        if (libraryPackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createLibraryFiles"));
        }
        return libraryPackagingElement;
    }

    @NotNull
    public CompositePackagingElement<?> createArchive(@NotNull @NonNls String archiveFileName) {
        if (archiveFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archiveFileName", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createArchive"));
        }
        ArchivePackagingElement archivePackagingElement = new ArchivePackagingElement(archiveFileName);
        if (archivePackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createArchive"));
        }
        return archivePackagingElement;
    }

    @Nullable
    private static PackagingElement<?> findArchiveOrDirectoryByName(@NotNull CompositePackagingElement<?> parent, @NotNull String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "findArchiveOrDirectoryByName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "findArchiveOrDirectoryByName"));
        }
        for (PackagingElement element : parent.getChildren()) {
            if ((!(element instanceof ArchivePackagingElement) || !((ArchivePackagingElement)element).getArchiveFileName().equals(name)) && (!(element instanceof DirectoryPackagingElement) || !((DirectoryPackagingElement)element).getDirectoryName().equals(name))) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public static String suggestFileName(@NotNull CompositePackagingElement<?> parent, @NonNls @NotNull String prefix, @NonNls @NotNull String suffix) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "suggestFileName"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "suggestFileName"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "suggestFileName"));
        }
        String name = prefix + suffix;
        int i = 2;
        while (PackagingElementFactoryImpl.findArchiveOrDirectoryByName(parent, name) != null) {
            name = prefix + i++ + suffix;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "suggestFileName"));
        }
        return string;
    }

    @NotNull
    public PackagingElement<?> createDirectoryCopyWithParentDirectories(@NotNull String filePath, @NotNull String relativeOutputPath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createDirectoryCopyWithParentDirectories"));
        }
        if (relativeOutputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeOutputPath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createDirectoryCopyWithParentDirectories"));
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(relativeOutputPath, new DirectoryCopyPackagingElement(filePath));
        if (packagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createDirectoryCopyWithParentDirectories"));
        }
        return packagingElement;
    }

    @NotNull
    public PackagingElement<?> createExtractedDirectoryWithParentDirectories(@NotNull String jarPath, @NotNull String pathInJar, @NotNull String relativeOutputPath) {
        if (jarPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarPath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createExtractedDirectoryWithParentDirectories"));
        }
        if (pathInJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathInJar", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createExtractedDirectoryWithParentDirectories"));
        }
        if (relativeOutputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeOutputPath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createExtractedDirectoryWithParentDirectories"));
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(relativeOutputPath, new ExtractedDirectoryPackagingElement(jarPath, pathInJar));
        if (packagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createExtractedDirectoryWithParentDirectories"));
        }
        return packagingElement;
    }

    @NotNull
    public PackagingElement<?> createExtractedDirectory(@NotNull VirtualFile jarEntry) {
        if (jarEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarEntry", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createExtractedDirectory"));
        }
        LOG.assertTrue(jarEntry.getFileSystem() instanceof JarFileSystem, (Object)("Expected file from JAR but file from " + jarEntry.getFileSystem() + " found"));
        String fullPath = jarEntry.getPath();
        int jarEnd = fullPath.indexOf("!/");
        ExtractedDirectoryPackagingElement extractedDirectoryPackagingElement = new ExtractedDirectoryPackagingElement(fullPath.substring(0, jarEnd), fullPath.substring(jarEnd + 1));
        if (extractedDirectoryPackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createExtractedDirectory"));
        }
        return extractedDirectoryPackagingElement;
    }

    @NotNull
    public PackagingElement<?> createFileCopyWithParentDirectories(@NotNull String filePath, @NotNull String relativeOutputPath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createFileCopyWithParentDirectories"));
        }
        if (relativeOutputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeOutputPath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createFileCopyWithParentDirectories"));
        }
        PackagingElement<?> packagingElement = this.createFileCopyWithParentDirectories(filePath, relativeOutputPath, null);
        if (packagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createFileCopyWithParentDirectories"));
        }
        return packagingElement;
    }

    @NotNull
    public PackagingElement<?> createFileCopyWithParentDirectories(@NotNull String filePath, @NotNull String relativeOutputPath, @Nullable String outputFileName) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createFileCopyWithParentDirectories"));
        }
        if (relativeOutputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeOutputPath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createFileCopyWithParentDirectories"));
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(relativeOutputPath, this.createFileCopy(filePath, outputFileName));
        if (packagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createFileCopyWithParentDirectories"));
        }
        return packagingElement;
    }

    public PackagingElement<?> createFileCopy(@NotNull String filePath, String outputFileName) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createFileCopy"));
        }
        return new FileCopyPackagingElement(filePath, outputFileName);
    }

    @NotNull
    public PackagingElement<?> createParentDirectories(@NotNull String relativeOutputPath, @NotNull PackagingElement<?> element) {
        if (relativeOutputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeOutputPath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createParentDirectories"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createParentDirectories"));
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(relativeOutputPath, Collections.singletonList(element)).get(0);
        if (packagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createParentDirectories"));
        }
        return packagingElement;
    }

    @NotNull
    public List<? extends PackagingElement<?>> createParentDirectories(@NotNull String relativeOutputPath, @NotNull List<? extends PackagingElement<?>> elements) {
        if (relativeOutputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeOutputPath", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createParentDirectories"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createParentDirectories"));
        }
        if ((relativeOutputPath = StringUtil.trimStart((String)relativeOutputPath, (String)"/")).length() == 0) {
            List<? extends PackagingElement<?>> list = elements;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createParentDirectories"));
            }
            return list;
        }
        int slash = relativeOutputPath.indexOf(47);
        if (slash == -1) {
            slash = relativeOutputPath.length();
        }
        String rootName = relativeOutputPath.substring(0, slash);
        String pathTail = relativeOutputPath.substring(slash);
        DirectoryPackagingElement root = this.createDirectory(rootName);
        CompositePackagingElement<?> last = this.getOrCreateDirectory(root, pathTail);
        last.addOrFindChildren(elements);
        List<DirectoryPackagingElement> list = Collections.singletonList(root);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createParentDirectories"));
        }
        return list;
    }

    public static CompositePackagingElement<?> createDirectoryOrArchiveWithParents(@NotNull String path, boolean archive) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl", "createDirectoryOrArchiveWithParents"));
        }
        path = FileUtil.toSystemIndependentName((String)path);
        String parentPath = PathUtil.getParentPath((String)path);
        String fileName = PathUtil.getFileName((String)path);
        CompositeElementWithManifest element = archive ? new ArchivePackagingElement(fileName) : new DirectoryPackagingElement(fileName);
        return (CompositePackagingElement)PackagingElementFactoryImpl.getInstance().createParentDirectories(parentPath, (PackagingElement)element);
    }

    private static class ArtifactRootElementType
    extends PackagingElementType<ArtifactRootElement<?>> {
        protected ArtifactRootElementType() {
            super("root", "");
        }

        public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType", "canCreate"));
            }
            if (artifact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType", "canCreate"));
            }
            return false;
        }

        @NotNull
        public List<? extends ArtifactRootElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType", "chooseAndCreate"));
            }
            if (artifact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType", "chooseAndCreate"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType", "chooseAndCreate"));
            }
            throw new UnsupportedOperationException("'create' not implemented in " + ((Object)((Object)this)).getClass().getName());
        }

        @NotNull
        public ArtifactRootElement<?> createEmpty(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType", "createEmpty"));
            }
            ArtifactRootElementImpl artifactRootElementImpl = new ArtifactRootElementImpl();
            if (artifactRootElementImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType", "createEmpty"));
            }
            return artifactRootElementImpl;
        }
    }
}

