/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import org.jdesktop.swingx.renderer.DefaultTreeRenderer;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionsConfigTreeRenderer
extends DefaultTreeRenderer {
    protected abstract String getFilter();

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String text;
        SimpleColoredComponent component = new SimpleColoredComponent();
        if (!(value instanceof InspectionConfigTreeNode)) {
            return component;
        }
        InspectionConfigTreeNode node = (InspectionConfigTreeNode)value;
        Object object = node.getUserObject();
        boolean reallyHasFocus = ((TreeTableTree)tree).getTreeTable().hasFocus();
        Color background = selected ? (reallyHasFocus ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeUnfocusedSelectionBackground()) : UIUtil.getTreeTextBackground();
        UIUtil.changeBackGround((Component)component, (Color)background);
        Color foreground = selected ? UIUtil.getTreeSelectionForeground() : (node.isProperSetting() ? PlatformColors.BLUE : UIUtil.getTreeTextForeground());
        int style = 0;
        String hint = null;
        if (object instanceof String) {
            text = (String)object;
            style = 1;
        } else {
            ToolDescriptors descriptors = node.getDescriptors();
            assert (descriptors != null);
            Descriptor defaultDescriptor = descriptors.getDefaultDescriptor();
            text = defaultDescriptor.getText();
            hint = InspectionsConfigTreeRenderer.getHint(defaultDescriptor);
        }
        if (text != null) {
            SearchUtil.appendFragments(this.getFilter(), text, style, foreground, background, component);
        }
        if (hint != null) {
            component.append(" " + hint, selected ? new SimpleTextAttributes(0, foreground) : SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        component.setForeground(foreground);
        return component;
    }

    @Nullable
    private static String getHint(Descriptor descriptor) {
        InspectionToolWrapper toolWrapper = descriptor.getToolWrapper();
        if (toolWrapper instanceof LocalInspectionToolWrapper || toolWrapper instanceof GlobalInspectionToolWrapper && !((GlobalInspectionToolWrapper)toolWrapper).worksInBatchModeOnly()) {
            return null;
        }
        return InspectionsBundle.message((String)"inspection.tool.availability.in.tree.node1", (Object[])new Object[0]);
    }
}

