/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.AnalysisCanceledSoftException;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowImpl;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowStack;
import com.intellij.psi.controlFlow.ControlFlowSubRange;
import com.intellij.psi.controlFlow.EmptyInstruction;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import com.intellij.psi.controlFlow.ThrowToInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ControlFlowAnalyzer
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.controlFlow.ControlFlowAnalyzer");
    private final PsiElement myCodeFragment;
    private final ControlFlowPolicy myPolicy;
    private ControlFlowImpl myCurrentFlow;
    private final ControlFlowStack myStack;
    private final Stack<PsiParameter> myCatchParameters;
    private final Stack<PsiElement> myCatchBlocks;
    private final Stack<PsiElement> myFinallyBlocks;
    private final Stack<PsiElement> myUnhandledExceptionCatchBlocks;
    private final StatementStack myStartStatementStack;
    private final StatementStack myEndStatementStack;
    private final Stack<BranchingInstruction.Role> myStartJumpRoles;
    private final Stack<BranchingInstruction.Role> myEndJumpRoles;
    private final boolean myEnabledShortCircuit;
    private final boolean myEvaluateConstantIfCondition;
    private final boolean myAssignmentTargetsAreElements;
    private final Stack<TIntArrayList> intArrayPool;
    private final Map<PsiElement, TIntArrayList> offsetsAddElementStart;
    private final Map<PsiElement, TIntArrayList> offsetsAddElementEnd;
    private final ControlFlowFactory myControlFlowFactory;
    private final Map<PsiElement, ControlFlowSubRange> mySubRanges;
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final Map<PsiElement, List<PsiElement>> finallyBlockToUnhandledExceptions;

    ControlFlowAnalyzer(@NotNull PsiElement codeFragment, @NotNull ControlFlowPolicy policy, boolean enabledShortCircuit, boolean evaluateConstantIfCondition) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "<init>"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "<init>"));
        }
        this(codeFragment, policy, enabledShortCircuit, evaluateConstantIfCondition, false);
    }

    private ControlFlowAnalyzer(@NotNull PsiElement codeFragment, @NotNull ControlFlowPolicy policy, boolean enabledShortCircuit, boolean evaluateConstantIfCondition, boolean assignmentTargetsAreElements) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "<init>"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "<init>"));
        }
        this.myStack = new ControlFlowStack();
        this.myCatchParameters = new Stack();
        this.myCatchBlocks = new Stack();
        this.myFinallyBlocks = new Stack();
        this.myUnhandledExceptionCatchBlocks = new Stack();
        this.myStartStatementStack = new StatementStack();
        this.myEndStatementStack = new StatementStack();
        this.myStartJumpRoles = new Stack();
        this.myEndJumpRoles = new Stack();
        this.intArrayPool = new Stack();
        this.offsetsAddElementStart = new THashMap();
        this.offsetsAddElementEnd = new THashMap();
        this.mySubRanges = new THashMap();
        this.finallyBlockToUnhandledExceptions = new HashMap<PsiElement, List<PsiElement>>();
        this.myCodeFragment = codeFragment;
        this.myPolicy = policy;
        this.myEnabledShortCircuit = enabledShortCircuit;
        this.myEvaluateConstantIfCondition = evaluateConstantIfCondition;
        this.myAssignmentTargetsAreElements = assignmentTargetsAreElements;
        Project project2 = codeFragment.getProject();
        this.myControlFlowFactory = ControlFlowFactory.getInstance(project2);
        this.myConstantEvaluationHelper = JavaPsiFacade.getInstance((Project)project2).getConstantEvaluationHelper();
    }

    @NotNull
    ControlFlow buildControlFlow() throws AnalysisCanceledException {
        this.myStartJumpRoles.push((Object)BranchingInstruction.Role.END);
        this.myEndJumpRoles.push((Object)BranchingInstruction.Role.END);
        this.myCurrentFlow = new ControlFlowImpl();
        this.myStartStatementStack.pushStatement(this.myCodeFragment, false);
        this.myEndStatementStack.pushStatement(this.myCodeFragment, false);
        try {
            this.myCodeFragment.accept((PsiElementVisitor)this);
            this.cleanup();
        }
        catch (AnalysisCanceledSoftException e) {
            throw new AnalysisCanceledException(e.getErrorElement());
        }
        ControlFlowImpl controlFlowImpl = this.myCurrentFlow;
        if (controlFlowImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "buildControlFlow"));
        }
        return controlFlowImpl;
    }

    @NotNull
    private TIntArrayList getEmptyIntArray() {
        if (this.intArrayPool.isEmpty()) {
            TIntArrayList tIntArrayList = new TIntArrayList(1);
            if (tIntArrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "getEmptyIntArray"));
            }
            return tIntArrayList;
        }
        TIntArrayList list = (TIntArrayList)this.intArrayPool.pop();
        list.clear();
        TIntArrayList tIntArrayList = list;
        if (tIntArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "getEmptyIntArray"));
        }
        return tIntArrayList;
    }

    private void poolIntArray(@NotNull TIntArrayList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "poolIntArray"));
        }
        this.intArrayPool.add((Object)list);
    }

    private void addElementOffsetLater(@NotNull PsiElement element, boolean atStart) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "addElementOffsetLater"));
        }
        Map<PsiElement, TIntArrayList> offsetsAddElement = atStart ? this.offsetsAddElementStart : this.offsetsAddElementEnd;
        TIntArrayList offsets = offsetsAddElement.get(element);
        if (offsets == null) {
            offsets = this.getEmptyIntArray();
            offsetsAddElement.put(element, offsets);
        }
        int offset = this.myCurrentFlow.getSize() - 1;
        offsets.add(offset);
        if (this.myCurrentFlow.getEndOffset(element) != -1) {
            this.patchInstructionOffsets(element);
        }
    }

    private void patchInstructionOffsets(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "patchInstructionOffsets"));
        }
        this.patchInstructionOffsets(this.offsetsAddElementStart.get(element), this.myCurrentFlow.getStartOffset(element));
        this.offsetsAddElementStart.put(element, null);
        this.patchInstructionOffsets(this.offsetsAddElementEnd.get(element), this.myCurrentFlow.getEndOffset(element));
        this.offsetsAddElementEnd.put(element, null);
    }

    private void patchInstructionOffsets(@Nullable TIntArrayList offsets, int add) {
        if (offsets == null) {
            return;
        }
        for (int i = 0; i < offsets.size(); ++i) {
            int offset = offsets.get(i);
            BranchingInstruction instruction = (BranchingInstruction)this.myCurrentFlow.getInstructions().get(offset);
            instruction.offset += add;
            LOG.assertTrue(instruction.offset >= 0);
        }
        this.poolIntArray(offsets);
    }

    private void cleanup() {
        for (TIntArrayList tIntArrayList : this.offsetsAddElementStart.values()) {
            this.patchInstructionOffsets(tIntArrayList, this.myCurrentFlow.getEndOffset(this.myCodeFragment));
        }
        for (TIntArrayList tIntArrayList : this.offsetsAddElementEnd.values()) {
            this.patchInstructionOffsets(tIntArrayList, this.myCurrentFlow.getEndOffset(this.myCodeFragment));
        }
        for (Map.Entry entry : this.mySubRanges.entrySet()) {
            ProgressManager.checkCanceled();
            ControlFlowSubRange subRange = (ControlFlowSubRange)entry.getValue();
            PsiElement element = (PsiElement)entry.getKey();
            this.myControlFlowFactory.registerSubRange(element, subRange, this.myEvaluateConstantIfCondition, this.myEnabledShortCircuit, this.myPolicy);
        }
    }

    private void startElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "startElement"));
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            ProgressManager.checkCanceled();
            if (!(child instanceof PsiErrorElement) || Comparing.strEqual((String)((PsiErrorElement)child).getErrorDescription(), (String)JavaErrorMessages.message("expected.semicolon", new Object[0]))) continue;
            throw new AnalysisCanceledSoftException(element);
        }
        ProgressManager.checkCanceled();
        this.myCurrentFlow.startElement(element);
        this.generateUncheckedExceptionJumpsIfNeeded(element, true);
    }

    private void generateUncheckedExceptionJumpsIfNeeded(@NotNull PsiElement element, boolean atStart) {
        boolean isGeneratingCodeBlock;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateUncheckedExceptionJumpsIfNeeded"));
        }
        boolean isGeneratingStatement = element instanceof PsiStatement && !(element instanceof PsiSwitchLabelStatement);
        boolean bl = isGeneratingCodeBlock = element instanceof PsiCodeBlock && !(element.getParent() instanceof PsiSwitchStatement);
        if (isGeneratingStatement || isGeneratingCodeBlock) {
            this.generateUncheckedExceptionJumps(element, atStart);
        }
    }

    private void finishElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "finishElement"));
        }
        this.generateUncheckedExceptionJumpsIfNeeded(element, false);
        this.myCurrentFlow.finishElement(element);
        this.patchInstructionOffsets(element);
    }

    private void generateUncheckedExceptionJumps(@NotNull PsiElement element, boolean atStart) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateUncheckedExceptionJumps"));
        }
        if (atStart && element instanceof PsiStatement && element.getParent() instanceof PsiCodeBlock && element.getPrevSibling() != null) {
            return;
        }
        for (int i = this.myUnhandledExceptionCatchBlocks.size() - 1; i >= 0; --i) {
            ProgressManager.checkCanceled();
            PsiElement block = (PsiElement)this.myUnhandledExceptionCatchBlocks.get(i);
            if (block == null) {
                if (this.myFinallyBlocks.isEmpty()) continue;
                break;
            }
            ConditionalThrowToInstruction throwToInstruction = new ConditionalThrowToInstruction(-1);
            this.myCurrentFlow.addInstruction(throwToInstruction);
            if (this.patchUncheckedThrowInstructionIfInsideFinally(throwToInstruction, element, block)) continue;
            this.addElementOffsetLater(block, true);
        }
        if (!this.myFinallyBlocks.isEmpty()) {
            PsiElement finallyBlock = (PsiElement)this.myFinallyBlocks.peek();
            ConditionalThrowToInstruction throwToInstruction = new ConditionalThrowToInstruction(-2);
            this.myCurrentFlow.addInstruction(throwToInstruction);
            if (!this.patchUncheckedThrowInstructionIfInsideFinally(throwToInstruction, element, finallyBlock)) {
                this.addElementOffsetLater(finallyBlock, true);
            }
        }
    }

    private void generateCheckedExceptionJumps(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateCheckedExceptionJumps"));
        }
        Collection<PsiClassType> unhandledExceptions = ExceptionUtil.collectUnhandledExceptions(element, element.getParent());
        for (PsiClassType unhandledException : unhandledExceptions) {
            ProgressManager.checkCanceled();
            this.generateThrow(unhandledException, element);
        }
    }

    private void generateThrow(@NotNull PsiClassType unhandledException, @NotNull PsiElement throwingElement) {
        if (unhandledException == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unhandledException", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateThrow"));
        }
        if (throwingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwingElement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateThrow"));
        }
        List<PsiElement> catchBlocks = this.findThrowToBlocks(unhandledException);
        for (PsiElement block : catchBlocks) {
            ProgressManager.checkCanceled();
            ConditionalThrowToInstruction instruction = new ConditionalThrowToInstruction(0);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.patchCheckedThrowInstructionIfInsideFinally(instruction, throwingElement, block)) continue;
            if (block == null) {
                this.addElementOffsetLater(this.myCodeFragment, false);
                continue;
            }
            --instruction.offset;
            this.addElementOffsetLater(block, true);
        }
    }

    private boolean patchCheckedThrowInstructionIfInsideFinally(@NotNull ConditionalThrowToInstruction instruction, @NotNull PsiElement throwingElement, PsiElement elementToJumpTo) {
        int index;
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "patchCheckedThrowInstructionIfInsideFinally"));
        }
        if (throwingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwingElement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "patchCheckedThrowInstructionIfInsideFinally"));
        }
        PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(throwingElement, elementToJumpTo);
        if (finallyBlock == null) {
            return false;
        }
        List<PsiElement> unhandledExceptionCatchBlocks = this.finallyBlockToUnhandledExceptions.get(finallyBlock);
        if (unhandledExceptionCatchBlocks == null) {
            unhandledExceptionCatchBlocks = new ArrayList<PsiElement>();
            this.finallyBlockToUnhandledExceptions.put(finallyBlock, unhandledExceptionCatchBlocks);
        }
        if ((index = unhandledExceptionCatchBlocks.indexOf(elementToJumpTo)) == -1) {
            index = unhandledExceptionCatchBlocks.size();
            unhandledExceptionCatchBlocks.add(elementToJumpTo);
        }
        instruction.offset = 3 + index;
        this.addElementOffsetLater(finallyBlock, false);
        return true;
    }

    private boolean patchUncheckedThrowInstructionIfInsideFinally(@NotNull ConditionalThrowToInstruction instruction, @NotNull PsiElement throwingElement, @NotNull PsiElement elementToJumpTo) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "patchUncheckedThrowInstructionIfInsideFinally"));
        }
        if (throwingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwingElement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "patchUncheckedThrowInstructionIfInsideFinally"));
        }
        if (elementToJumpTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToJumpTo", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "patchUncheckedThrowInstructionIfInsideFinally"));
        }
        PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(throwingElement, elementToJumpTo);
        if (finallyBlock == null) {
            return false;
        }
        instruction.offset = 2;
        this.addElementOffsetLater(finallyBlock, false);
        return true;
    }

    public void visitCodeFragment(JavaCodeFragment codeFragment) {
        PsiElement[] children2;
        this.startElement((PsiElement)codeFragment);
        int prevOffset = this.myCurrentFlow.getSize();
        for (PsiElement child : children2 = codeFragment.getChildren()) {
            ProgressManager.checkCanceled();
            child.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)codeFragment);
        this.registerSubRange((PsiElement)codeFragment, prevOffset);
    }

    private void registerSubRange(@NotNull PsiElement codeFragment, int startOffset) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "registerSubRange"));
        }
        ControlFlowSubRange flow = new ControlFlowSubRange(this.myCurrentFlow, startOffset, this.myCurrentFlow.getSize());
        this.mySubRanges.put(codeFragment, flow);
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        PsiStatement[] statements;
        this.startElement((PsiElement)block);
        int prevOffset = this.myCurrentFlow.getSize();
        for (PsiStatement statement2 : statements = block.getStatements()) {
            ProgressManager.checkCanceled();
            statement2.accept((PsiElementVisitor)this);
        }
        int nextOffset = this.myCurrentFlow.getSize();
        if (!(block.getParent() instanceof PsiSwitchStatement) && prevOffset == nextOffset) {
            this.emitEmptyInstruction();
        }
        this.finishElement((PsiElement)block);
        if (prevOffset != 0) {
            this.registerSubRange((PsiElement)block, prevOffset);
        }
    }

    private void emitEmptyInstruction() {
        this.myCurrentFlow.addInstruction(EmptyInstruction.INSTANCE);
    }

    public void visitFile(PsiFile file2) {
        this.visitChildren((PsiElement)file2);
    }

    public void visitBlockStatement(PsiBlockStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiCodeBlock codeBlock = statement2.getCodeBlock();
        codeBlock.accept((PsiElementVisitor)this);
        this.finishElement((PsiElement)statement2);
    }

    public void visitBreakStatement(PsiBreakStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiStatement exitedStatement = statement2.findExitedStatement();
        if (exitedStatement != null) {
            GoToInstruction instruction;
            int finallyStartOffset;
            PsiElement finallyBlock = this.findEnclosingFinallyBlockElement((PsiElement)statement2, (PsiElement)exitedStatement);
            int n = finallyStartOffset = finallyBlock == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
            if (finallyBlock != null && finallyStartOffset != -1) {
                CallInstruction callInstruction = (CallInstruction)this.myCurrentFlow.getInstructions().get(finallyStartOffset - 2);
                instruction = new ReturnInstruction(0, this.myStack, callInstruction);
            } else {
                instruction = new GoToInstruction(0);
            }
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater((PsiElement)exitedStatement, false);
        }
        this.finishElement((PsiElement)statement2);
    }

    private PsiElement findEnclosingFinallyBlockElement(@NotNull PsiElement sourceElement, @Nullable PsiElement jumpElement) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "findEnclosingFinallyBlockElement"));
        }
        for (PsiElement element = sourceElement; element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (!(element instanceof PsiCodeBlock) || !(element.getParent() instanceof PsiTryStatement) || ((PsiTryStatement)element.getParent()).getFinallyBlock() != element) continue;
            if (this.myCurrentFlow.getStartOffset(element.getParent()) == -1) {
                return null;
            }
            if (jumpElement != null && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)jumpElement, (boolean)false)) continue;
            return element;
        }
        return null;
    }

    public void visitContinueStatement(PsiContinueStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiStatement continuedStatement = statement2.findContinuedStatement();
        if (continuedStatement != null) {
            GoToInstruction instruction;
            PsiElement finallyBlock;
            int finallyStartOffset;
            PsiStatement body = null;
            if (continuedStatement instanceof PsiForStatement) {
                body = ((PsiForStatement)continuedStatement).getBody();
            } else if (continuedStatement instanceof PsiWhileStatement) {
                body = ((PsiWhileStatement)continuedStatement).getBody();
            } else if (continuedStatement instanceof PsiDoWhileStatement) {
                body = ((PsiDoWhileStatement)continuedStatement).getBody();
            } else if (continuedStatement instanceof PsiForeachStatement) {
                body = ((PsiForeachStatement)continuedStatement).getBody();
            }
            if (body == null) {
                body = this.myCodeFragment;
            }
            int n = finallyStartOffset = (finallyBlock = this.findEnclosingFinallyBlockElement((PsiElement)statement2, (PsiElement)continuedStatement)) == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
            if (finallyBlock != null && finallyStartOffset != -1) {
                CallInstruction callInstruction = (CallInstruction)this.myCurrentFlow.getInstructions().get(finallyStartOffset - 2);
                instruction = new ReturnInstruction(0, this.myStack, callInstruction);
            } else {
                instruction = new GoToInstruction(0);
            }
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater((PsiElement)body, false);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitDeclarationStatement(PsiDeclarationStatement statement2) {
        PsiElement[] elements;
        this.startElement((PsiElement)statement2);
        int pc = this.myCurrentFlow.getSize();
        for (PsiElement element : elements = statement2.getDeclaredElements()) {
            ProgressManager.checkCanceled();
            if (element instanceof PsiClass) {
                element.accept((PsiElementVisitor)this);
                continue;
            }
            if (!(element instanceof PsiVariable)) continue;
            this.processVariable((PsiVariable)element);
        }
        if (pc == this.myCurrentFlow.getSize()) {
            this.emitEmptyInstruction();
        }
        this.finishElement((PsiElement)statement2);
    }

    private void processVariable(@NotNull PsiVariable element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "processVariable"));
        }
        PsiExpression initializer = element.getInitializer();
        if (initializer != null) {
            this.myStartStatementStack.pushStatement((PsiElement)initializer, false);
            this.myEndStatementStack.pushStatement((PsiElement)initializer, false);
            initializer.accept((PsiElementVisitor)this);
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        if (element instanceof PsiLocalVariable && initializer != null || element instanceof PsiField) {
            if (element instanceof PsiLocalVariable && !this.myPolicy.isLocalVariableAccepted((PsiLocalVariable)element)) {
                return;
            }
            if (this.myAssignmentTargetsAreElements) {
                this.startElement((PsiElement)element);
            }
            this.generateWriteInstruction(element);
            if (this.myAssignmentTargetsAreElements) {
                this.finishElement((PsiElement)element);
            }
        }
    }

    public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
        PsiExpression condition;
        this.startElement((PsiElement)statement2);
        PsiStatement body = statement2.getBody();
        this.myStartStatementStack.pushStatement((PsiElement)(body == null ? statement2 : body), true);
        this.myEndStatementStack.pushStatement((PsiElement)statement2, false);
        if (body != null) {
            body.accept((PsiElementVisitor)this);
        }
        if ((condition = statement2.getCondition()) != null) {
            condition.accept((PsiElementVisitor)this);
        }
        int offset = this.myCurrentFlow.getStartOffset((PsiElement)statement2);
        Object loopCondition = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)statement2.getCondition());
        if (loopCondition instanceof Boolean) {
            if (((Boolean)loopCondition).booleanValue()) {
                this.myCurrentFlow.addInstruction(new GoToInstruction(offset));
            } else {
                this.emitEmptyInstruction();
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(offset, statement2.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
        }
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)statement2);
    }

    public void visitEmptyStatement(PsiEmptyStatement statement2) {
        this.startElement((PsiElement)statement2);
        this.emitEmptyInstruction();
        this.finishElement((PsiElement)statement2);
    }

    public void visitExpressionStatement(PsiExpressionStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiExpression expression = statement2.getExpression();
        expression.accept((PsiElementVisitor)this);
        for (PsiParameter catchParameter : this.myCatchParameters) {
            ProgressManager.checkCanceled();
            PsiType type = catchParameter.getType();
            if (!(type instanceof PsiClassType)) continue;
            this.generateThrow((PsiClassType)type, (PsiElement)statement2);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitExpressionListStatement(PsiExpressionListStatement statement2) {
        PsiExpression[] expressions;
        this.startElement((PsiElement)statement2);
        for (PsiExpression expr : expressions = statement2.getExpressionList().getExpressions()) {
            ProgressManager.checkCanceled();
            expr.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitField(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            this.startElement((PsiElement)field);
            initializer.accept((PsiElementVisitor)this);
            this.finishElement((PsiElement)field);
        }
    }

    public void visitForStatement(PsiForStatement statement2) {
        PsiStatement update;
        Object loopCondition;
        PsiExpression condition;
        this.startElement((PsiElement)statement2);
        PsiStatement body = statement2.getBody();
        this.myStartStatementStack.pushStatement((PsiElement)(body == null ? statement2 : body), false);
        this.myEndStatementStack.pushStatement((PsiElement)statement2, false);
        PsiStatement initialization = statement2.getInitialization();
        if (initialization != null) {
            initialization.accept((PsiElementVisitor)this);
        }
        if ((condition = statement2.getCondition()) != null) {
            condition.accept((PsiElementVisitor)this);
        }
        if ((loopCondition = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)condition)) instanceof Boolean || condition == null) {
            boolean value;
            boolean bl = value = condition == null || (Boolean)loopCondition != false;
            if (value) {
                this.emitEmptyInstruction();
            } else {
                this.myCurrentFlow.addInstruction(new GoToInstruction(0));
                this.addElementOffsetLater((PsiElement)statement2, false);
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement2.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater((PsiElement)statement2, false);
        }
        if (body != null) {
            body.accept((PsiElementVisitor)this);
        }
        if ((update = statement2.getUpdate()) != null) {
            update.accept((PsiElementVisitor)this);
        }
        int offset = initialization != null ? this.myCurrentFlow.getEndOffset((PsiElement)initialization) : this.myCurrentFlow.getStartOffset((PsiElement)statement2);
        GoToInstruction instruction = new GoToInstruction(offset);
        this.myCurrentFlow.addInstruction(instruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)statement2);
    }

    public void visitForeachStatement(PsiForeachStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiStatement body = statement2.getBody();
        this.myStartStatementStack.pushStatement((PsiElement)(body == null ? statement2 : body), false);
        this.myEndStatementStack.pushStatement((PsiElement)statement2, false);
        PsiExpression iteratedValue = statement2.getIteratedValue();
        if (iteratedValue != null) {
            iteratedValue.accept((PsiElementVisitor)this);
        }
        int gotoTarget = this.myCurrentFlow.getSize();
        ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement2.getIteratedValue());
        this.myCurrentFlow.addInstruction(instruction);
        this.addElementOffsetLater((PsiElement)statement2, false);
        PsiParameter iterationParameter = statement2.getIterationParameter();
        if (this.myPolicy.isParameterAccepted(iterationParameter)) {
            this.generateWriteInstruction((PsiVariable)iterationParameter);
        }
        if (body != null) {
            body.accept((PsiElementVisitor)this);
        }
        GoToInstruction gotoInstruction = new GoToInstruction(gotoTarget);
        this.myCurrentFlow.addInstruction(gotoInstruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)statement2);
    }

    public void visitIfStatement(PsiIfStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiStatement elseBranch = statement2.getElseBranch();
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpression conditionExpression = statement2.getCondition();
        this.generateConditionalStatementInstructions((PsiElement)statement2, conditionExpression, (PsiElement)thenBranch, (PsiElement)elseBranch);
        this.finishElement((PsiElement)statement2);
    }

    private void generateConditionalStatementInstructions(@NotNull PsiElement statement2, @Nullable PsiExpression conditionExpression, PsiElement thenBranch, PsiElement elseBranch) {
        Object value;
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateConditionalStatementInstructions"));
        }
        if (thenBranch == null) {
            this.myStartStatementStack.pushStatement(statement2, false);
        } else {
            this.myStartStatementStack.pushStatement(thenBranch, true);
        }
        if (elseBranch == null) {
            this.myEndStatementStack.pushStatement(statement2, false);
        } else {
            this.myEndStatementStack.pushStatement(elseBranch, true);
        }
        this.myEndJumpRoles.push((Object)(elseBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.ELSE));
        this.myStartJumpRoles.push((Object)(thenBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.THEN));
        if (conditionExpression != null) {
            conditionExpression.accept((PsiElementVisitor)this);
        }
        boolean generateElseFlow = true;
        boolean generateThenFlow = true;
        boolean generateConditionalJump = true;
        if (this.myEvaluateConstantIfCondition && (value = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)conditionExpression)) instanceof Boolean) {
            boolean condition;
            generateThenFlow = condition = ((Boolean)value).booleanValue();
            generateElseFlow = !condition;
            generateConditionalJump = false;
            this.myCurrentFlow.setConstantConditionOccurred(true);
        }
        if (generateConditionalJump) {
            BranchingInstruction.Role role = elseBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.ELSE;
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, role, conditionExpression);
            this.myCurrentFlow.addInstruction(instruction);
            if (elseBranch == null) {
                this.addElementOffsetLater(statement2, false);
            } else {
                this.addElementOffsetLater(elseBranch, true);
            }
        }
        if (thenBranch != null && generateThenFlow) {
            thenBranch.accept((PsiElementVisitor)this);
        }
        if (elseBranch != null && generateElseFlow) {
            if (generateThenFlow) {
                GoToInstruction instruction = new GoToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater(statement2, false);
            }
            elseBranch.accept((PsiElementVisitor)this);
        }
        this.myStartJumpRoles.pop();
        this.myEndJumpRoles.pop();
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
    }

    public void visitLabeledStatement(PsiLabeledStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiStatement innerStatement = statement2.getStatement();
        if (innerStatement != null) {
            innerStatement.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitReturnStatement(PsiReturnStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiExpression returnValue = statement2.getReturnValue();
        if (returnValue != null) {
            this.myStartStatementStack.pushStatement((PsiElement)returnValue, false);
            this.myEndStatementStack.pushStatement((PsiElement)returnValue, false);
            returnValue.accept((PsiElementVisitor)this);
        }
        this.addReturnInstruction((PsiElement)statement2);
        if (returnValue != null) {
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        this.finishElement((PsiElement)statement2);
    }

    private void addReturnInstruction(@NotNull PsiElement statement2) {
        int finallyStartOffset;
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "addReturnInstruction"));
        }
        PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(statement2, null);
        int n = finallyStartOffset = finallyBlock == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
        if (finallyBlock != null && finallyStartOffset != -1) {
            GoToInstruction instruction = new GoToInstruction(1, BranchingInstruction.Role.END, true);
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(finallyBlock, false);
        } else {
            GoToInstruction instruction = new GoToInstruction(0, BranchingInstruction.Role.END, true);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.myFinallyBlocks.isEmpty()) {
                this.addElementOffsetLater(this.myCodeFragment, false);
            } else {
                instruction.offset = -4;
                this.addElementOffsetLater((PsiElement)this.myFinallyBlocks.peek(), true);
            }
        }
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiExpression caseValue = statement2.getCaseValue();
        if (caseValue != null) {
            this.myStartStatementStack.pushStatement((PsiElement)caseValue, false);
            this.myEndStatementStack.pushStatement((PsiElement)caseValue, false);
            caseValue.accept((PsiElementVisitor)this);
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitSwitchStatement(PsiSwitchStatement statement2) {
        PsiCodeBlock body;
        this.startElement((PsiElement)statement2);
        PsiExpression expr = statement2.getExpression();
        if (expr != null) {
            expr.accept((PsiElementVisitor)this);
        }
        if ((body = statement2.getBody()) != null) {
            PsiStatement[] statements = body.getStatements();
            PsiSwitchLabelStatement defaultLabel = null;
            for (PsiStatement aStatement : statements) {
                ProgressManager.checkCanceled();
                if (!(aStatement instanceof PsiSwitchLabelStatement)) continue;
                if (((PsiSwitchLabelStatement)aStatement).isDefaultCase()) {
                    defaultLabel = (PsiSwitchLabelStatement)aStatement;
                }
                ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement2.getExpression());
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater((PsiElement)aStatement, true);
            }
            if (defaultLabel == null) {
                GoToInstruction instruction = new GoToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater((PsiElement)body, false);
            }
            body.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitSynchronizedStatement(PsiSynchronizedStatement statement2) {
        PsiCodeBlock body;
        this.startElement((PsiElement)statement2);
        PsiExpression lock = statement2.getLockExpression();
        if (lock != null) {
            lock.accept((PsiElementVisitor)this);
        }
        if ((body = statement2.getBody()) != null) {
            body.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitThrowStatement(PsiThrowStatement statement2) {
        List<PsiElement> blocks;
        this.startElement((PsiElement)statement2);
        PsiExpression exception = statement2.getException();
        if (exception != null) {
            exception.accept((PsiElementVisitor)this);
        }
        if ((blocks = this.findThrowToBlocks(statement2)).isEmpty() || blocks.get(0) == null) {
            ThrowToInstruction instruction = new ThrowToInstruction(0);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.myFinallyBlocks.isEmpty()) {
                PsiElement element = this.myCodeFragment;
                this.addElementOffsetLater(element, false);
            } else {
                instruction.offset = -2;
                PsiElement element = (PsiElement)this.myFinallyBlocks.peek();
                this.addElementOffsetLater(element, true);
            }
        } else {
            for (int i = 0; i < blocks.size(); ++i) {
                ProgressManager.checkCanceled();
                PsiElement element = blocks.get(i);
                BranchingInstruction instruction = i == blocks.size() - 1 ? new ThrowToInstruction(0) : new ConditionalThrowToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                instruction.offset = -1;
                this.addElementOffsetLater(element, true);
            }
        }
        this.finishElement((PsiElement)statement2);
    }

    @NotNull
    private List<PsiElement> findThrowToBlocks(@NotNull PsiThrowStatement statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "findThrowToBlocks"));
        }
        PsiExpression exceptionExpr = statement2.getException();
        if (exceptionExpr == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "findThrowToBlocks"));
            }
            return list;
        }
        PsiType throwType = exceptionExpr.getType();
        if (!(throwType instanceof PsiClassType)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "findThrowToBlocks"));
            }
            return list;
        }
        List<PsiElement> list = this.findThrowToBlocks((PsiClassType)throwType);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "findThrowToBlocks"));
        }
        return list;
    }

    @NotNull
    private List<PsiElement> findThrowToBlocks(@NotNull PsiClassType throwType) {
        if (throwType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwType", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "findThrowToBlocks"));
        }
        ArrayList<PsiElement> blocks = new ArrayList<PsiElement>();
        for (int i = this.myCatchParameters.size() - 1; i >= 0; --i) {
            ProgressManager.checkCanceled();
            PsiParameter parameter = (PsiParameter)this.myCatchParameters.get(i);
            PsiType catchType = parameter.getType();
            if (!catchType.isAssignableFrom((PsiType)throwType) && !throwType.isAssignableFrom(catchType)) continue;
            blocks.add((PsiElement)this.myCatchBlocks.get(i));
        }
        if (blocks.isEmpty()) {
            blocks.add(null);
        }
        ArrayList<PsiElement> arrayList = blocks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "findThrowToBlocks"));
        }
        return arrayList;
    }

    public void visitAssertStatement(PsiAssertStatement statement2) {
        PsiExpression description;
        this.startElement((PsiElement)statement2);
        PsiExpression condition = statement2.getAssertCondition();
        if (condition != null) {
            this.myStartStatementStack.pushStatement((PsiElement)statement2, false);
            this.myEndStatementStack.pushStatement((PsiElement)statement2, false);
            this.myEndJumpRoles.push((Object)BranchingInstruction.Role.END);
            this.myStartJumpRoles.push((Object)BranchingInstruction.Role.END);
            condition.accept((PsiElementVisitor)this);
            this.myStartJumpRoles.pop();
            this.myEndJumpRoles.pop();
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        if ((description = statement2.getAssertDescription()) != null) {
            description.accept((PsiElementVisitor)this);
        }
        ConditionalThrowToInstruction instruction = new ConditionalThrowToInstruction(0, statement2.getAssertCondition());
        this.myCurrentFlow.addInstruction(instruction);
        this.addElementOffsetLater(this.myCodeFragment, false);
        this.finishElement((PsiElement)statement2);
    }

    public void visitTryStatement(PsiTryStatement statement2) {
        int i;
        PsiCodeBlock tryBlock;
        PsiResourceList resourceList;
        this.startElement((PsiElement)statement2);
        PsiCodeBlock[] catchBlocks = statement2.getCatchBlocks();
        PsiParameter[] catchBlockParameters = statement2.getCatchBlockParameters();
        int catchNum = Math.min(catchBlocks.length, catchBlockParameters.length);
        this.myUnhandledExceptionCatchBlocks.push(null);
        block0: for (int i2 = catchNum - 1; i2 >= 0; --i2) {
            ProgressManager.checkCanceled();
            this.myCatchParameters.push((Object)catchBlockParameters[i2]);
            this.myCatchBlocks.push((Object)catchBlocks[i2]);
            PsiType type = catchBlockParameters[i2].getType();
            if (type instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)type)) {
                this.myUnhandledExceptionCatchBlocks.push((Object)catchBlocks[i2]);
                continue;
            }
            if (!(type instanceof PsiDisjunctionType)) continue;
            PsiType lub = ((PsiDisjunctionType)type).getLeastUpperBound();
            if (lub instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)lub)) {
                this.myUnhandledExceptionCatchBlocks.push((Object)catchBlocks[i2]);
                continue;
            }
            if (!(lub instanceof PsiIntersectionType)) continue;
            for (PsiType conjunct : ((PsiIntersectionType)lub).getConjuncts()) {
                if (!(conjunct instanceof PsiClassType) || !ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)conjunct)) continue;
                this.myUnhandledExceptionCatchBlocks.push((Object)catchBlocks[i2]);
                continue block0;
            }
        }
        PsiCodeBlock finallyBlock = statement2.getFinallyBlock();
        if (finallyBlock != null) {
            this.myFinallyBlocks.push((Object)finallyBlock);
        }
        if ((resourceList = statement2.getResourceList()) != null) {
            this.generateCheckedExceptionJumps((PsiElement)resourceList);
            resourceList.accept((PsiElementVisitor)this);
        }
        if ((tryBlock = statement2.getTryBlock()) != null) {
            this.generateCheckedExceptionJumps((PsiElement)tryBlock);
            tryBlock.accept((PsiElementVisitor)this);
        }
        while (this.myUnhandledExceptionCatchBlocks.pop() != null) {
        }
        this.myCurrentFlow.addInstruction(new GoToInstruction(finallyBlock == null ? 0 : -6));
        if (finallyBlock == null) {
            this.addElementOffsetLater((PsiElement)statement2, false);
        } else {
            this.addElementOffsetLater((PsiElement)finallyBlock, true);
        }
        for (i = 0; i < catchNum; ++i) {
            this.myCatchParameters.pop();
            this.myCatchBlocks.pop();
        }
        for (i = catchNum - 1; i >= 0; --i) {
            ProgressManager.checkCanceled();
            if (this.myPolicy.isParameterAccepted(catchBlockParameters[i])) {
                this.generateWriteInstruction((PsiVariable)catchBlockParameters[i]);
            }
            PsiCodeBlock catchBlock = catchBlocks[i];
            assert (catchBlock != null) : i + statement2.getText();
            catchBlock.accept((PsiElementVisitor)this);
            this.myCurrentFlow.addInstruction(new GoToInstruction(finallyBlock == null ? 0 : -6));
            if (finallyBlock == null) {
                this.addElementOffsetLater((PsiElement)statement2, false);
                continue;
            }
            this.addElementOffsetLater((PsiElement)finallyBlock, true);
        }
        if (finallyBlock != null) {
            this.myFinallyBlocks.pop();
        }
        if (finallyBlock != null) {
            this.myCurrentFlow.addInstruction(new CallInstruction(0, 0, this.myStack));
            this.addElementOffsetLater((PsiElement)finallyBlock, true);
            this.myCurrentFlow.addInstruction(new GoToInstruction(0));
            this.addElementOffsetLater((PsiElement)statement2, false);
            this.myCurrentFlow.addInstruction(new CallInstruction(0, 0, this.myStack));
            this.addElementOffsetLater((PsiElement)finallyBlock, true);
            this.addReturnInstruction((PsiElement)statement2);
            this.myCurrentFlow.addInstruction(new CallInstruction(0, 0, this.myStack));
            this.addElementOffsetLater((PsiElement)finallyBlock, true);
            GoToInstruction gotoUncheckedRethrow = new GoToInstruction(0);
            this.myCurrentFlow.addInstruction(gotoUncheckedRethrow);
            this.addElementOffsetLater((PsiElement)finallyBlock, false);
            finallyBlock.accept((PsiElementVisitor)this);
            int procStart = this.myCurrentFlow.getStartOffset((PsiElement)finallyBlock);
            int procEnd = this.myCurrentFlow.getEndOffset((PsiElement)finallyBlock);
            int offset = procStart - 6;
            List<Instruction> instructions = this.myCurrentFlow.getInstructions();
            CallInstruction callInstruction = (CallInstruction)instructions.get(offset);
            callInstruction.procBegin = procStart;
            callInstruction.procEnd = procEnd;
            callInstruction = (CallInstruction)instructions.get(offset += 2);
            callInstruction.procBegin = procStart;
            callInstruction.procEnd = procEnd;
            callInstruction = (CallInstruction)instructions.get(offset += 2);
            callInstruction.procBegin = procStart;
            callInstruction.procEnd = procEnd;
            this.myCurrentFlow.addInstruction(new ReturnInstruction(0, this.myStack, callInstruction));
            this.myCurrentFlow.addInstruction(new ReturnInstruction(procStart - 3, this.myStack, callInstruction));
            this.myCurrentFlow.addInstruction(new ReturnInstruction(procStart - 1, this.myStack, callInstruction));
            List<PsiElement> unhandledExceptionCatchBlocks = this.finallyBlockToUnhandledExceptions.remove(finallyBlock);
            for (int i3 = 0; unhandledExceptionCatchBlocks != null && i3 < unhandledExceptionCatchBlocks.size(); ++i3) {
                ProgressManager.checkCanceled();
                PsiElement catchBlock = unhandledExceptionCatchBlocks.get(i3);
                ReturnInstruction returnInstruction = new ReturnInstruction(0, this.myStack, callInstruction);
                returnInstruction.setRethrowFromFinally();
                this.myCurrentFlow.addInstruction(returnInstruction);
                if (catchBlock == null) {
                    returnInstruction.offset = procStart - 1;
                    continue;
                }
                --returnInstruction.offset;
                this.addElementOffsetLater(catchBlock, true);
            }
            gotoUncheckedRethrow.offset = this.myCurrentFlow.getSize();
            this.generateUncheckedExceptionJumps((PsiElement)statement2, false);
            this.myCurrentFlow.addInstruction(new ThrowToInstruction(0));
            this.addElementOffsetLater(this.myCodeFragment, false);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitResourceList(PsiResourceList resourceList) {
        this.startElement((PsiElement)resourceList);
        for (PsiResourceListElement resource : resourceList) {
            ProgressManager.checkCanceled();
            if (resource instanceof PsiResourceVariable) {
                this.processVariable((PsiVariable)resource);
                continue;
            }
            if (!(resource instanceof PsiResourceExpression)) continue;
            ((PsiResourceExpression)resource).getExpression().accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)resourceList);
    }

    public void visitWhileStatement(PsiWhileStatement statement2) {
        Object loopCondition;
        this.startElement((PsiElement)statement2);
        PsiStatement body = statement2.getBody();
        if (body == null) {
            this.myStartStatementStack.pushStatement((PsiElement)statement2, false);
        } else {
            this.myStartStatementStack.pushStatement((PsiElement)body, true);
        }
        this.myEndStatementStack.pushStatement((PsiElement)statement2, false);
        PsiExpression condition = statement2.getCondition();
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
        }
        if ((loopCondition = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)statement2.getCondition())) instanceof Boolean) {
            boolean value = (Boolean)loopCondition;
            if (value) {
                this.emitEmptyInstruction();
            } else {
                this.myCurrentFlow.addInstruction(new GoToInstruction(0));
                this.addElementOffsetLater((PsiElement)statement2, false);
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement2.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater((PsiElement)statement2, false);
        }
        if (body != null) {
            body.accept((PsiElementVisitor)this);
        }
        int offset = this.myCurrentFlow.getStartOffset((PsiElement)statement2);
        GoToInstruction instruction = new GoToInstruction(offset);
        this.myCurrentFlow.addInstruction(instruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)statement2);
    }

    public void visitExpressionList(PsiExpressionList list) {
        PsiExpression[] expressions;
        for (PsiExpression expression : expressions = list.getExpressions()) {
            ProgressManager.checkCanceled();
            this.myStartStatementStack.pushStatement((PsiElement)expression, false);
            this.myEndStatementStack.pushStatement((PsiElement)expression, false);
            expression.accept((PsiElementVisitor)this);
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
        this.startElement((PsiElement)expression);
        expression.getArrayExpression().accept((PsiElementVisitor)this);
        PsiExpression indexExpression = expression.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        PsiExpression[] initializers;
        this.startElement((PsiElement)expression);
        for (PsiExpression initializer : initializers = expression.getInitializers()) {
            ProgressManager.checkCanceled();
            initializer.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitAssignmentExpression(PsiAssignmentExpression expression) {
        this.startElement((PsiElement)expression);
        PsiExpression rExpr = expression.getRExpression();
        this.myStartStatementStack.pushStatement((PsiElement)(rExpr == null ? expression : rExpr), false);
        this.myEndStatementStack.pushStatement((PsiElement)(rExpr == null ? expression : rExpr), false);
        PsiExpression lExpr = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getLExpression());
        if (lExpr instanceof PsiReferenceExpression) {
            PsiVariable variable;
            if (rExpr != null) {
                rExpr.accept((PsiElementVisitor)this);
            }
            if ((variable = this.getUsedVariable((PsiReferenceExpression)lExpr)) != null) {
                PsiExpression qualifier;
                if (this.myAssignmentTargetsAreElements) {
                    this.startElement((PsiElement)lExpr);
                }
                if ((qualifier = ((PsiReferenceExpression)lExpr).getQualifierExpression()) != null) {
                    qualifier.accept((PsiElementVisitor)this);
                }
                if (expression.getOperationTokenType() != JavaTokenType.EQ) {
                    this.generateReadInstruction(variable);
                }
                this.generateWriteInstruction(variable);
                if (this.myAssignmentTargetsAreElements) {
                    this.finishElement((PsiElement)lExpr);
                }
            } else {
                lExpr.accept((PsiElementVisitor)this);
            }
        } else if (lExpr instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)lExpr).getArrayExpression() instanceof PsiReferenceExpression) {
            PsiVariable variable = this.getUsedVariable((PsiReferenceExpression)((PsiArrayAccessExpression)lExpr).getArrayExpression());
            if (variable != null) {
                this.generateReadInstruction(variable);
                PsiExpression indexExpression = ((PsiArrayAccessExpression)lExpr).getIndexExpression();
                if (indexExpression != null) {
                    indexExpression.accept((PsiElementVisitor)this);
                }
            } else {
                lExpr.accept((PsiElementVisitor)this);
            }
            if (rExpr != null) {
                rExpr.accept((PsiElementVisitor)this);
            }
        } else if (lExpr != null) {
            lExpr.accept((PsiElementVisitor)this);
            if (rExpr != null) {
                rExpr.accept((PsiElementVisitor)this);
            }
        }
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)expression);
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        this.startElement((PsiElement)expression);
        IElementType signTokenType = expression.getOperationTokenType();
        boolean isAndAnd = signTokenType == JavaTokenType.ANDAND;
        boolean isOrOr = signTokenType == JavaTokenType.OROR;
        PsiExpression[] operands = expression.getOperands();
        Boolean lValue = isAndAnd;
        PsiExpression lOperand = null;
        Boolean rValue = null;
        for (int i = 0; i < operands.length; ++i) {
            PsiExpression rOperand = operands[i];
            if ((isAndAnd || isOrOr) && this.myEnabledShortCircuit) {
                boolean gotoIsAtStart;
                Object exprValue = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)rOperand);
                if (exprValue instanceof Boolean) {
                    this.myCurrentFlow.setConstantConditionOccurred(true);
                    rValue = this.shouldCalculateConstantExpression((PsiExpression)expression) ? (Boolean)exprValue : null;
                }
                BranchingInstruction.Role role = isAndAnd ? (BranchingInstruction.Role)((Object)this.myEndJumpRoles.peek()) : (BranchingInstruction.Role)((Object)this.myStartJumpRoles.peek());
                PsiElement gotoElement = isAndAnd ? this.myEndStatementStack.peekElement() : this.myStartStatementStack.peekElement();
                boolean bl = gotoIsAtStart = isAndAnd ? this.myEndStatementStack.peekAtStart() : this.myStartStatementStack.peekAtStart();
                Shortcut shortcut = lValue != null ? (lValue == isOrOr ? Shortcut.STOP_EXPRESSION : Shortcut.SKIP_CURRENT_OPERAND) : (rValue != null && rValue == isOrOr ? Shortcut.STOP_EXPRESSION : Shortcut.NO_SHORTCUT);
                switch (shortcut) {
                    case NO_SHORTCUT: {
                        assert (lOperand != null);
                        this.myCurrentFlow.addInstruction(new ConditionalGoToInstruction(0, role, lOperand));
                        this.addElementOffsetLater(gotoElement, gotoIsAtStart);
                        break;
                    }
                    case STOP_EXPRESSION: {
                        if (lOperand == null) break;
                        this.myCurrentFlow.addInstruction(new GoToInstruction(0, role));
                        this.addElementOffsetLater(gotoElement, gotoIsAtStart);
                        break;
                    }
                }
                if (shortcut == Shortcut.STOP_EXPRESSION) break;
            }
            this.generateLOperand(rOperand, i == operands.length - 1 ? null : operands[i + 1], signTokenType);
            lOperand = rOperand;
            lValue = rValue;
        }
        this.finishElement((PsiElement)expression);
    }

    private void generateLOperand(@NotNull PsiExpression lOperand, @Nullable PsiExpression rOperand, @NotNull IElementType signTokenType) {
        if (lOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lOperand", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateLOperand"));
        }
        if (signTokenType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signTokenType", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateLOperand"));
        }
        if (rOperand != null) {
            this.myStartJumpRoles.push((Object)BranchingInstruction.Role.END);
            this.myEndJumpRoles.push((Object)BranchingInstruction.Role.END);
            PsiExpression then2 = signTokenType == JavaTokenType.OROR ? this.myStartStatementStack.peekElement() : rOperand;
            boolean thenAtStart = signTokenType != JavaTokenType.OROR || this.myStartStatementStack.peekAtStart();
            this.myStartStatementStack.pushStatement((PsiElement)then2, thenAtStart);
            PsiExpression elseS = signTokenType == JavaTokenType.ANDAND ? this.myEndStatementStack.peekElement() : rOperand;
            boolean elseAtStart = signTokenType != JavaTokenType.ANDAND || this.myEndStatementStack.peekAtStart();
            this.myEndStatementStack.pushStatement((PsiElement)elseS, elseAtStart);
        }
        lOperand.accept((PsiElementVisitor)this);
        if (rOperand != null) {
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
            this.myStartJumpRoles.pop();
            this.myEndJumpRoles.pop();
        }
    }

    private static boolean isInsideIfCondition(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "isInsideIfCondition"));
        }
        PsiExpression element = expression;
        while (element instanceof PsiExpression) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiIfStatement && element == ((PsiIfStatement)parent).getCondition()) {
                return true;
            }
            element = parent;
        }
        return false;
    }

    private boolean shouldCalculateConstantExpression(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "shouldCalculateConstantExpression"));
        }
        return this.myEvaluateConstantIfCondition || !ControlFlowAnalyzer.isInsideIfCondition(expression);
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
        this.visitChildren((PsiElement)expression);
    }

    private void visitChildren(@NotNull PsiElement element) {
        PsiElement[] children2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "visitChildren"));
        }
        this.startElement(element);
        for (PsiElement child : children2 = element.getChildren()) {
            ProgressManager.checkCanceled();
            child.accept((PsiElementVisitor)this);
        }
        this.finishElement(element);
    }

    public void visitConditionalExpression(PsiConditionalExpression expression) {
        this.startElement((PsiElement)expression);
        PsiExpression condition = expression.getCondition();
        PsiExpression thenExpression = expression.getThenExpression();
        PsiExpression elseExpression = expression.getElseExpression();
        this.generateConditionalStatementInstructions((PsiElement)expression, condition, (PsiElement)thenExpression, (PsiElement)elseExpression);
        this.finishElement((PsiElement)expression);
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
        this.startElement((PsiElement)expression);
        PsiExpression operand = expression.getOperand();
        operand.accept((PsiElementVisitor)this);
        this.finishElement((PsiElement)expression);
    }

    public void visitLiteralExpression(PsiLiteralExpression expression) {
        this.startElement((PsiElement)expression);
        this.finishElement((PsiElement)expression);
    }

    public void visitLambdaExpression(PsiLambdaExpression expression) {
        this.startElement((PsiElement)expression);
        PsiElement body = expression.getBody();
        if (body != null) {
            ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
            this.addUsedVariables(array, body);
            for (PsiVariable var : array) {
                ProgressManager.checkCanceled();
                this.generateReadInstruction(var);
            }
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        this.startElement((PsiElement)expression);
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        methodExpression.accept((PsiElementVisitor)this);
        PsiExpressionList argumentList = expression.getArgumentList();
        argumentList.accept((PsiElementVisitor)this);
        this.emitEmptyInstruction();
        this.generateCheckedExceptionJumps((PsiElement)expression);
        this.finishElement((PsiElement)expression);
    }

    public void visitNewExpression(PsiNewExpression expression) {
        PsiElement[] children2;
        this.startElement((PsiElement)expression);
        int pc = this.myCurrentFlow.getSize();
        for (PsiElement child : children2 = expression.getChildren()) {
            ProgressManager.checkCanceled();
            child.accept((PsiElementVisitor)this);
        }
        this.generateCheckedExceptionJumps((PsiElement)expression);
        if (pc == this.myCurrentFlow.getSize()) {
            this.emitEmptyInstruction();
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
        this.visitChildren((PsiElement)expression);
    }

    public void visitPostfixExpression(PsiPostfixExpression expression) {
        this.startElement((PsiElement)expression);
        IElementType op = expression.getOperationTokenType();
        PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getOperand());
        if (operand != null) {
            PsiVariable variable;
            operand.accept((PsiElementVisitor)this);
            if ((op == JavaTokenType.PLUSPLUS || op == JavaTokenType.MINUSMINUS) && operand instanceof PsiReferenceExpression && (variable = this.getUsedVariable((PsiReferenceExpression)operand)) != null) {
                this.generateWriteInstruction(variable);
            }
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitPrefixExpression(PsiPrefixExpression expression) {
        this.startElement((PsiElement)expression);
        PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getOperand());
        if (operand != null) {
            PsiVariable variable;
            IElementType operationSign = expression.getOperationTokenType();
            if (operationSign == JavaTokenType.EXCL) {
                PsiElement topStartStatement = this.myStartStatementStack.peekElement();
                boolean topAtStart = this.myStartStatementStack.peekAtStart();
                this.myStartStatementStack.pushStatement(this.myEndStatementStack.peekElement(), this.myEndStatementStack.peekAtStart());
                this.myEndStatementStack.pushStatement(topStartStatement, topAtStart);
            }
            operand.accept((PsiElementVisitor)this);
            if (operationSign == JavaTokenType.EXCL) {
                this.myStartStatementStack.popStatement();
                this.myEndStatementStack.popStatement();
            }
            if (operand instanceof PsiReferenceExpression && (operationSign == JavaTokenType.PLUSPLUS || operationSign == JavaTokenType.MINUSMINUS) && (variable = this.getUsedVariable((PsiReferenceExpression)operand)) != null) {
                this.generateWriteInstruction(variable);
            }
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitReferenceExpression(PsiReferenceExpression expression) {
        PsiVariable variable;
        this.startElement((PsiElement)expression);
        PsiExpression qualifier = expression.getQualifierExpression();
        if (qualifier != null) {
            qualifier.accept((PsiElementVisitor)this);
        }
        if ((variable = this.getUsedVariable(expression)) != null) {
            this.generateReadInstruction(variable);
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitSuperExpression(PsiSuperExpression expression) {
        this.startElement((PsiElement)expression);
        this.finishElement((PsiElement)expression);
    }

    public void visitThisExpression(PsiThisExpression expression) {
        this.startElement((PsiElement)expression);
        this.finishElement((PsiElement)expression);
    }

    public void visitTypeCastExpression(PsiTypeCastExpression expression) {
        this.startElement((PsiElement)expression);
        PsiExpression operand = expression.getOperand();
        if (operand != null) {
            operand.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitClass(PsiClass aClass) {
        PsiElement arguments;
        this.startElement((PsiElement)aClass);
        if (aClass instanceof PsiAnonymousClass && (arguments = PsiTreeUtil.getChildOfType((PsiElement)aClass, PsiExpressionList.class)) != null) {
            arguments.accept((PsiElementVisitor)this);
        }
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        this.addUsedVariables(array, (PsiElement)aClass);
        for (PsiVariable var : array) {
            ProgressManager.checkCanceled();
            this.generateReadInstruction(var);
        }
        this.finishElement((PsiElement)aClass);
    }

    private void addUsedVariables(@NotNull List<PsiVariable> array, @NotNull PsiElement scope) {
        PsiElement[] children2;
        PsiVariable variable;
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "addUsedVariables"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "addUsedVariables"));
        }
        if (scope instanceof PsiReferenceExpression && (variable = this.getUsedVariable((PsiReferenceExpression)scope)) != null && !array.contains(variable)) {
            array.add(variable);
        }
        for (PsiElement child : children2 = scope.getChildren()) {
            ProgressManager.checkCanceled();
            this.addUsedVariables(array, child);
        }
    }

    private void generateReadInstruction(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateReadInstruction"));
        }
        ReadVariableInstruction instruction = new ReadVariableInstruction(variable);
        this.myCurrentFlow.addInstruction(instruction);
    }

    private void generateWriteInstruction(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateWriteInstruction"));
        }
        WriteVariableInstruction instruction = new WriteVariableInstruction(variable);
        this.myCurrentFlow.addInstruction(instruction);
    }

    @Nullable
    private PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "getUsedVariable"));
        }
        if (refExpr.getParent() instanceof PsiMethodCallExpression) {
            return null;
        }
        return this.myPolicy.getUsedVariable(refExpr);
    }

    private static enum Shortcut {
        NO_SHORTCUT,
        SKIP_CURRENT_OPERAND,
        STOP_EXPRESSION;

    }

    private static class StatementStack {
        private final Stack<PsiElement> myStatements = new Stack();
        private final TIntArrayList myAtStart = new TIntArrayList();

        private StatementStack() {
        }

        private void popStatement() {
            this.myAtStart.remove(this.myAtStart.size() - 1);
            this.myStatements.pop();
        }

        @NotNull
        private PsiElement peekElement() {
            PsiElement psiElement = (PsiElement)this.myStatements.peek();
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer$StatementStack", "peekElement"));
            }
            return psiElement;
        }

        private boolean peekAtStart() {
            return this.myAtStart.get(this.myAtStart.size() - 1) == 1;
        }

        private void pushStatement(@NotNull PsiElement statement2, boolean atStart) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer$StatementStack", "pushStatement"));
            }
            this.myStatements.push((Object)statement2);
            this.myAtStart.add(atStart ? 1 : 0);
        }
    }
}

