/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.FilterPositionUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;

public class FilterUtil {
    private FilterUtil() {
    }

    @Nullable
    public static PsiType getTypeByElement(PsiElement element, PsiElement context) {
        if (element instanceof PsiType) {
            return (PsiType)element;
        }
        if (element instanceof PsiClass) {
            return JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory().createType((PsiClass)element);
        }
        if (element instanceof PsiMethod) {
            PsiClass containingClass;
            if (((PsiMethod)element).isConstructor() && (containingClass = ((PsiMethod)element).getContainingClass()) != null) {
                return JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory().createType(containingClass);
            }
            return ((PsiMethod)element).getReturnType();
        }
        if (element instanceof PsiVariable) {
            return ((PsiVariable)element).getType();
        }
        if (element instanceof PsiKeyword) {
            return FilterUtil.getKeywordItemType(context, element.getText());
        }
        if (element instanceof PsiExpression) {
            return ((PsiExpression)element).getType();
        }
        return null;
    }

    public static PsiType getKeywordItemType(PsiElement context, String keyword) {
        if ("class".equals(keyword)) {
            return PsiType.getJavaLangClass((PsiManager)context.getManager(), (GlobalSearchScope)context.getResolveScope());
        }
        if ("true".equals(keyword) || "false".equals(keyword)) {
            return PsiType.BOOLEAN;
        }
        if ("this".equals(keyword)) {
            PsiElement previousElement = FilterUtil.getPreviousElement(context, false);
            if (previousElement != null && ".".equals(previousElement.getText())) {
                previousElement = FilterUtil.getPreviousElement(previousElement, false);
                assert (previousElement != null);
                String className = previousElement.getText();
                for (PsiElement walker = context; walker != null; walker = walker.getContext()) {
                    if (!(walker instanceof PsiClass) || walker instanceof PsiAnonymousClass || !className.equals(((PsiClass)walker).getName())) continue;
                    return FilterUtil.getTypeByElement(walker, context);
                }
            } else {
                PsiClass owner = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)context, PsiClass.class, (boolean)true);
                return FilterUtil.getTypeByElement((PsiElement)owner, context);
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement getPreviousElement(PsiElement element, boolean skipReference) {
        PsiElement prev = element;
        if (element != null) {
            if (skipReference) {
                prev = FilterPositionUtil.searchNonSpaceNonCommentBack(element);
                while (prev != null && prev.getParent() instanceof PsiJavaCodeReferenceElement) {
                    prev = FilterPositionUtil.searchNonSpaceNonCommentBack(prev.getParent());
                }
            } else {
                prev = FilterPositionUtil.searchNonSpaceNonCommentBack(prev);
            }
        }
        return prev;
    }
}

