/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.util.ArrayUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.annotations.Nullable;

public class SmartIntToIntArrayMap {
    @Nullable
    TIntObjectHashMap<TIntArrayList> myMultipleValuesMap;
    TIntIntHashMap mySingleValueMap = new TIntIntHashMap(10, 0.9f);

    public int[] keys() {
        int[] multiKeys = this.myMultipleValuesMap != null ? this.myMultipleValuesMap.keys() : ArrayUtil.EMPTY_INT_ARRAY;
        int[] singleKeys = this.mySingleValueMap.keys();
        if (singleKeys.length == 0) {
            return multiKeys;
        }
        int[] combinedKeys = new int[multiKeys.length + singleKeys.length];
        System.arraycopy(multiKeys, 0, combinedKeys, 0, multiKeys.length);
        System.arraycopy(singleKeys, 0, combinedKeys, multiKeys.length, singleKeys.length);
        return combinedKeys;
    }

    public void addOccurence(int key2, int value) {
        if (this.myMultipleValuesMap != null && this.myMultipleValuesMap.containsKey(key2)) {
            this.addToMultimap(key2, value);
        } else if (this.mySingleValueMap.containsKey(key2)) {
            int storedId = this.mySingleValueMap.get(key2);
            if (storedId == value) {
                return;
            }
            this.mySingleValueMap.remove(key2);
            this.addToMultimap(key2, storedId);
            this.addToMultimap(key2, value);
        } else {
            this.mySingleValueMap.put(key2, value);
        }
    }

    private void addToMultimap(int key2, int value) {
        TIntObjectHashMap<TIntArrayList> map;
        TIntArrayList list;
        if (this.myMultipleValuesMap == null) {
            this.myMultipleValuesMap = new TIntObjectHashMap(10, 0.9f);
        }
        if ((list = (TIntArrayList)(map = this.myMultipleValuesMap).get(key2)) == null) {
            list = new TIntArrayList(3);
            map.put(key2, (Object)list);
        }
        if (!list.contains(value)) {
            list.add(value);
        }
    }

    public void removeOccurence(int key2, int value) {
        if (this.mySingleValueMap.containsKey(key2)) {
            this.mySingleValueMap.remove(key2);
        } else {
            this.removeFromMultiMap(key2, value);
        }
    }

    private void removeFromMultiMap(int key2, int value) {
        int offset;
        TIntObjectHashMap<TIntArrayList> map = this.myMultipleValuesMap;
        if (map == null) {
            return;
        }
        TIntArrayList list = (TIntArrayList)map.get(key2);
        if (list != null && (offset = list.indexOf(value)) != -1) {
            list.remove(offset);
            if (list.isEmpty()) {
                map.remove(key2);
            }
        }
    }

    public int[] get(int key2) {
        if (this.mySingleValueMap.containsKey(key2)) {
            int id = this.mySingleValueMap.get(key2);
            return new int[]{id};
        }
        return this.getFromMultimap(key2);
    }

    private int[] getFromMultimap(int key2) {
        TIntArrayList res;
        TIntArrayList tIntArrayList = res = this.myMultipleValuesMap != null ? (TIntArrayList)this.myMultipleValuesMap.get(key2) : null;
        if (res == null) {
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        return res.toNativeArray();
    }
}

