/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.options.SchemeDataHolder;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemeImpl
extends ExternalizableSchemeAdapter
implements CodeStyleScheme {
    private static final Logger LOG = Logger.getInstance(CodeStyleSchemeImpl.class);
    private SchemeDataHolder myDataHolder;
    private String myParentSchemeName;
    private final boolean myIsDefault;
    private volatile CodeStyleSettings myCodeStyleSettings;

    CodeStyleSchemeImpl(@NotNull String name, String parentSchemeName, @NotNull SchemeDataHolder dataHolder) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "<init>"));
        }
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "<init>"));
        }
        this.myName = name;
        this.myDataHolder = dataHolder;
        this.myIsDefault = false;
        this.myParentSchemeName = parentSchemeName;
    }

    public CodeStyleSchemeImpl(@NotNull String name, boolean isDefault, CodeStyleScheme parentScheme) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "<init>"));
        }
        this.myName = name;
        this.myIsDefault = isDefault;
        this.init(parentScheme, null);
    }

    private void init(@Nullable CodeStyleScheme parentScheme, Element root) {
        if (parentScheme == null) {
            this.myCodeStyleSettings = new CodeStyleSettings();
        } else {
            CodeStyleSettings parentSettings = parentScheme.getCodeStyleSettings();
            this.myCodeStyleSettings = parentSettings.clone();
            while (parentSettings.getParentSettings() != null) {
                parentSettings = parentSettings.getParentSettings();
            }
            this.myCodeStyleSettings.setParentSettings(parentSettings);
        }
        if (root != null) {
            try {
                this.myCodeStyleSettings.readExternal(root);
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public CodeStyleSettings getCodeStyleSettings() {
        if (this.myDataHolder != null) {
            this.init(this.myParentSchemeName == null ? null : (CodeStyleScheme)CodeStyleSchemesImpl.getSchemeManager().findSchemeByName(this.myParentSchemeName), this.myDataHolder.read());
            this.myParentSchemeName = null;
            this.myDataHolder = null;
        }
        return this.myCodeStyleSettings;
    }

    boolean isInitialized() {
        return this.myDataHolder == null;
    }

    public void setCodeStyleSettings(@NotNull CodeStyleSettings codeStyleSettings) {
        if (codeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyleSettings", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "setCodeStyleSettings"));
        }
        this.myCodeStyleSettings = codeStyleSettings;
        this.myParentSchemeName = null;
        this.myDataHolder = null;
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    @NotNull
    public Element writeScheme() throws WriteExternalException {
        if (this.myDataHolder == null) {
            Element newElement = new Element("code_scheme");
            newElement.setAttribute("name", this.getName());
            this.myCodeStyleSettings.writeExternal(newElement);
            Element element = newElement;
            if (element == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "writeScheme"));
            }
            return element;
        }
        Element element = this.myDataHolder.read();
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "writeScheme"));
        }
        return element;
    }
}

