/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabPostFormatProcessor
implements PostFormatProcessor {
    @Override
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processElement"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processElement"));
        }
        TabPostFormatProcessor.doProcess(source, TextRange.from((int)source.getTextRange().getStartOffset(), (int)source.getTextLength()), settings);
        return source;
    }

    @Override
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processText"));
        }
        if (rangeToReformat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeToReformat", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processText"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processText"));
        }
        return TabPostFormatProcessor.doProcess((PsiElement)source, rangeToReformat, settings);
    }

    @NotNull
    private static TextRange doProcess(@NotNull PsiElement source, @NotNull TextRange range, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "doProcess"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "doProcess"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "doProcess"));
        }
        ASTNode node = source.getNode();
        if (node == null) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "doProcess"));
            }
            return textRange;
        }
        Language language = source.getLanguage();
        if (language != JavaLanguage.INSTANCE) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "doProcess"));
            }
            return textRange;
        }
        if (!source.isValid()) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "doProcess"));
            }
            return textRange;
        }
        PsiFile file2 = source.getContainingFile();
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptionsByFile(file2, range);
        boolean useTabs = indentOptions.USE_TAB_CHARACTER;
        boolean smartTabs = indentOptions.SMART_TABS;
        int tabWidth = indentOptions.TAB_SIZE;
        TextRange textRange = TabPostFormatProcessor.processViaPsi(node, range, new TreeHelperImpl(), useTabs, smartTabs, tabWidth);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "doProcess"));
        }
        return textRange;
    }

    @NotNull
    static TextRange processViaPsi(@NotNull ASTNode node, @NotNull TextRange range, @NotNull TreeHelper treeHelper, boolean useTabs, boolean smartTabs, int tabWidth) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processViaPsi"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processViaPsi"));
        }
        if (treeHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeHelper", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processViaPsi"));
        }
        AstHelper helper = new AstHelper(node, treeHelper);
        do {
            if (useTabs) {
                if (smartTabs) {
                    range = TabPostFormatProcessor.processSmartTabs(helper, range, tabWidth);
                    continue;
                }
                range = TabPostFormatProcessor.processTabs(helper, range, tabWidth);
                continue;
            }
            range = TabPostFormatProcessor.processSpaces(helper, range, tabWidth);
        } while (helper.nextLine());
        TextRange textRange = range;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processViaPsi"));
        }
        return textRange;
    }

    @NotNull
    static TextRange processViaDocument(@NotNull Document document2, @NotNull TextRange range, boolean useTabs, boolean useSmartTabs, int tabWidth) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processViaDocument"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processViaDocument"));
        }
        TextRange result2 = range;
        int startLine = document2.getLineNumber(Math.min(document2.getTextLength(), range.getStartOffset()));
        int endLine = document2.getLineNumber(Math.max(0, Math.min(document2.getTextLength(), range.getEndOffset()) - 1));
        DocumentHelper helper = new DocumentHelper(document2, startLine);
        for (int line = startLine; line <= endLine; ++line) {
            helper.setLine(line);
            if (useTabs) {
                if (useSmartTabs) {
                    result2 = TabPostFormatProcessor.processSmartTabs(helper, result2, tabWidth);
                    continue;
                }
                result2 = TabPostFormatProcessor.processTabs(helper, result2, tabWidth);
                continue;
            }
            result2 = TabPostFormatProcessor.processSpaces(helper, result2, tabWidth);
        }
        TextRange textRange = result2;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processViaDocument"));
        }
        return textRange;
    }

    @NotNull
    private static TextRange processSpaces(@NotNull Helper helper, @NotNull TextRange range, int tabWidth) {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processSpaces"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processSpaces"));
        }
        CharSequence indent = helper.getCurrentLineIndent();
        int start = Math.max(0, range.getStartOffset() - helper.getCurrentLineStartOffset());
        int end = Math.min(indent.length(), range.getEndOffset() - helper.getCurrentLineStartOffset());
        int tabsNumber = 0;
        int indentOffset = end;
        for (int i = start; i < end; ++i) {
            char c = indent.charAt(i);
            if (c == '\t') {
                ++tabsNumber;
                continue;
            }
            if (c == ' ') continue;
            indentOffset = i;
            break;
        }
        if (tabsNumber > 0) {
            helper.replace(start, indentOffset, StringUtil.repeat((String)" ", (int)(indentOffset - start - tabsNumber + tabsNumber * tabWidth)));
            TextRange textRange = TextRange.create((int)range.getStartOffset(), (int)(range.getEndOffset() - tabsNumber + tabsNumber * tabWidth));
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processSpaces"));
            }
            return textRange;
        }
        TextRange textRange = range;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processSpaces"));
        }
        return textRange;
    }

    @NotNull
    private static TextRange processTabs(@NotNull Helper helper, @NotNull TextRange range, int tabWidth) {
        int tabsNumber;
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processTabs"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processTabs"));
        }
        CharSequence indent = helper.getCurrentLineIndent();
        int start = Math.max(0, range.getStartOffset() - helper.getCurrentLineStartOffset());
        int end = Math.min(indent.length(), range.getEndOffset() - helper.getCurrentLineStartOffset());
        int replacementsNumber = 0;
        int consecutiveSpaces = 0;
        for (int i = start; i < end; ++i) {
            char c = indent.charAt(i);
            if (c == ' ') {
                ++consecutiveSpaces;
                continue;
            }
            int tabsNumber2 = consecutiveSpaces / tabWidth;
            if (tabsNumber2 > 0) {
                helper.replace(i - consecutiveSpaces, i - consecutiveSpaces + tabsNumber2 * tabWidth, StringUtil.repeat((String)"\t", (int)tabsNumber2));
                ++replacementsNumber;
                consecutiveSpaces = 0;
            }
            if (c != '\t') break;
        }
        if ((tabsNumber = consecutiveSpaces / tabWidth) > 0) {
            helper.replace(end - consecutiveSpaces, end - consecutiveSpaces + tabsNumber * tabWidth, StringUtil.repeat((String)"\t", (int)tabsNumber));
        }
        if (replacementsNumber > 0) {
            TextRange textRange = TextRange.create((int)range.getStartOffset(), (int)(range.getEndOffset() - replacementsNumber * (tabWidth - 1)));
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processTabs"));
            }
            return textRange;
        }
        TextRange textRange = range;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processTabs"));
        }
        return textRange;
    }

    @NotNull
    private static TextRange processSmartTabs(@NotNull Helper helper, @NotNull TextRange range, int tabWidth) {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processSmartTabs"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processSmartTabs"));
        }
        CharSequence prevLineIndent = helper.getPrevLineIndent();
        if (prevLineIndent == null) {
            TextRange textRange = TabPostFormatProcessor.processTabs(helper, range, tabWidth);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processSmartTabs"));
            }
            return textRange;
        }
        CharSequence currentLineIndent = helper.getCurrentLineIndent();
        int lineStart = 0;
        int start = Math.max(0, range.getStartOffset() - helper.getCurrentLineStartOffset());
        int end = Math.min(currentLineIndent.length(), range.getEndOffset() - helper.getCurrentLineStartOffset());
        int indentOffset = 0;
        int tabsReplaced = 0;
        for (int i = lineStart; i < end && indentOffset < prevLineIndent.length(); ++i, ++indentOffset) {
            char c = currentLineIndent.charAt(i);
            if (prevLineIndent.charAt(indentOffset) == ' ') {
                if (c != ' ') break;
                continue;
            }
            if (c == '\t') continue;
            if (end - i < tabWidth) break;
            boolean canReplace = true;
            int max = Math.min(end, i + tabWidth);
            for (int j = i + 1; j < max; ++j) {
                if (currentLineIndent.charAt(j) == ' ') continue;
                canReplace = false;
                break;
            }
            if (!canReplace) break;
            if (i < start) {
                i += tabWidth - 1;
                continue;
            }
            helper.replace(i, i + tabWidth, "\t");
            ++tabsReplaced;
            end -= tabWidth - 1;
        }
        TextRange textRange = tabsReplaced > 0 ? TextRange.create((int)range.getStartOffset(), (int)(range.getEndOffset() - tabsReplaced * (tabWidth - 1))) : range;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor", "processSmartTabs"));
        }
        return textRange;
    }

    private static class TreeHelperImpl
    implements TreeHelper {
        private TreeHelperImpl() {
        }

        @Override
        public ASTNode prevLeaf(@NotNull ASTNode current) {
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$TreeHelperImpl", "prevLeaf"));
            }
            return TreeUtil.prevLeaf(current);
        }

        @Override
        @Nullable
        public ASTNode nextLeaf(@NotNull ASTNode current) {
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$TreeHelperImpl", "nextLeaf"));
            }
            return TreeUtil.nextLeaf(current);
        }

        @Override
        @Nullable
        public ASTNode firstLeaf(@NotNull ASTNode startNode) {
            if (startNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startNode", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$TreeHelperImpl", "firstLeaf"));
            }
            return TreeUtil.findFirstLeaf(startNode);
        }

        @Override
        public void replace(@NotNull String newText, @NotNull TextRange range, @NotNull ASTNode leaf) {
            if (newText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$TreeHelperImpl", "replace"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$TreeHelperImpl", "replace"));
            }
            if (leaf == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leaf", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$TreeHelperImpl", "replace"));
            }
            FormatterUtil.replaceInnerWhiteSpace(newText, leaf, range);
        }
    }

    static interface TreeHelper {
        @Nullable
        public ASTNode prevLeaf(@NotNull ASTNode var1);

        @Nullable
        public ASTNode nextLeaf(@NotNull ASTNode var1);

        @Nullable
        public ASTNode firstLeaf(@NotNull ASTNode var1);

        public void replace(@NotNull String var1, @NotNull TextRange var2, @NotNull ASTNode var3);
    }

    private static class AstHelper
    implements Helper {
        @NotNull
        private final TreeHelper myHelper;
        @Nullable
        private ASTNode myCurrentIndentHolder;
        private int myLineStartOffset;

        AstHelper(@NotNull ASTNode startNode, @NotNull TreeHelper helper) {
            if (startNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startNode", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$AstHelper", "<init>"));
            }
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$AstHelper", "<init>"));
            }
            this.myHelper = helper;
            this.myCurrentIndentHolder = this.myHelper.firstLeaf(startNode);
            if (startNode.getStartOffset() <= 0) {
                return;
            }
            this.nextLine();
        }

        @Override
        public CharSequence getPrevLineIndent() {
            if (this.myCurrentIndentHolder == null) {
                return null;
            }
            int end = this.myLineStartOffset - 1;
            CharSequence text = this.myCurrentIndentHolder.getChars();
            for (int i = end - 1; i >= 0; --i) {
                if (text.charAt(i) != '\n') continue;
                return text.subSequence(i + 1, end);
            }
            ASTNode prev = this.prevIndentNode(this.myCurrentIndentHolder);
            if (prev != null) {
                CharSequence chars = prev.getChars();
                for (int i = chars.length() - 1; i >= 0; --i) {
                    if (chars.charAt(i) != '\n') continue;
                    return chars.subSequence(i + 1, chars.length());
                }
                return chars;
            }
            return null;
        }

        @Override
        public int getCurrentLineStartOffset() {
            ASTNode whiteSpace = this.myCurrentIndentHolder;
            return whiteSpace == null ? 0 : whiteSpace.getStartOffset() + this.myLineStartOffset;
        }

        @Override
        @NotNull
        public CharSequence getCurrentLineIndent() {
            if (this.myCurrentIndentHolder == null || this.myLineStartOffset < 0) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$AstHelper", "getCurrentLineIndent"));
                }
                return "";
            }
            CharSequence text = this.myCurrentIndentHolder.getChars();
            for (int i = this.myLineStartOffset; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c != '\n' && (c == ' ' || c == '\t')) continue;
                CharSequence charSequence = text.subSequence(this.myLineStartOffset, i);
                if (charSequence == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$AstHelper", "getCurrentLineIndent"));
                }
                return charSequence;
            }
            CharSequence charSequence = text.subSequence(this.myLineStartOffset, text.length());
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$AstHelper", "getCurrentLineIndent"));
            }
            return charSequence;
        }

        @Override
        public void replace(int start, int end, @NotNull String newText) {
            if (newText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$AstHelper", "replace"));
            }
            if (this.myCurrentIndentHolder != null) {
                this.myHelper.replace(newText, TextRange.create((int)start, (int)end).shiftRight(this.getCurrentLineStartOffset()), this.myCurrentIndentHolder);
            }
        }

        public boolean nextLine() {
            if (this.myCurrentIndentHolder == null) {
                return false;
            }
            ASTNode node = this.myHelper.nextLeaf(this.myCurrentIndentHolder);
            while (node != null) {
                if (this.myCurrentIndentHolder.getTextLength() > 0) {
                    CharSequence text = node.getChars();
                    this.myLineStartOffset = 0;
                    while (this.myLineStartOffset < text.length()) {
                        char c = text.charAt(this.myLineStartOffset);
                        if (c == '\n' && this.myLineStartOffset < text.length() - 1) {
                            this.myCurrentIndentHolder = node;
                            ++this.myLineStartOffset;
                            return true;
                        }
                        ++this.myLineStartOffset;
                    }
                }
                node = this.myHelper.nextLeaf(node);
            }
            this.myCurrentIndentHolder = null;
            return false;
        }

        @Nullable
        private ASTNode prevIndentNode(@NotNull ASTNode current) {
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$AstHelper", "prevIndentNode"));
            }
            ASTNode candidate = this.myHelper.prevLeaf(current);
            while (candidate != null) {
                if (candidate.getStartOffset() <= 0 || StringUtil.contains((CharSequence)candidate.getChars(), (int)0, (int)candidate.getTextLength(), (char)'\n')) {
                    return candidate;
                }
                candidate = this.myHelper.prevLeaf(candidate);
            }
            return null;
        }
    }

    private static class DocumentHelper
    implements Helper {
        @NotNull
        private final Document myDocument;
        private int myLine;
        private int myLineStartOffset;

        DocumentHelper(@NotNull Document document2, int line) {
            if (document2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$DocumentHelper", "<init>"));
            }
            this.myDocument = document2;
            this.setLine(line);
        }

        @Override
        @Nullable
        public CharSequence getPrevLineIndent() {
            int prevLineStart;
            char c;
            int prevLineIndentEnd;
            if (this.myLine <= 0) {
                return null;
            }
            int prevLineEnd = this.myDocument.getLineEndOffset(this.myLine - 1);
            CharSequence text = this.myDocument.getCharsSequence();
            for (prevLineIndentEnd = prevLineStart = this.myDocument.getLineStartOffset(this.myLine - 1); prevLineIndentEnd < prevLineEnd && ((c = text.charAt(prevLineIndentEnd)) == '\t' || c == ' '); ++prevLineIndentEnd) {
            }
            return text.subSequence(prevLineStart, prevLineIndentEnd);
        }

        @Override
        public int getCurrentLineStartOffset() {
            return this.myLineStartOffset;
        }

        @Override
        @NotNull
        public CharSequence getCurrentLineIndent() {
            int end = this.myDocument.getLineEndOffset(this.myLine);
            CharSequence text = this.myDocument.getCharsSequence();
            for (int i = this.myLineStartOffset; i < end; ++i) {
                char c = text.charAt(i);
                if (c == ' ' || c == '\t') continue;
                CharSequence charSequence = text.subSequence(this.myLineStartOffset, i);
                if (charSequence == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$DocumentHelper", "getCurrentLineIndent"));
                }
                return charSequence;
            }
            CharSequence charSequence = text.subSequence(this.myLineStartOffset, end);
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$DocumentHelper", "getCurrentLineIndent"));
            }
            return charSequence;
        }

        @Override
        public void replace(int start, int end, @NotNull String newText) {
            if (newText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/psi/impl/source/codeStyle/TabPostFormatProcessor$DocumentHelper", "replace"));
            }
            this.myDocument.replaceString(this.myLineStartOffset + start, this.myLineStartOffset + end, (CharSequence)newText);
        }

        public void setLine(int line) {
            this.myLine = line;
            this.myLineStartOffset = this.myDocument.getLineStartOffset(line);
        }
    }

    static interface Helper {
        @Nullable
        public CharSequence getPrevLineIndent();

        public int getCurrentLineStartOffset();

        @NotNull
        public CharSequence getCurrentLineIndent();

        public void replace(int var1, int var2, @NotNull String var3);
    }
}

