/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class ArbitraryPlaceUrlReferenceProvider
extends PsiReferenceProvider {
    private static final UserDataCache<CachedValue<PsiReference[]>, PsiElement, Object> ourRefsCache = new UserDataCache<CachedValue<PsiReference[]>, PsiElement, Object>("psielement.url.refs"){
        private final AtomicReference<GlobalPathReferenceProvider> myReferenceProvider = new AtomicReference();

        protected CachedValue<PsiReference[]> compute(PsiElement element, Object p) {
            return CachedValuesManager.getManager((Project)element.getProject()).createCachedValue(() -> {
                IssueNavigationConfiguration navigationConfiguration = IssueNavigationConfiguration.getInstance((Project)element.getProject());
                if (navigationConfiguration == null) {
                    return CachedValueProvider.Result.create((Object)PsiReference.EMPTY_ARRAY, (Object[])new Object[]{element});
                }
                List refs = null;
                GlobalPathReferenceProvider provider = this.myReferenceProvider.get();
                CharSequence commentText = StringUtil.newBombedCharSequence((CharSequence)element.getText(), (long)500L);
                for (IssueNavigationConfiguration.LinkMatch link : navigationConfiguration.findIssueLinks(commentText)) {
                    if (refs == null) {
                        refs = new SmartList();
                    }
                    if (provider == null) {
                        provider = (GlobalPathReferenceProvider)PathReferenceManager.getInstance().getGlobalWebPathReferenceProvider();
                        this.myReferenceProvider.lazySet(provider);
                    }
                    provider.createUrlReference(element, link.getTargetUrl(), link.getRange(), refs);
                }
                PsiReference[] references = refs != null ? refs.toArray(new PsiReference[refs.size()]) : PsiReference.EMPTY_ARRAY;
                return new CachedValueProvider.Result((Object)references, new Object[]{element, navigationConfiguration});
            }, false);
        }
    };

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/ArbitraryPlaceUrlReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/ArbitraryPlaceUrlReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = (PsiReference[])((CachedValue)ourRefsCache.get((UserDataHolder)element, null)).getValue();
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ArbitraryPlaceUrlReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

