/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiPolyVariantCachingReference
implements PsiPolyVariantReference {
    @NotNull
    public final ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiElement element = this.getElement();
        PsiFile file2 = element.getContainingFile();
        ResolveResult[] resolveResultArray = ResolveCache.getInstance(file2.getProject()).resolveWithCaching(this, MyResolver.INSTANCE, true, incompleteCode, file2);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/PsiPolyVariantCachingReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    @NotNull
    protected abstract ResolveResult[] resolveInner(boolean var1, @NotNull PsiFile var2);

    public boolean isReferenceTo(PsiElement element) {
        return this.getElement().getManager().areElementsEquivalent(this.resolve(), element);
    }

    public boolean isSoft() {
        return false;
    }

    @Nullable
    public static <T extends PsiElement> ElementManipulator<T> getManipulator(T currentElement) {
        return ElementManipulators.getManipulator(currentElement);
    }

    private static class MyResolver
    implements ResolveCache.PolyVariantContextResolver<PsiPolyVariantReference> {
        private static final MyResolver INSTANCE = new MyResolver();

        private MyResolver() {
        }

        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull PsiPolyVariantReference ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/reference/impl/PsiPolyVariantCachingReference$MyResolver", "resolve"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/resolve/reference/impl/PsiPolyVariantCachingReference$MyResolver", "resolve"));
            }
            ResolveResult[] resolveResultArray = ((PsiPolyVariantCachingReference)ref).resolveInner(incompleteCode, containingFile);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/PsiPolyVariantCachingReference$MyResolver", "resolve"));
            }
            return resolveResultArray;
        }
    }
}

