/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubsHierarchy.impl.SmartClassAnchor;
import org.jetbrains.annotations.NotNull;

public class ClassAnchorUtil {
    public static PsiClass retrieve(Project project2, SmartClassAnchor anchor) {
        if (anchor instanceof SmartClassAnchor.DirectSmartClassAnchor) {
            return ((SmartClassAnchor.DirectSmartClassAnchor)anchor).myPsiClass;
        }
        if (anchor instanceof SmartClassAnchor.StubSmartClassAnchor) {
            SmartClassAnchor.StubSmartClassAnchor stubAnchor = (SmartClassAnchor.StubSmartClassAnchor)anchor;
            VirtualFile file2 = PersistentFS.getInstance().findFileById(stubAnchor.myFileId);
            PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file2);
            return (PsiClass)ClassAnchorUtil.restoreFromStubIndex((PsiFileWithStubSupport)psiFile, stubAnchor.myStubId, stubAnchor.myStubElementType);
        }
        return null;
    }

    public static PsiClass retrieveInReadAction(final Project project2, final SmartClassAnchor anchor) {
        return (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                return ClassAnchorUtil.retrieve(project2, anchor);
            }
        });
    }

    private static PsiElement restoreFromStubIndex(@NotNull PsiFileWithStubSupport fileImpl, int index, IStubElementType stubElementType) {
        if (fileImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileImpl", "com/intellij/psi/stubsHierarchy/impl/ClassAnchorUtil", "restoreFromStubIndex"));
        }
        return PsiAnchor.restoreFromStubIndex(fileImpl, index, stubElementType, false);
    }
}

