/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubsHierarchy.impl.ClassAnchor;

public class SmartClassAnchor {
    public static final SmartClassAnchor[] EMPTY_ARRAY = new SmartClassAnchor[0];
    public final int myId;
    public final int myFileId;

    private SmartClassAnchor(int id, int fileId) {
        this.myId = id;
        this.myFileId = fileId;
    }

    static SmartClassAnchor create(int symbolId, ClassAnchor classAnchor) {
        if (classAnchor instanceof ClassAnchor.StubClassAnchor) {
            return new StubSmartClassAnchor(symbolId, classAnchor.myFileId, ((ClassAnchor.StubClassAnchor)classAnchor).myStubId, ((ClassAnchor.StubClassAnchor)classAnchor).myStubElementType);
        }
        if (classAnchor instanceof ClassAnchor.DirectClassAnchor) {
            return new DirectSmartClassAnchor(symbolId, classAnchor.myFileId, ((ClassAnchor.DirectClassAnchor)classAnchor).myPsiClass);
        }
        return null;
    }

    static class DirectSmartClassAnchor
    extends SmartClassAnchor {
        public final PsiClass myPsiClass;

        DirectSmartClassAnchor(int id, int fileId, PsiClass psiClass) {
            super(id, fileId);
            this.myPsiClass = psiClass;
        }
    }

    static class StubSmartClassAnchor
    extends SmartClassAnchor {
        final int myStubId;
        final IStubElementType myStubElementType;

        StubSmartClassAnchor(int id, int fileId, int stubId, IStubElementType stubElementType) {
            super(id, fileId);
            this.myStubId = stubId;
            this.myStubElementType = stubElementType;
        }
    }
}

