/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.OptimizeImportsTask;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;

public class OptimizeImportsRefactoringHelper
implements RefactoringHelper<Set<PsiJavaFile>> {
    private static final String REMOVING_REDUNDANT_IMPORTS_TITLE = "Removing redundant imports";

    @Override
    public Set<PsiJavaFile> prepareOperation(UsageInfo[] usages) {
        HashSet javaFiles = new HashSet();
        for (UsageInfo usage : usages) {
            PsiFile file2;
            if (usage.isNonCodeUsage || !((file2 = usage.getFile()) instanceof PsiJavaFile)) continue;
            javaFiles.add((PsiJavaFile)file2);
        }
        return javaFiles;
    }

    @Override
    public void performOperation(final Project project2, Set<PsiJavaFile> javaFiles) {
        CodeStyleManager.getInstance((Project)project2).performActionWithFormatterDisabled(new Runnable(){

            @Override
            public void run() {
                PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            }
        });
        HashSet redundants = new HashSet();
        Runnable findRedundantImports = () -> OptimizeImportsRefactoringHelper.lambda$performOperation$1(project2, javaFiles, (Set)redundants);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(findRedundantImports, REMOVING_REDUNDANT_IMPORTS_TITLE, false, project2)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> OptimizeImportsRefactoringHelper.lambda$performOperation$2(project2, (Set)redundants));
    }

    private static /* synthetic */ void lambda$performOperation$2(Project project2, Set redundants) {
        SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project2, REMOVING_REDUNDANT_IMPORTS_TITLE, false);
        progressTask.setMinIterationTime(200L);
        progressTask.setTask(new OptimizeImportsTask(progressTask, redundants));
        ProgressManager.getInstance().run((Task)progressTask);
    }

    private static /* synthetic */ void lambda$performOperation$1(Project project2, Set javaFiles, Set redundants) {
        DumbService.getInstance((Project)project2).runReadActionInSmartMode(() -> {
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project2);
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project2);
            int i = 0;
            int fileCount = javaFiles.size();
            for (PsiJavaFile file2 : javaFiles) {
                Collection perFile;
                VirtualFile virtualFile;
                if (!file2.isValid() || (virtualFile = file2.getVirtualFile()) == null) continue;
                if (progressIndicator != null) {
                    progressIndicator.setText2(virtualFile.getPresentableUrl());
                    progressIndicator.setFraction((double)i++ / (double)fileCount);
                }
                if ((perFile = styleManager.findRedundantImports(file2)) == null) continue;
                for (PsiImportStatementBase redundant : perFile) {
                    redundants.add(pointerManager.createSmartPsiElementPointer((PsiElement)redundant));
                }
            }
        });
    }
}

