/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPushDown;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.memberPushDown.PushDownProcessor;
import com.intellij.refactoring.ui.AbstractMemberSelectionPanel;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.usageView.UsageViewUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractPushDownDialog<MemberInfo extends MemberInfoBase<Member>, Member extends PsiElement, Klass extends PsiElement>
extends RefactoringDialog {
    private final List<MemberInfo> myMemberInfos;
    private final Klass myClass;
    private DocCommentPanel myJavaDocPanel;
    private MemberInfoModel<Member, MemberInfo> myMemberInfoModel;

    public AbstractPushDownDialog(Project project2, MemberInfo[] memberInfos, Klass aClass) {
        super(project2, true);
        this.myMemberInfos = Arrays.asList(memberInfos);
        this.myClass = aClass;
        this.setTitle(RefactoringBundle.message((String)"push.members.down.title"));
        this.init();
    }

    public List<MemberInfo> getMemberInfos() {
        return this.myMemberInfos;
    }

    public Klass getSourceClass() {
        return this.myClass;
    }

    public ArrayList<MemberInfo> getSelectedMemberInfos() {
        ArrayList<MemberInfoBase> list = new ArrayList<MemberInfoBase>(this.myMemberInfos.size());
        for (MemberInfoBase info : this.myMemberInfos) {
            if (!info.isChecked() || !this.myMemberInfoModel.isMemberEnabled(info)) continue;
            list.add(info);
        }
        return list;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.memberPushDown.PushDownDialog";
    }

    protected JComponent createNorthPanel() {
        GridBagConstraints gbConstraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        gbConstraints.insets = new Insets(4, 0, 10, 8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        panel.add((Component)new JLabel(RefactoringBundle.message((String)"push.members.from.0.down.label", (Object[])new Object[]{UsageViewUtil.getLongName(this.myClass)})), gbConstraints);
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        AbstractMemberSelectionPanel<Member, MemberInfo> memberSelectionPanel = this.createMemberInfoPanel();
        panel.add(memberSelectionPanel, "Center");
        this.myMemberInfoModel = this.createMemberInfoModel();
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        memberSelectionPanel.getTable().setMemberInfoModel(this.myMemberInfoModel);
        memberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener<Member, MemberInfo>)this.myMemberInfoModel);
        this.myJavaDocPanel = new DocCommentPanel(RefactoringBundle.message((String)"push.down.javadoc.panel.title"));
        this.myJavaDocPanel.setPolicy(this.getDocCommentPolicy());
        panel.add((Component)this.myJavaDocPanel, "East");
        return panel;
    }

    protected abstract MemberInfoModel<Member, MemberInfo> createMemberInfoModel();

    protected abstract AbstractMemberSelectionPanel<Member, MemberInfo> createMemberInfoPanel();

    protected abstract int getDocCommentPolicy();

    @Override
    protected void doAction() {
        if (!this.isOKActionEnabled()) {
            return;
        }
        this.savePreviewOption(this.isPreviewUsages());
        this.invokeRefactoring(new PushDownProcessor(this.myClass, this.getSelectedMemberInfos(), new DocCommentPolicy(this.myJavaDocPanel.getPolicy())));
    }

    protected abstract void savePreviewOption(boolean var1);
}

