/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.DirectoryChooser;
import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.HelpID;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesDialog;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.rename.DirectoryAsPackageRenameHandlerBase;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class MoveClassesOrPackagesImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesImpl");

    public static void doMove(Project project2, PsiElement[] adjustedElements, PsiElement initialTargetElement, MoveCallback moveCallback) {
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project2, Arrays.asList(adjustedElements), (boolean)true)) {
            return;
        }
        String initialTargetPackageName = MoveClassesOrPackagesImpl.getInitialTargetPackageName(initialTargetElement, adjustedElements);
        PsiDirectory initialTargetDirectory = MoveClassesOrPackagesImpl.getInitialTargetDirectory(initialTargetElement, adjustedElements);
        boolean isTargetDirectoryFixed = initialTargetDirectory == null;
        boolean searchTextOccurences = false;
        for (int i = 0; i < adjustedElements.length && !searchTextOccurences; ++i) {
            PsiElement psiElement = adjustedElements[i];
            searchTextOccurences = TextOccurrencesUtil.isSearchTextOccurencesEnabled(psiElement);
        }
        MoveClassesOrPackagesDialog moveDialog = new MoveClassesOrPackagesDialog(project2, searchTextOccurences, adjustedElements, initialTargetElement, moveCallback);
        boolean searchInComments = JavaRefactoringSettings.getInstance().MOVE_SEARCH_IN_COMMENTS;
        boolean searchForTextOccurences = JavaRefactoringSettings.getInstance().MOVE_SEARCH_FOR_TEXT;
        moveDialog.setData(adjustedElements, initialTargetPackageName, initialTargetDirectory, isTargetDirectoryFixed, initialTargetElement == null, searchInComments, searchForTextOccurences, HelpID.getMoveHelpID(adjustedElements[0]));
        moveDialog.show();
    }

    @Nullable
    public static PsiElement[] adjustForMove(Project project2, PsiElement[] elements, PsiElement targetElement) {
        PsiElement[] psiElements = new PsiElement[elements.length];
        ArrayList<String> names = new ArrayList<String>();
        for (int idx = 0; idx < elements.length; ++idx) {
            String message;
            PsiElement element = elements[idx];
            if (element instanceof PsiDirectory) {
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
                LOG.assertTrue(aPackage != null);
                if (aPackage.getQualifiedName().isEmpty()) {
                    message = RefactoringBundle.message((String)"move.package.refactoring.cannot.be.applied.to.default.package");
                    CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)message, (String)HelpID.getMoveHelpID(element), (Project)project2);
                    return null;
                }
                if (!MoveClassesOrPackagesImpl.checkNesting(project2, aPackage, targetElement, true)) {
                    return null;
                }
                if (!MoveClassesOrPackagesImpl.isAlreadyChecked(psiElements, idx, aPackage) && !MoveClassesOrPackagesImpl.checkMovePackage(project2, aPackage)) {
                    return null;
                }
                element = aPackage;
            } else if (element instanceof PsiPackage) {
                PsiPackage psiPackage = (PsiPackage)element;
                if (!MoveClassesOrPackagesImpl.checkNesting(project2, psiPackage, targetElement, true)) {
                    return null;
                }
                if (!MoveClassesOrPackagesImpl.checkMovePackage(project2, psiPackage)) {
                    return null;
                }
            } else if (element instanceof PsiClass) {
                MoveClassHandler nameProvider;
                PsiClass aClass = (PsiClass)element;
                if (aClass instanceof PsiAnonymousClass) {
                    message = RefactoringBundle.message((String)"move.class.refactoring.cannot.be.applied.to.anonymous.classes");
                    CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)message, (String)HelpID.getMoveHelpID(element), (Project)project2);
                    return null;
                }
                if (MoveClassesOrPackagesImpl.isClassInnerOrLocal(aClass)) {
                    message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"moving.local.classes.is.not.supported"));
                    CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)message, (String)HelpID.getMoveHelpID(element), (Project)project2);
                    return null;
                }
                String name = null;
                MoveClassHandler[] moveClassHandlerArray = (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions();
                int n = moveClassHandlerArray.length;
                for (int i = 0; i < n && (name = (nameProvider = moveClassHandlerArray[i]).getName(aClass)) == null; ++i) {
                }
                if (name == null) {
                    name = aClass.getContainingFile().getName();
                }
                if (names.contains(name)) {
                    String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"there.are.going.to.be.multiple.destination.files.with.the.same.name"));
                    CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)message2, (String)HelpID.getMoveHelpID(element), (Project)project2);
                    return null;
                }
                names.add(name);
            }
            psiElements[idx] = element;
        }
        return psiElements;
    }

    static boolean isClassInnerOrLocal(PsiClass aClass) {
        return aClass.getContainingClass() != null || aClass.getQualifiedName() == null;
    }

    private static boolean isAlreadyChecked(PsiElement[] psiElements, int idx, PsiPackage aPackage) {
        for (int i = 0; i < idx; ++i) {
            if (!Comparing.equal((Object)psiElements[i], (Object)aPackage)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkMovePackage(Project project2, PsiPackage aPackage) {
        PsiDirectory[] directories = aPackage.getDirectories();
        VirtualFile[] virtualFiles = aPackage.occursInPackagePrefixes();
        if (directories.length > 1 || virtualFiles.length > 0) {
            StringBuffer message = new StringBuffer();
            RenameUtil.buildPackagePrefixChangedMessage(virtualFiles, message, aPackage.getQualifiedName());
            if (directories.length > 1) {
                DirectoryAsPackageRenameHandlerBase.buildMultipleDirectoriesInPackageMessage(message, aPackage.getQualifiedName(), directories);
                message.append("\n\n");
                String report = RefactoringBundle.message((String)"all.these.directories.will.be.moved.and.all.references.to.0.will.be.changed", (Object[])new Object[]{aPackage.getQualifiedName()});
                message.append(report);
            }
            message.append("\n");
            message.append(RefactoringBundle.message((String)"do.you.wish.to.continue"));
            int ret = Messages.showYesNoDialog((Project)project2, (String)message.toString(), (String)RefactoringBundle.message((String)"warning.title"), (Icon)Messages.getWarningIcon());
            if (ret != 0) {
                return false;
            }
        }
        return true;
    }

    static boolean checkNesting(Project project2, PsiPackage srcPackage, PsiElement targetElement, boolean showError) {
        PsiPackage targetPackage;
        for (PsiPackage curPackage = targetPackage = targetElement instanceof PsiPackage ? (PsiPackage)targetElement : (targetElement instanceof PsiDirectory ? JavaDirectoryService.getInstance().getPackage((PsiDirectory)targetElement) : null); curPackage != null; curPackage = curPackage.getParentPackage()) {
            if (!curPackage.equals(srcPackage)) continue;
            if (showError) {
                CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)RefactoringBundle.message((String)"cannot.move.package.into.itself"), (String)HelpID.getMoveHelpID((PsiElement)srcPackage), (Project)project2);
            }
            return false;
        }
        return true;
    }

    public static String getInitialTargetPackageName(PsiElement initialTargetElement, PsiElement[] movedElements) {
        String name = MoveClassesOrPackagesImpl.getContainerPackageName(initialTargetElement);
        if (name == null) {
            PsiDirectory commonDirectory;
            if (movedElements != null) {
                name = MoveClassesOrPackagesImpl.getTargetPackageNameForMovedElement(movedElements[0]);
            }
            if (name == null && (commonDirectory = MoveClassesOrPackagesImpl.getCommonDirectory(movedElements)) != null && JavaDirectoryService.getInstance().getPackage(commonDirectory) != null) {
                name = JavaDirectoryService.getInstance().getPackage(commonDirectory).getQualifiedName();
            }
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    @Nullable
    private static PsiDirectory getCommonDirectory(PsiElement[] movedElements) {
        PsiDirectory commonDirectory = null;
        for (PsiElement movedElement : movedElements) {
            PsiDirectory containingDirectory;
            PsiFile containingFile = movedElement.getContainingFile();
            if (containingFile == null || (containingDirectory = containingFile.getContainingDirectory()) == null) continue;
            if (commonDirectory == null) {
                commonDirectory = containingDirectory;
                continue;
            }
            if (commonDirectory == containingDirectory) continue;
            return null;
        }
        if (commonDirectory != null) {
            return commonDirectory;
        }
        return null;
    }

    private static String getContainerPackageName(PsiElement psiElement) {
        if (psiElement instanceof PsiPackage) {
            return ((PsiPackage)psiElement).getQualifiedName();
        }
        if (psiElement instanceof PsiDirectory) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)psiElement);
            return aPackage != null ? aPackage.getQualifiedName() : "";
        }
        if (psiElement != null) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(psiElement.getContainingFile().getContainingDirectory());
            return aPackage != null ? aPackage.getQualifiedName() : "";
        }
        return null;
    }

    private static String getTargetPackageNameForMovedElement(PsiElement psiElement) {
        if (psiElement instanceof PsiPackage) {
            PsiPackage psiPackage = (PsiPackage)psiElement;
            PsiPackage parentPackage = psiPackage.getParentPackage();
            return parentPackage != null ? parentPackage.getQualifiedName() : "";
        }
        if (psiElement instanceof PsiDirectory) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)psiElement);
            return aPackage != null ? MoveClassesOrPackagesImpl.getTargetPackageNameForMovedElement((PsiElement)aPackage) : "";
        }
        if (psiElement != null) {
            PsiDirectory directory = PlatformPackageUtil.getDirectory(psiElement);
            PsiPackage aPackage = directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
            return aPackage != null ? aPackage.getQualifiedName() : "";
        }
        return null;
    }

    public static PsiDirectory getInitialTargetDirectory(PsiElement initialTargetElement, PsiElement[] movedElements) {
        PsiDirectory initialTargetDirectory = MoveClassesOrPackagesImpl.getContainerDirectory(initialTargetElement);
        if (initialTargetDirectory == null && movedElements != null) {
            PsiDirectory commonDirectory = MoveClassesOrPackagesImpl.getCommonDirectory(movedElements);
            initialTargetDirectory = commonDirectory != null ? commonDirectory : MoveClassesOrPackagesImpl.getContainerDirectory(movedElements[0]);
        }
        return initialTargetDirectory;
    }

    @Nullable
    public static PsiDirectory getContainerDirectory(PsiElement psiElement) {
        if (psiElement instanceof PsiPackage) {
            PsiDirectory[] directories = ((PsiPackage)psiElement).getDirectories();
            return directories.length == 1 ? directories[0] : null;
        }
        if (psiElement instanceof PsiDirectory) {
            return (PsiDirectory)psiElement;
        }
        if (psiElement != null) {
            return psiElement.getContainingFile().getContainingDirectory();
        }
        return null;
    }

    public static void doRearrangePackage(Project project2, PsiDirectory[] directories) {
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project2, Arrays.asList(directories), (boolean)true)) {
            return;
        }
        List<PsiDirectory> sourceRootDirectories = MoveClassesOrPackagesImpl.buildRearrangeTargetsList(project2, directories);
        DirectoryChooser chooser = new DirectoryChooser(project2);
        chooser.setTitle(RefactoringBundle.message((String)"select.source.root.chooser.title"));
        chooser.fillList(sourceRootDirectories.toArray(new PsiDirectory[sourceRootDirectories.size()]), null, project2, "");
        if (!chooser.showAndGet()) {
            return;
        }
        PsiDirectory selectedTarget = chooser.getSelectedDirectory();
        if (selectedTarget == null) {
            return;
        }
        MultiMap conflicts = new MultiMap();
        Runnable analyzeConflicts = () -> ApplicationManager.getApplication().runReadAction(() -> RefactoringConflictsUtil.analyzeModuleConflicts(project2, Arrays.asList(directories), UsageInfo.EMPTY_ARRAY, (PsiElement)selectedTarget, (MultiMap<PsiElement, String>)conflicts));
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(analyzeConflicts, "Analyze Module Conflicts...", true, project2)) {
            return;
        }
        if (!conflicts.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
            }
            ConflictsDialog conflictsDialog = new ConflictsDialog(project2, (MultiMap<PsiElement, String>)conflicts);
            if (!conflictsDialog.showAndGet()) {
                return;
            }
        }
        Ref ex = Ref.create(null);
        String commandDescription = RefactoringBundle.message((String)"moving.directories.command");
        Runnable runnable2 = () -> ApplicationManager.getApplication().runWriteAction(() -> {
            LocalHistoryAction a = LocalHistory.getInstance().startAction(commandDescription);
            try {
                MoveClassesOrPackagesImpl.rearrangeDirectoriesToTarget(directories, selectedTarget);
            }
            catch (IncorrectOperationException e) {
                ex.set((Object)e);
            }
            finally {
                a.finish();
            }
        });
        CommandProcessor.getInstance().executeCommand(project2, runnable2, commandDescription, null);
        if (ex.get() != null) {
            RefactoringUIUtil.processIncorrectOperation(project2, (IncorrectOperationException)((Object)ex.get()));
        }
    }

    private static List<PsiDirectory> buildRearrangeTargetsList(Project project2, PsiDirectory[] directories) {
        List<VirtualFile> sourceRoots = JavaProjectRootsUtil.getSuitableDestinationSourceRoots(project2);
        ArrayList<PsiDirectory> sourceRootDirectories = new ArrayList<PsiDirectory>();
        block0: for (VirtualFile sourceRoot : sourceRoots) {
            PsiPackage aPackage;
            PsiDirectory sourceRootDirectory = PsiManager.getInstance((Project)project2).findDirectory(sourceRoot);
            if (sourceRootDirectory == null || (aPackage = JavaDirectoryService.getInstance().getPackage(sourceRootDirectory)) == null) continue;
            String packagePrefix = aPackage.getQualifiedName();
            for (PsiDirectory directory : directories) {
                String qualifiedName = JavaDirectoryService.getInstance().getPackage(directory).getQualifiedName();
                if (!qualifiedName.startsWith(packagePrefix)) continue block0;
            }
            sourceRootDirectories.add(sourceRootDirectory);
        }
        return sourceRootDirectories;
    }

    private static void rearrangeDirectoriesToTarget(PsiDirectory[] directories, PsiDirectory selectedTarget) throws IncorrectOperationException {
        VirtualFile sourceRoot = selectedTarget.getVirtualFile();
        for (PsiDirectory directory : directories) {
            PsiPackage parentPackage = JavaDirectoryService.getInstance().getPackage(directory).getParentPackage();
            PackageWrapper wrapper = new PackageWrapper(parentPackage);
            PsiDirectory moveTarget = RefactoringUtil.createPackageDirectoryInSourceRoot(wrapper, sourceRoot);
            MoveClassesOrPackagesUtil.moveDirectoryRecursively(directory, moveTarget);
        }
    }
}

