/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.TaskExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessWaitFor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AbstractRemoteProcessHandler;
import com.intellij.remote.RemoteProcess;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.BaseOutputReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseRemoteProcessHandler<T extends RemoteProcess>
extends AbstractRemoteProcessHandler<T>
implements TaskExecutor {
    private static final Logger LOG = Logger.getInstance(BaseRemoteProcessHandler.class);
    protected final String myCommandLine;
    protected final ProcessWaitFor myWaitFor;
    protected final Charset myCharset;
    protected T myProcess;

    public BaseRemoteProcessHandler(@NotNull T process2, String commandLine, @Nullable Charset charset) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/remote/BaseRemoteProcessHandler", "<init>"));
        }
        this.myProcess = process2;
        this.myCommandLine = commandLine;
        this.myWaitFor = new ProcessWaitFor(process2, (TaskExecutor)this, CommandLineUtil.extractPresentableName((String)commandLine));
        this.myCharset = charset;
        if (StringUtil.isEmpty((String)commandLine)) {
            LOG.warn((Throwable)new IllegalArgumentException("Must specify non-empty 'commandLine' parameter"));
        }
    }

    @Override
    public T getProcess() {
        return this.myProcess;
    }

    protected void destroyProcessImpl() {
        if (!((RemoteProcess)this.myProcess).killProcessTree()) {
            this.baseDestroyProcessImpl();
        }
    }

    public void startNotify() {
        this.notifyTextAvailable(this.myCommandLine + '\n', ProcessOutputTypes.SYSTEM);
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(ProcessEvent event) {
                try {
                    RemoteOutputReader stdoutReader = new RemoteOutputReader(((Process)BaseRemoteProcessHandler.this.myProcess).getInputStream(), BaseRemoteProcessHandler.this.getCharset(), (RemoteProcess)BaseRemoteProcessHandler.this.myProcess, BaseRemoteProcessHandler.this.myCommandLine){

                        protected void onTextAvailable(@NotNull String text) {
                            if (text == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/remote/BaseRemoteProcessHandler$1$1", "onTextAvailable"));
                            }
                            BaseRemoteProcessHandler.this.notifyTextAvailable(text, ProcessOutputTypes.STDOUT);
                        }

                        @NotNull
                        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable2) {
                            if (runnable2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/remote/BaseRemoteProcessHandler$1$1", "executeOnPooledThread"));
                            }
                            Future future2 = BaseRemoteProcessHandler.executeOnPooledThread(runnable2);
                            if (future2 == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/BaseRemoteProcessHandler$1$1", "executeOnPooledThread"));
                            }
                            return future2;
                        }
                    };
                    RemoteOutputReader stderrReader = new RemoteOutputReader(((Process)BaseRemoteProcessHandler.this.myProcess).getErrorStream(), BaseRemoteProcessHandler.this.getCharset(), (RemoteProcess)BaseRemoteProcessHandler.this.myProcess, BaseRemoteProcessHandler.this.myCommandLine){

                        protected void onTextAvailable(@NotNull String text) {
                            if (text == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/remote/BaseRemoteProcessHandler$1$2", "onTextAvailable"));
                            }
                            BaseRemoteProcessHandler.this.notifyTextAvailable(text, ProcessOutputTypes.STDERR);
                        }

                        @NotNull
                        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable2) {
                            if (runnable2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/remote/BaseRemoteProcessHandler$1$2", "executeOnPooledThread"));
                            }
                            Future future2 = BaseRemoteProcessHandler.executeOnPooledThread(runnable2);
                            if (future2 == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/BaseRemoteProcessHandler$1$2", "executeOnPooledThread"));
                            }
                            return future2;
                        }
                    };
                    BaseRemoteProcessHandler.this.myWaitFor.setTerminationCallback(exitCode -> {
                        try {
                            try {
                                stderrReader.waitFor();
                                stdoutReader.waitFor();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        finally {
                            BaseRemoteProcessHandler.this.onOSProcessTerminated((int)exitCode);
                        }
                    });
                }
                finally {
                    BaseRemoteProcessHandler.this.removeProcessListener((ProcessListener)this);
                }
            }
        });
        super.startNotify();
    }

    protected void onOSProcessTerminated(int exitCode) {
        this.notifyProcessTerminated(exitCode);
    }

    protected void baseDestroyProcessImpl() {
        try {
            this.closeStreams();
        }
        finally {
            this.doDestroyProcess();
        }
    }

    protected void doDestroyProcess() {
        ((Process)this.getProcess()).destroy();
    }

    protected void detachProcessImpl() {
        Runnable runnable2 = () -> {
            this.closeStreams();
            this.myWaitFor.detach();
            this.notifyProcessDetached();
        };
        BaseRemoteProcessHandler.executeOnPooledThread(runnable2);
    }

    protected void closeStreams() {
        try {
            ((Process)this.myProcess).getOutputStream().close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean detachIsDefault() {
        return false;
    }

    public OutputStream getProcessInput() {
        return ((Process)this.myProcess).getOutputStream();
    }

    @Nullable
    public Charset getCharset() {
        return this.myCharset;
    }

    @NotNull
    private static Future<?> executeOnPooledThread(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/remote/BaseRemoteProcessHandler", "executeOnPooledThread"));
        }
        Future<?> future2 = AppExecutorUtil.getAppExecutorService().submit(task);
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/BaseRemoteProcessHandler", "executeOnPooledThread"));
        }
        return future2;
    }

    @NotNull
    public Future<?> executeTask(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/remote/BaseRemoteProcessHandler", "executeTask"));
        }
        Future<?> future2 = BaseRemoteProcessHandler.executeOnPooledThread(task);
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/BaseRemoteProcessHandler", "executeTask"));
        }
        return future2;
    }

    @Nullable
    public String getCommandLine() {
        return this.myCommandLine;
    }

    private static abstract class RemoteOutputReader
    extends BaseOutputReader {
        @NotNull
        private final RemoteProcess myRemoteProcess;
        private boolean myClosed;

        RemoteOutputReader(@NotNull InputStream inputStream, Charset charset, @NotNull RemoteProcess remoteProcess, @NotNull String commandLine) {
            if (inputStream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/remote/BaseRemoteProcessHandler$RemoteOutputReader", "<init>"));
            }
            if (remoteProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteProcess", "com/intellij/remote/BaseRemoteProcessHandler$RemoteOutputReader", "<init>"));
            }
            if (commandLine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/remote/BaseRemoteProcessHandler$RemoteOutputReader", "<init>"));
            }
            super(inputStream, charset);
            this.myRemoteProcess = remoteProcess;
            this.start(CommandLineUtil.extractPresentableName((String)commandLine));
        }

        protected void doRun() {
            try {
                this.setClosed(false);
                while (true) {
                    boolean read = this.readAvailable();
                    if (this.myRemoteProcess.isDisconnected()) {
                        this.myReader.close();
                        break;
                    }
                    if (this.isStopped) {
                        break;
                    }
                    Thread.sleep(this.mySleepingPolicy.getTimeToSleep(read));
                }
            }
            catch (InterruptedException read) {
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            finally {
                this.setClosed(true);
            }
        }

        protected synchronized void setClosed(boolean closed) {
            this.myClosed = closed;
        }

        public void waitFor() throws InterruptedException {
            while (!this.isClosed()) {
                Thread.sleep(100L);
            }
        }

        private synchronized boolean isClosed() {
            return this.myClosed;
        }
    }
}

