/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.configuration.deployment.ArtifactDeploymentSource;
import com.intellij.remoteServer.impl.util.ArtifactDeploymentRuntimeProviderBase;
import com.intellij.remoteServer.impl.util.RepositoryDeploymentConfiguration;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentRuntime;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.File;

public abstract class RepositoryArtifactDeploymentRuntimeProviderBase
extends ArtifactDeploymentRuntimeProviderBase {
    @Override
    protected CloudDeploymentRuntime doCreateDeploymentRuntime(ArtifactDeploymentSource artifactSource, File artifactFile, CloudMultiSourceServerRuntimeInstance serverRuntime, DeploymentTask<? extends CloudDeploymentNameConfiguration> deploymentTask, DeploymentLogManager logManager) throws ServerRuntimeException {
        File repositoryRootFile;
        RepositoryDeploymentConfiguration config = (RepositoryDeploymentConfiguration)deploymentTask.getConfiguration();
        String repositoryPath = config.getRepositoryPath();
        if (StringUtil.isEmpty((String)repositoryPath)) {
            File repositoryParentFolder = new File(PathManager.getSystemPath(), "cloud-git-artifact-deploy");
            repositoryRootFile = FileUtil.findSequentNonexistentFile((File)repositoryParentFolder, (String)artifactFile.getName(), (String)"");
        } else {
            repositoryRootFile = new File(repositoryPath);
        }
        if (!FileUtil.createDirectory((File)repositoryRootFile)) {
            throw new ServerRuntimeException("Unable to create deploy folder: " + repositoryRootFile);
        }
        config.setRepositoryPath(repositoryRootFile.getAbsolutePath());
        return this.doCreateDeploymentRuntime(artifactSource, artifactFile, serverRuntime, deploymentTask, logManager, repositoryRootFile);
    }

    protected abstract CloudDeploymentRuntime doCreateDeploymentRuntime(ArtifactDeploymentSource var1, File var2, CloudMultiSourceServerRuntimeInstance var3, DeploymentTask<? extends CloudDeploymentNameConfiguration> var4, DeploymentLogManager var5, File var6) throws ServerRuntimeException;
}

