/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.ModuleDeploymentSourceImpl;
import com.intellij.remoteServer.util.CloudBundle;

public class CloudRunConfigurationUtil {
    public static <SC extends ServerConfiguration, DC extends DeploymentConfiguration> DeployToServerRunConfiguration<SC, DC> createRunConfiguration(RemoteServer<SC> account, Module module2, DC deploymentConfiguration) {
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)module2.getProject()).create(module2);
        ModuleDeploymentSourceImpl deploymentSource = new ModuleDeploymentSourceImpl(modulePointer);
        return CloudRunConfigurationUtil.createRunConfiguration(account, module2, (DeploymentSource)deploymentSource, deploymentConfiguration);
    }

    public static <SC extends ServerConfiguration, DC extends DeploymentConfiguration> DeployToServerRunConfiguration<SC, DC> createRunConfiguration(RemoteServer<SC> account, Module module2, DeploymentSource deploymentSource, DC deploymentConfiguration) {
        Project project2 = module2.getProject();
        String accountName = account.getName();
        String name = CloudRunConfigurationUtil.generateRunConfigurationName(accountName, module2.getName());
        RunManagerEx runManager = RunManagerEx.getInstanceEx(project2);
        ConfigurationFactory configurationFactory = CloudRunConfigurationUtil.getRunConfigurationType(account.getType()).getConfigurationFactories()[0];
        RunnerAndConfigurationSettings runSettings = runManager.createRunConfiguration(name, configurationFactory);
        DeployToServerRunConfiguration result2 = (DeployToServerRunConfiguration)runSettings.getConfiguration();
        result2.setServerName(accountName);
        result2.setDeploymentSource(deploymentSource);
        result2.setDeploymentConfiguration(deploymentConfiguration);
        ((ConfigurationFactoryEx)configurationFactory).onNewConfigurationCreated(runSettings.getConfiguration());
        runManager.addConfiguration(runSettings, false);
        runManager.setSelectedConfiguration(runSettings);
        return result2;
    }

    private static DeployToServerConfigurationType getRunConfigurationType(ServerType<?> cloudType) {
        String id = DeployToServerConfigurationType.getId(cloudType);
        for (ConfigurationType configurationType : (ConfigurationType[])ConfigurationType.CONFIGURATION_TYPE_EP.getExtensions()) {
            DeployToServerConfigurationType deployConfigurationType;
            if (!(configurationType instanceof DeployToServerConfigurationType) || !(deployConfigurationType = (DeployToServerConfigurationType)configurationType).getId().equals(id)) continue;
            return deployConfigurationType;
        }
        return null;
    }

    private static String generateRunConfigurationName(String serverName, String moduleName) {
        return CloudBundle.getText("run.configuration.name", serverName, moduleName);
    }
}

