/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.slicer.CanItBeNullAction;
import com.intellij.slicer.GroupByLeavesAction;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceLeafAnalyzer;
import com.intellij.slicer.SliceNullnessAnalyzer;
import com.intellij.slicer.SliceTreeBuilder;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRenderer;
import com.intellij.slicer.SliceUsageCellRendererBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSliceProvider
implements SliceLanguageSupportProvider {
    @Override
    @NotNull
    public SliceUsage createRootUsage(@NotNull PsiElement element, @NotNull SliceAnalysisParams params) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/JavaSliceProvider", "createRootUsage"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/slicer/JavaSliceProvider", "createRootUsage"));
        }
        JavaSliceUsage javaSliceUsage = JavaSliceUsage.createRootUsage(element, params);
        if (javaSliceUsage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/JavaSliceProvider", "createRootUsage"));
        }
        return javaSliceUsage;
    }

    @Override
    @Nullable
    public PsiElement getExpressionAtCaret(PsiElement atCaret, boolean dataFlowToThis) {
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)atCaret, (Class[])new Class[]{PsiExpression.class, PsiVariable.class});
        if (dataFlowToThis && element instanceof PsiLiteralExpression) {
            return null;
        }
        return element;
    }

    @Override
    @NotNull
    public PsiElement getElementForDescription(@NotNull PsiElement element) {
        PsiElement elementToSlice;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/JavaSliceProvider", "getElementForDescription"));
        }
        if (element instanceof PsiReferenceExpression && (elementToSlice = ((PsiReferenceExpression)element).resolve()) != null) {
            PsiElement psiElement = elementToSlice;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/JavaSliceProvider", "getElementForDescription"));
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/JavaSliceProvider", "getElementForDescription"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public SliceUsageCellRendererBase getRenderer() {
        SliceUsageCellRenderer sliceUsageCellRenderer = new SliceUsageCellRenderer();
        if (sliceUsageCellRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/JavaSliceProvider", "getRenderer"));
        }
        return sliceUsageCellRenderer;
    }

    @Override
    public void startAnalyzeLeafValues(@NotNull AbstractTreeStructure structure, @NotNull Runnable finalRunnable) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/slicer/JavaSliceProvider", "startAnalyzeLeafValues"));
        }
        if (finalRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finalRunnable", "com/intellij/slicer/JavaSliceProvider", "startAnalyzeLeafValues"));
        }
        SliceLeafAnalyzer.startAnalyzeValues(structure, finalRunnable);
    }

    @Override
    public void startAnalyzeNullness(@NotNull AbstractTreeStructure structure, @NotNull Runnable finalRunnable) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/slicer/JavaSliceProvider", "startAnalyzeNullness"));
        }
        if (finalRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finalRunnable", "com/intellij/slicer/JavaSliceProvider", "startAnalyzeNullness"));
        }
        SliceNullnessAnalyzer.startAnalyzeNullness(structure, finalRunnable);
    }

    @Override
    public void registerExtraPanelActions(@NotNull DefaultActionGroup actionGroup, @NotNull SliceTreeBuilder sliceTreeBuilder) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/slicer/JavaSliceProvider", "registerExtraPanelActions"));
        }
        if (sliceTreeBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sliceTreeBuilder", "com/intellij/slicer/JavaSliceProvider", "registerExtraPanelActions"));
        }
        if (sliceTreeBuilder.dataFlowToThis) {
            actionGroup.add((AnAction)new GroupByLeavesAction(sliceTreeBuilder));
            actionGroup.add((AnAction)new CanItBeNullAction(sliceTreeBuilder));
        }
    }
}

