/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.gtk;

import com.intellij.Patches;
import com.intellij.ui.plaf.gtk.GtkPaintingUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.synth.SynthContext;

public class IconWrapper
implements Icon {
    private final Icon myIcon;
    private final MenuItemUI myOriginalUI;

    public IconWrapper(Icon icon, MenuItemUI originalUI) {
        this.myIcon = icon;
        this.myOriginalUI = originalUI;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (Patches.USE_REFLECTION_TO_ACCESS_JDK7) {
            try {
                Method paintIcon = this.myIcon.getClass().getMethod("paintIcon", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                paintIcon.setAccessible(true);
                paintIcon.invoke((Object)this.myIcon, GtkPaintingUtil.getSynthContext(this.myOriginalUI, (JComponent)c), g, x, y, this.getIconWidth(), this.getIconHeight());
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.myIcon.paintIcon(c, g, x, y);
    }

    @Override
    public int getIconWidth() {
        return this.myIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.myIcon.getIconHeight();
    }
}

