/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.switcher;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.ui.switcher.QuickAccessSettings;
import com.intellij.ui.switcher.SwitchManager;
import com.intellij.ui.switcher.SwitchProvider;
import com.intellij.ui.switcher.SwitchingSession;
import java.awt.event.KeyEvent;

public abstract class SwitchAction
extends AnAction
implements DumbAware {
    protected SwitchAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(AnActionEvent e) {
        if (!SwitchAction.getSettings().isEnabled()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        SwitchingSession session2 = SwitchAction.getSession(e);
        e.getPresentation().setEnabled(session2 != null && !session2.isFinished() || SwitchAction.getProvider(e) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        SwitchingSession session2 = SwitchAction.getSession(e);
        if (session2 == null || session2.isFinished()) {
            SwitchProvider provider = SwitchAction.getProvider(e);
            session2 = new SwitchingSession(SwitchAction.getManager(e), provider, (KeyEvent)e.getInputEvent(), null, false);
            SwitchAction.initSession(e, session2);
        }
        this.move(session2);
    }

    protected static QuickAccessSettings getSettings() {
        return QuickAccessSettings.getInstance();
    }

    private static SwitchProvider getProvider(AnActionEvent e) {
        return (SwitchProvider)e.getData(SwitchProvider.KEY);
    }

    private static SwitchingSession getSession(AnActionEvent e) {
        return SwitchAction.getManager(e).getSession();
    }

    private static SwitchManager getManager(AnActionEvent e) {
        Project project2 = e.getProject();
        return SwitchManager.getInstance((Project)project2);
    }

    private static void initSession(AnActionEvent e, SwitchingSession session2) {
        SwitchAction.getManager(e).initSession(session2);
    }

    protected abstract void move(SwitchingSession var1);

    public static class Right
    extends SwitchAction {
        @Override
        protected void move(SwitchingSession session2) {
            session2.right();
        }
    }

    public static class Left
    extends SwitchAction {
        @Override
        protected void move(SwitchingSession session2) {
            session2.left();
        }
    }

    public static class Down
    extends SwitchAction {
        @Override
        protected void move(SwitchingSession session2) {
            session2.down();
        }
    }

    public static class Up
    extends SwitchAction {
        @Override
        protected void move(SwitchingSession session2) {
            session2.up();
        }
    }
}

