/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.stubs.FileStub;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FileStubSerializer
implements ObjectStubSerializer<FileStub, Stub> {
    static final FileStubSerializer INSTANCE = new FileStubSerializer();

    @NotNull
    public String getExternalId() {
        if ("FileStubSerializer" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/stubs/FileStubSerializer", "getExternalId"));
        }
        return "FileStubSerializer";
    }

    public void serialize(@NotNull FileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/util/xml/stubs/FileStubSerializer", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/util/xml/stubs/FileStubSerializer", "serialize"));
        }
        XmlFileHeader header = stub.getHeader();
        dataStream.writeName(header.getRootTagLocalName());
        dataStream.writeName(header.getRootTagNamespace());
        dataStream.writeName(header.getPublicId());
        dataStream.writeName(header.getSystemId());
    }

    @NotNull
    public FileStub deserialize(@NotNull StubInputStream dataStream, Stub parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/util/xml/stubs/FileStubSerializer", "deserialize"));
        }
        FileStub fileStub = new FileStub(dataStream.readName(), dataStream.readName(), dataStream.readName(), dataStream.readName());
        if (fileStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/stubs/FileStubSerializer", "deserialize"));
        }
        return fileStub;
    }

    public void indexStub(@NotNull FileStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/util/xml/stubs/FileStubSerializer", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/util/xml/stubs/FileStubSerializer", "indexStub"));
        }
    }

    public String toString() {
        return "File";
    }
}

