/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsShowToolWindowTabAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/VcsShowToolWindowTabAction", "actionPerformed"));
        }
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ToolWindow toolWindow = (ToolWindow)ObjectUtils.assertNotNull((Object)VcsShowToolWindowTabAction.getToolWindow(project2));
        final ChangesViewContentManager changesViewContentManager = (ChangesViewContentManager)ChangesViewContentManager.getInstance(project2);
        final String tabName = this.getTabName();
        boolean contentAlreadySelected = changesViewContentManager.isContentSelected(tabName);
        if (toolWindow.isActive() && contentAlreadySelected) {
            toolWindow.hide(null);
        } else {
            Runnable runnable2 = contentAlreadySelected ? null : new Runnable(){

                @Override
                public void run() {
                    changesViewContentManager.selectContent(tabName, true);
                }
            };
            toolWindow.activate(runnable2, true, true);
        }
    }

    @Nullable
    private static ToolWindow getToolWindow(@Nullable Project project2) {
        if (project2 == null) {
            return null;
        }
        return ToolWindowManager.getInstance((Project)project2).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/VcsShowToolWindowTabAction", "update"));
        }
        super.update(e);
        e.getPresentation().setEnabledAndVisible(VcsShowToolWindowTabAction.getToolWindow(e.getProject()) != null);
    }

    @NotNull
    protected abstract String getTabName();
}

