/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.util.NotNullFunction;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class GraphElementComparatorByLayoutIndex
implements Comparator<GraphElement> {
    @NotNull
    private final NotNullFunction<Integer, Integer> myLayoutIndexGetter;

    public GraphElementComparatorByLayoutIndex(@NotNull NotNullFunction<Integer, Integer> layoutIndexGetter) {
        if (layoutIndexGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutIndexGetter", "com/intellij/vcs/log/graph/impl/print/GraphElementComparatorByLayoutIndex", "<init>"));
        }
        this.myLayoutIndexGetter = layoutIndexGetter;
    }

    @Override
    public int compare(@NotNull GraphElement o1, @NotNull GraphElement o2) {
        if (o1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/vcs/log/graph/impl/print/GraphElementComparatorByLayoutIndex", "compare"));
        }
        if (o2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/vcs/log/graph/impl/print/GraphElementComparatorByLayoutIndex", "compare"));
        }
        if (o1 instanceof GraphEdge && o2 instanceof GraphEdge) {
            GraphEdge edge1 = (GraphEdge)o1;
            GraphEdge edge2 = (GraphEdge)o2;
            NormalEdge normalEdge1 = LinearGraphUtils.asNormalEdge(edge1);
            NormalEdge normalEdge2 = LinearGraphUtils.asNormalEdge(edge2);
            if (normalEdge1 == null) {
                return -this.compare2(edge2, new GraphNode(LinearGraphUtils.getNotNullNodeIndex(edge1)));
            }
            if (normalEdge2 == null) {
                return this.compare2(edge1, new GraphNode(LinearGraphUtils.getNotNullNodeIndex(edge2)));
            }
            if (normalEdge1.up == normalEdge2.up) {
                if (this.getLayoutIndex(normalEdge1.down) != this.getLayoutIndex(normalEdge2.down)) {
                    return this.getLayoutIndex(normalEdge1.down) - this.getLayoutIndex(normalEdge2.down);
                }
                return normalEdge1.down - normalEdge2.down;
            }
            if (normalEdge1.up < normalEdge2.up) {
                return this.compare2(edge1, new GraphNode(normalEdge2.up));
            }
            return -this.compare2(edge2, new GraphNode(normalEdge1.up));
        }
        if (o1 instanceof GraphEdge && o2 instanceof GraphNode) {
            return this.compare2((GraphEdge)o1, (GraphNode)o2);
        }
        if (o1 instanceof GraphNode && o2 instanceof GraphEdge) {
            return -this.compare2((GraphEdge)o2, (GraphNode)o1);
        }
        assert (false);
        return 0;
    }

    private int compare2(@NotNull GraphEdge edge, @NotNull GraphNode node) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/impl/print/GraphElementComparatorByLayoutIndex", "compare2"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/vcs/log/graph/impl/print/GraphElementComparatorByLayoutIndex", "compare2"));
        }
        NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(edge);
        if (normalEdge == null) {
            return this.getLayoutIndex(LinearGraphUtils.getNotNullNodeIndex(edge)) - this.getLayoutIndex(node.getNodeIndex());
        }
        int upEdgeLI = this.getLayoutIndex(normalEdge.up);
        int downEdgeLI = this.getLayoutIndex(normalEdge.down);
        int nodeLI = this.getLayoutIndex(node.getNodeIndex());
        if (Math.max(upEdgeLI, downEdgeLI) != nodeLI) {
            return Math.max(upEdgeLI, downEdgeLI) - nodeLI;
        }
        return normalEdge.up - node.getNodeIndex();
    }

    private int getLayoutIndex(int nodeIndex) {
        return (Integer)this.myLayoutIndexGetter.fun((Object)nodeIndex);
    }
}

