/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class HeavyAwareExecutor
implements Disposable {
    private static final int DELAY_MILLIS = 5000;
    @NotNull
    private final AtomicBoolean myIsExecuted;

    public HeavyAwareExecutor(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/vcs/log/impl/HeavyAwareExecutor", "<init>"));
        }
        this.myIsExecuted = new AtomicBoolean(false);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public void execute(@NotNull Runnable command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/vcs/log/impl/HeavyAwareExecutor", "execute"));
        }
        final SingleAlarm alarm = new SingleAlarm(() -> {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/vcs/log/impl/HeavyAwareExecutor", "lambda$execute$0"));
            }
            if (!HeavyProcessLatch.INSTANCE.isRunning() && this.myIsExecuted.compareAndSet(false, true)) {
                Disposer.dispose((Disposable)this);
                command.run();
            }
        }, 5000, Alarm.ThreadToUse.SWING_THREAD, this);
        HeavyProcessLatch.INSTANCE.addListener((Disposable)alarm, new HeavyProcessLatch.HeavyProcessListener(){

            public void processStarted() {
                alarm.cancel();
            }

            public void processFinished() {
                if (!HeavyProcessLatch.INSTANCE.isRunning()) {
                    alarm.request();
                }
            }
        });
        if (!HeavyProcessLatch.INSTANCE.isRunning()) {
            alarm.request();
        }
    }

    public void dispose() {
    }
}

