/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.StatisticsUtilKt;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogFeaturesCollector
extends AbstractApplicationUsagesCollector {
    public static final GroupDescriptor ID = GroupDescriptor.create("VCS Log Ui Settings");

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project2) throws CollectUsagesException {
        VcsLogUiImpl ui;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector", "getProjectUsages"));
        }
        VcsProjectLog projectLog = VcsProjectLog.getInstance(project2);
        if (projectLog != null && (ui = projectLog.getMainLogUi()) != null) {
            HashSet usages = ContainerUtil.newHashSet();
            usages.add(StatisticsUtilKt.getBooleanUsage("ui.branches.panel", ui.isBranchesPanelVisible()));
            usages.add(StatisticsUtilKt.getBooleanUsage("ui.details", ui.isShowDetails()));
            usages.add(StatisticsUtilKt.getBooleanUsage("ui.long.edges", ui.areLongEdgesVisible()));
            usages.add(StatisticsUtilKt.getBooleanUsage("ui.sort.linear.bek", ui.getBekType().equals((Object)PermanentGraph.SortType.LinearBek)));
            usages.add(StatisticsUtilKt.getBooleanUsage("ui.sort.bek", ui.getBekType().equals((Object)PermanentGraph.SortType.Bek)));
            usages.add(StatisticsUtilKt.getBooleanUsage("ui.sort.normal", ui.getBekType().equals((Object)PermanentGraph.SortType.Normal)));
            if (ui.isMultipleRoots()) {
                usages.add(StatisticsUtilKt.getBooleanUsage("ui.roots", ui.isShowRootNames()));
            }
            for (VcsLogHighlighterFactory factory : (VcsLogHighlighterFactory[])Extensions.getExtensions(VcsLogUiImpl.LOG_HIGHLIGHTER_FACTORY_EP, (AreaInstance)project2)) {
                if (!factory.showMenuItem()) continue;
                usages.add(StatisticsUtilKt.getBooleanUsage("ui.highlighter." + ConvertUsagesUtil.ensureProperKey(factory.getId()), ui.isHighlighterEnabled(factory.getId())));
            }
            HashSet hashSet = usages;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector", "getProjectUsages"));
            }
            return hashSet;
        }
        Set<UsageDescriptor> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector", "getProjectUsages"));
        }
        return set;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = ID;
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

