/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.HtmlTableBuilder;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.ui.frame.WrappedFlowLayout;
import com.intellij.vcs.log.ui.render.VcsRefPainter;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CommitPanel
extends JBPanel {
    private static final Logger LOG = Logger.getInstance((String)"Vcs.Log");
    public static final int BOTTOM_BORDER = 2;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final ReferencesPanel myReferencesPanel;
    @NotNull
    private final DataPanel myDataPanel;
    @NotNull
    private VisiblePack myDataPack;
    @Nullable
    private VcsFullCommitDetails myCommit;

    public CommitPanel(@NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager, @NotNull VisiblePack dataPack) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/frame/CommitPanel", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/frame/CommitPanel", "<init>"));
        }
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/frame/CommitPanel", "<init>"));
        }
        this.myLogData = logData;
        this.myColorManager = colorManager;
        this.myDataPack = dataPack;
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setOpaque(false);
        this.myReferencesPanel = new ReferencesPanel(this.myColorManager);
        this.myDataPanel = new DataPanel(this.myLogData.getProject(), this.myLogData.isMultiRoot());
        this.add(this.myReferencesPanel);
        this.add(this.myDataPanel);
    }

    public void setDataPack(@NotNull VisiblePack visiblePack) {
        if (visiblePack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePack", "com/intellij/vcs/log/ui/frame/CommitPanel", "setDataPack"));
        }
        this.myDataPack = visiblePack;
    }

    public void setCommit(@NotNull VcsFullCommitDetails commitData) {
        if (commitData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitData", "com/intellij/vcs/log/ui/frame/CommitPanel", "setCommit"));
        }
        if (!Comparing.equal((Object)this.myCommit, (Object)commitData)) {
            if (commitData instanceof LoadingDetails) {
                this.myDataPanel.setData(null);
                this.myReferencesPanel.setReferences(Collections.emptyList());
                this.updateBorder(null);
            } else {
                this.myDataPanel.setData(commitData);
                this.myReferencesPanel.setReferences(this.sortRefs((Hash)commitData.getId(), commitData.getRoot()));
                this.updateBorder(commitData);
            }
            this.myCommit = commitData;
        }
        List<String> branches = null;
        if (!(commitData instanceof LoadingDetails)) {
            branches = this.myLogData.getContainingBranchesGetter().requestContainingBranches(commitData.getRoot(), (Hash)commitData.getId());
        }
        this.myDataPanel.setBranches(branches);
        this.myDataPanel.update();
        this.revalidate();
    }

    public void update() {
        this.myDataPanel.update();
    }

    public void updateBranches() {
        if (this.myCommit != null) {
            this.myDataPanel.setBranches(this.myLogData.getContainingBranchesGetter().getContainingBranchesFromCache(this.myCommit.getRoot(), (Hash)this.myCommit.getId()));
        } else {
            this.myDataPanel.setBranches(null);
        }
        this.myDataPanel.update();
    }

    @NotNull
    private List<VcsRef> sortRefs(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/ui/frame/CommitPanel", "sortRefs"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/frame/CommitPanel", "sortRefs"));
        }
        Collection refs = this.myDataPack.getRefs().refsToCommit(hash, root);
        List list = ContainerUtil.sorted((Collection)refs, (Comparator)this.myLogData.getLogProvider(root).getReferenceManager().getLabelsOrderComparator());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel", "sortRefs"));
        }
        return list;
    }

    private void updateBorder(@Nullable VcsFullCommitDetails data) {
        if (data == null || !this.myColorManager.isMultipleRoots()) {
            this.setBorder((Border)JBUI.Borders.empty((int)2, (int)2, (int)2, (int)0));
        } else {
            JBColor color = VcsLogGraphTable.getRootBackgroundColor(data.getRoot(), this.myColorManager);
            this.setBorder(new CompoundBorder(new MatteBorder(0, 8, 0, 0, (Color)color), new MatteBorder(2, 1, 2, 0, (Color)new JBColor(CommitPanel::getCommitDetailsBackground))));
        }
    }

    public Color getBackground() {
        return CommitPanel.getCommitDetailsBackground();
    }

    public boolean isExpanded() {
        return this.myDataPanel.isExpanded();
    }

    @NotNull
    public static Color getCommitDetailsBackground() {
        Color color = UIUtil.getTableBackground();
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel", "getCommitDetailsBackground"));
        }
        return color;
    }

    @NotNull
    public static String formatDateTime(long time) {
        String string = " on " + DateFormatUtil.formatDate((long)time) + " at " + DateFormatUtil.formatTime((long)time);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel", "formatDateTime"));
        }
        return string;
    }

    private static class SingleReferencePanel
    extends JPanel {
        @NotNull
        private final VcsRefPainter myRefPainter;
        @NotNull
        private VcsRef myReference;

        SingleReferencePanel(@NotNull VcsRefPainter referencePainter, @NotNull VcsRef reference) {
            if (referencePainter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencePainter", "com/intellij/vcs/log/ui/frame/CommitPanel$SingleReferencePanel", "<init>"));
            }
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/vcs/log/ui/frame/CommitPanel$SingleReferencePanel", "<init>"));
            }
            this.myRefPainter = referencePainter;
            this.myReference = reference;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.myRefPainter.paint(this.myReference, g, 0, 0);
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.myRefPainter.getSize(this.myReference, (JComponent)this);
        }
    }

    private static class ReferencesPanel
    extends JPanel {
        private static final int H_GAP = 4;
        private static final int V_GAP = 3;
        @NotNull
        private final VcsRefPainter myReferencePainter;
        @NotNull
        private List<VcsRef> myReferences;

        ReferencesPanel(@NotNull VcsLogColorManager colorManager) {
            if (colorManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/frame/CommitPanel$ReferencesPanel", "<init>"));
            }
            super(new WrappedFlowLayout(JBUI.scale((int)4), JBUI.scale((int)3)));
            this.myReferencePainter = new VcsRefPainter(colorManager, false);
            this.myReferences = Collections.emptyList();
            this.setOpaque(false);
        }

        void setReferences(@NotNull List<VcsRef> references) {
            if (references == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/vcs/log/ui/frame/CommitPanel$ReferencesPanel", "setReferences"));
            }
            this.removeAll();
            this.myReferences = references;
            for (VcsRef reference : references) {
                this.add(new SingleReferencePanel(this.myReferencePainter, reference));
            }
            this.setVisible(!this.myReferences.isEmpty());
            this.revalidate();
            this.repaint();
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }
    }

    private static class DataPanel
    extends JEditorPane {
        private static final int PER_ROW = 3;
        private static final String LINK_HREF = "show-hide-branches";
        @NotNull
        private final Project myProject;
        private final boolean myMultiRoot;
        @Nullable
        private String myMainText;
        @Nullable
        private List<String> myBranches;
        private boolean myExpanded;

        DataPanel(@NotNull Project project2, boolean multiRoot) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "<init>"));
            }
            super("text/html", "");
            this.myExpanded = false;
            this.myProject = project2;
            this.myMultiRoot = multiRoot;
            this.setEditable(false);
            this.setOpaque(false);
            this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            DefaultCaret caret = (DefaultCaret)this.getCaret();
            caret.setUpdatePolicy(1);
            this.setBorder((Border)JBUI.Borders.empty((int)2, (int)4, (int)0, (int)0));
            this.addHyperlinkListener(e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && LINK_HREF.equals(e.getDescription())) {
                    this.myExpanded = !this.myExpanded;
                    this.update();
                } else {
                    BrowserHyperlinkListener.INSTANCE.hyperlinkUpdate(e);
                }
            });
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.update();
        }

        void setData(@Nullable VcsFullCommitDetails commit) {
            if (commit == null) {
                this.myMainText = null;
            } else {
                String header = DataPanel.getHtmlWithFonts(((Hash)commit.getId()).toShortString() + " " + DataPanel.getAuthorText(commit) + (this.myMultiRoot ? " [" + commit.getRoot().getName() + "]" : ""));
                String body = this.getMessageText(commit);
                this.myMainText = header + "<br/>" + body;
            }
        }

        @NotNull
        private static String getHtmlWithFonts(@NotNull String input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getHtmlWithFonts"));
            }
            String string = DataPanel.getHtmlWithFonts(input, VcsHistoryUtil.getCommitDetailsFont().getStyle());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getHtmlWithFonts"));
            }
            return string;
        }

        @NotNull
        private static String getHtmlWithFonts(@NotNull String input, int style) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getHtmlWithFonts"));
            }
            String string = FontUtil.getHtmlWithFonts(input, style, VcsHistoryUtil.getCommitDetailsFont());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getHtmlWithFonts"));
            }
            return string;
        }

        void setBranches(@Nullable List<String> branches) {
            this.myBranches = branches == null ? null : branches;
            this.myExpanded = false;
        }

        void update() {
            if (this.myMainText == null) {
                this.setText("");
            } else {
                this.setText("<html><head>" + UIUtil.getCssFontDeclaration((Font)VcsHistoryUtil.getCommitDetailsFont()) + "</head><body>" + this.myMainText + "<br/>" + "<br/>" + this.getBranchesText() + "</body></html>");
            }
            this.revalidate();
            this.repaint();
        }

        @NotNull
        private String getBranchesText() {
            if (this.myBranches == null) {
                if ("<i>In branches: loading...</i>" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getBranchesText"));
                }
                return "<i>In branches: loading...</i>";
            }
            if (this.myBranches.isEmpty()) {
                if ("<i>Not in any branch</i>" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getBranchesText"));
                }
                return "<i>Not in any branch</i>";
            }
            if (this.myExpanded) {
                int rowCount = (int)Math.ceil((double)this.myBranches.size() / 3.0);
                int[] means = new int[2];
                int[] max = new int[2];
                for (int i = 0; i < rowCount; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        int index = rowCount * j + i;
                        if (index >= this.myBranches.size()) continue;
                        int n = j;
                        means[n] = means[n] + this.myBranches.get(index).length();
                        max[j] = Math.max(this.myBranches.get(index).length(), max[j]);
                    }
                }
                int j = 0;
                while (j < 2) {
                    int n = j++;
                    means[n] = means[n] / rowCount;
                }
                HtmlTableBuilder builder = new HtmlTableBuilder();
                for (int i = 0; i < rowCount; ++i) {
                    builder.startRow();
                    for (int j2 = 0; j2 < 3; ++j2) {
                        int index = rowCount * j2 + i;
                        if (index >= this.myBranches.size()) {
                            builder.append("");
                            continue;
                        }
                        String branch = this.myBranches.get(index);
                        if (index != this.myBranches.size() - 1) {
                            int space = 0;
                            if (j2 < 2 && branch.length() == max[j2]) {
                                space = Math.max(means[j2] + 20 - max[j2], 5);
                            }
                            builder.append(branch + StringUtil.repeat((String)"&nbsp;", (int)space), "left");
                            continue;
                        }
                        builder.append(branch, "left");
                    }
                    builder.endRow();
                }
                String string = "<i>In " + this.myBranches.size() + " branches:</i> " + "<a href=\"" + LINK_HREF + "\"><i>(click to hide)</i></a><br>" + builder.build();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getBranchesText"));
                }
                return string;
            }
            int totalMax = 0;
            int charCount = 0;
            for (String b : this.myBranches) {
                ++totalMax;
                if ((charCount += b.length()) < 50) continue;
                break;
            }
            String branchText = this.myBranches.size() <= totalMax ? StringUtil.join(this.myBranches, (String)", ") : StringUtil.join((Collection)ContainerUtil.getFirstItems(this.myBranches, (int)totalMax), (String)", ") + "\u2026 <a href=\"" + LINK_HREF + "\"><i>(click to show all)</i></a>";
            String string = "<i>In " + this.myBranches.size() + StringUtil.pluralize((String)" branch", (int)this.myBranches.size()) + ":</i> " + branchText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getBranchesText"));
            }
            return string;
        }

        @NotNull
        private String getMessageText(@NotNull VcsFullCommitDetails commit) {
            if (commit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getMessageText"));
            }
            String fullMessage = commit.getFullMessage();
            int separator = fullMessage.indexOf("\n\n");
            String subject = separator > 0 ? fullMessage.substring(0, separator) : fullMessage;
            String description = fullMessage.substring(subject.length());
            String string = "<b>" + DataPanel.getHtmlWithFonts(DataPanel.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, subject)), 1) + "</b>" + DataPanel.getHtmlWithFonts(DataPanel.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, description)));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getMessageText"));
            }
            return string;
        }

        @NotNull
        private static String escapeMultipleSpaces(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "escapeMultipleSpaces"));
            }
            StringBuilder result2 = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) == ' ') {
                    if (i == text.length() - 1 || text.charAt(i + 1) != ' ') {
                        result2.append(' ');
                        continue;
                    }
                    result2.append("&nbsp;");
                    continue;
                }
                result2.append(text.charAt(i));
            }
            String string = result2.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "escapeMultipleSpaces"));
            }
            return string;
        }

        @NotNull
        private static String getAuthorText(@NotNull VcsFullCommitDetails commit) {
            if (commit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getAuthorText"));
            }
            long authorTime = commit.getAuthorTime();
            long commitTime = commit.getCommitTime();
            String authorText = VcsUserUtil.getShortPresentation(commit.getAuthor()) + CommitPanel.formatDateTime(authorTime);
            if (!VcsUserUtil.isSamePerson(commit.getAuthor(), commit.getCommitter())) {
                String commitTimeText = authorTime != commitTime ? CommitPanel.formatDateTime(commitTime) : "";
                authorText = authorText + " (committed by " + VcsUserUtil.getShortPresentation(commit.getCommitter()) + commitTimeText + ")";
            } else if (authorTime != commitTime) {
                authorText = authorText + " (committed " + CommitPanel.formatDateTime(commitTime) + ")";
            }
            String string = authorText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getAuthorText"));
            }
            return string;
        }

        @Override
        public String getSelectedText() {
            Document doc = this.getDocument();
            int start = this.getSelectionStart();
            int end = this.getSelectionEnd();
            try {
                Position p0 = doc.createPosition(start);
                Position p1 = doc.createPosition(end);
                StringWriter sw = new StringWriter(p1.getOffset() - p0.getOffset());
                this.getEditorKit().write(sw, doc, p0.getOffset(), p1.getOffset() - p0.getOffset());
                return StringUtil.removeHtmlTags((String)sw.toString());
            }
            catch (IOException | BadLocationException e) {
                LOG.warn((Throwable)e);
                return super.getSelectedText();
            }
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }

        public boolean isExpanded() {
            return this.myExpanded;
        }
    }
}

