/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.render.TextLabelPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class VcsRefPainter {
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final TextLabelPainter myTextLabelPainter;

    public VcsRefPainter(@NotNull VcsLogColorManager colorManager, boolean paintRoot) {
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/render/VcsRefPainter", "<init>"));
        }
        this.myColorManager = colorManager;
        this.myTextLabelPainter = TextLabelPainter.createPainter(paintRoot && colorManager.isMultipleRoots());
    }

    public void paint(@NotNull VcsRef reference, @NotNull Graphics g, int paddingX, int paddingY) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/vcs/log/ui/render/VcsRefPainter", "paint"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/vcs/log/ui/render/VcsRefPainter", "paint"));
        }
        this.myTextLabelPainter.paint((Graphics2D)g, reference.getName(), paddingX, paddingY, reference.getType().getBackgroundColor(), (Color)VcsLogColorManagerImpl.getIndicatorColor(this.myColorManager.getRootColor(reference.getRoot())));
    }

    public Rectangle paint(@NotNull String text, @NotNull Graphics g, int paddingX, int paddingY, @NotNull Color color, @NotNull Color flagColor) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/render/VcsRefPainter", "paint"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/vcs/log/ui/render/VcsRefPainter", "paint"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/vcs/log/ui/render/VcsRefPainter", "paint"));
        }
        if (flagColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flagColor", "com/intellij/vcs/log/ui/render/VcsRefPainter", "paint"));
        }
        return this.myTextLabelPainter.paint((Graphics2D)g, text, paddingX, paddingY, color, flagColor);
    }

    public Dimension getSize(@NotNull VcsRef reference, @NotNull JComponent component) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/vcs/log/ui/render/VcsRefPainter", "getSize"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/vcs/log/ui/render/VcsRefPainter", "getSize"));
        }
        return this.getSize(reference.getName(), component);
    }

    public Dimension getSize(@NotNull String referenceName, @NotNull JComponent component) {
        if (referenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/vcs/log/ui/render/VcsRefPainter", "getSize"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/vcs/log/ui/render/VcsRefPainter", "getSize"));
        }
        return this.myTextLabelPainter.calculateSize(referenceName, component.getFontMetrics(TextLabelPainter.getFont()));
    }

    public int getHeight(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/vcs/log/ui/render/VcsRefPainter", "getHeight"));
        }
        return this.myTextLabelPainter.calculateSize((String)"", (FontMetrics)component.getFontMetrics((Font)TextLabelPainter.getFont())).height;
    }
}

